/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.item.TaglockItem;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.poppet.PoppetHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\nH\u0016J \u0010 \u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001dH\u0016J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006%"}, d2={"Ldev/sterner/witchery/content/item/BoneNeedleItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "hasCraftingRemainingItem", "", "isRepairable", "arg", "Lnet/minecraft/world/item/ItemStack;", "getCraftingRemainingItem", "itemStack", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "getUseDuration", "", "stack", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "finishUsingItem", "livingEntity", "interactLivingEntity", "interactionTarget", "Companion", "witchery"})
public class BoneNeedleItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BoneNeedleItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.durability(16));
    }

    public boolean hasCraftingRemainingItem() {
        return true;
    }

    public boolean isRepairable(@NotNull ItemStack arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return false;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int damage = itemStack.getDamageValue() + 1;
        ItemStack copy = itemStack.copy();
        copy.setDamageValue(damage);
        Intrinsics.checkNotNull((Object)copy);
        return copy;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (state.is(BlockTags.WOOL) && player != null) {
            player.hurt(player.damageSources().playerAttack(player), 2.0f);
            level.setBlockAndUpdate(pos, ((Block)WitcheryBlocks.INSTANCE.getBLOOD_STAINED_WOOL().get()).defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.getOffhandItem().is(Items.GLASS_BOTTLE) && state.is(BlockTags.BEDS) && level.getServer() != null) {
            if (state.getValue((Property)BedBlock.PART) != BedPart.HEAD) {
                pos = pos.relative((Direction)state.getValue((Property)BedBlock.FACING));
            }
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            for (ServerPlayer serverPlayer : minecraftServer.getPlayerList().getPlayers()) {
                if (!Intrinsics.areEqual((Object)serverPlayer.getRespawnPosition(), (Object)pos)) continue;
                ItemStack taglock = ((TaglockItem)((Object)WitcheryItems.INSTANCE.getTAGLOCK().get())).getDefaultInstance();
                Intrinsics.checkNotNull((Object)serverPlayer);
                LivingEntity livingEntity = (LivingEntity)serverPlayer;
                Intrinsics.checkNotNull((Object)taglock);
                TaglockItem.Companion.bindPlayerOrLiving(livingEntity, taglock);
                WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(player, InteractionHand.OFF_HAND, taglock);
                level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
                break;
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (player.getOffhandItem().is((Item)WitcheryItems.INSTANCE.getVOODOO_POPPET().get())) {
            ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        InteractionResultHolder interactionResultHolder = super.use(level, player, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 50;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        ItemStack item = livingEntity.getOffhandItem();
        Intrinsics.checkNotNull((Object)item);
        Player boundPlayer = PoppetHandler.INSTANCE.getBoundPlayer(level, item);
        LivingEntity boundEntity = PoppetHandler.INSTANCE.getBoundEntity(level, item);
        if (boundPlayer == null && boundEntity == null) {
            ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
            return itemStack;
        }
        Player player = boundPlayer;
        if (player != null) {
            player.hurt(level.damageSources().cactus(), 2.0f);
        }
        LivingEntity livingEntity2 = boundEntity;
        if (livingEntity2 != null) {
            livingEntity2.hurt(level.damageSources().cactus(), 2.0f);
        }
        item.setDamageValue(item.getDamageValue() + 16);
        if (item.getDamageValue() >= item.getMaxDamage()) {
            item.shrink(1);
        }
        ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionTarget, (String)"interactionTarget");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack taglock = ((TaglockItem)((Object)WitcheryItems.INSTANCE.getTAGLOCK().get())).getDefaultInstance();
        Level level = player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        ItemStack itemStack = player.getMainHandItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
        Intrinsics.checkNotNull((Object)taglock);
        if (Companion.tryTaglockEntity(level, player, itemStack, interactionTarget, taglock)) {
            stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getTIMESTAMP().get(), (Object)player.level().getGameTime());
            WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(player, InteractionHand.OFF_HAND, taglock);
            return InteractionResult.SUCCESS;
        }
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            stack.hurtAndBreak(1, (ServerLevel)level2, (ServerPlayer)player, BoneNeedleItem::interactLivingEntity$lambda$0);
            ((ServerLevel)level2).playSound(null, interactionTarget.getOnPos(), SoundEvents.STONE_HIT, SoundSource.PLAYERS);
        }
        InteractionResult interactionResult = super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
        return interactionResult;
    }

    private static final void interactLivingEntity$lambda$0(Item it) {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/content/item/BoneNeedleItem$Companion;", "", "<init>", "()V", "tryTaglockEntity", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "taglock", "trySneakyTaglocking", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean tryTaglockEntity(@NotNull Level level, @NotNull Player player, @NotNull ItemStack itemStack, @NotNull LivingEntity target, @NotNull ItemStack taglock) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)taglock, (String)"taglock");
            if (itemStack.is((Item)WitcheryItems.INSTANCE.getBONE_NEEDLE().get()) && player.getOffhandItem().is(Items.GLASS_BOTTLE)) {
                if (target instanceof Player) {
                    if (this.trySneakyTaglocking(player, (Player)target)) {
                        TaglockItem.Companion.bindPlayerOrLiving(target, taglock);
                        level.playSound(null, ((Player)target).getOnPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 0.75f, 1.0f);
                        return true;
                    }
                    level.playSound(null, ((Player)target).getOnPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.NEUTRAL, 0.75f, 1.0f);
                    return false;
                }
                if (target instanceof Mob) {
                    ((Mob)target).setPersistenceRequired();
                }
                TaglockItem.Companion.bindPlayerOrLiving(target, taglock);
                level.playSound(null, target.getOnPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 0.75f, 1.0f);
                return true;
            }
            return false;
        }

        private final boolean trySneakyTaglocking(Player player, Player target) {
            float delta = (target.yHeadRot - player.yHeadRot + 360.0f) % 360.0f;
            float chance = player.isInvisible() ? 0.5f : 0.1f;
            double lightLevelPenalty = 0.25 * ((double)player.level().getMaxLocalRawBrightness(player.getOnPos()) / 15.0);
            if (delta < 90.0f || delta > 270.0f) {
                chance += player.isShiftKeyDown() ? 0.45f : 0.25f;
            }
            return player.getRandom().nextDouble() < (double)chance - lightLevelPenalty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

