/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.BroomEntity;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/item/BroomItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "witchery"})
@SourceDebugExtension(value={"SMAP\nBroomItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroomItem.kt\ndev/sterner/witchery/content/item/BroomItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class BroomItem
extends Item {
    public BroomItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        ItemStack item = context.getItemInHand();
        Direction dir = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        if (Intrinsics.areEqual((Object)item.get((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_OINTMENT().get()), (Object)true)) {
            Player player = context.getPlayer();
            if (player != null) {
                Player it = player;
                boolean bl = false;
                WitcheryApi.INSTANCE.makePlayerWitchy(it);
            }
            Intrinsics.checkNotNull((Object)level);
            BroomEntity broomEntity = new BroomEntity(level);
            BlockPos vec = pos.relative(dir);
            broomEntity.moveTo(vec.getCenter());
            level.addFreshEntity((Entity)broomEntity);
            item.shrink(1);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (Intrinsics.areEqual((Object)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_OINTMENT().get()), (Object)true)) {
            MutableComponent mutableComponent = Component.translatable((String)"witchery.infusion.ointment").setStyle(Style.EMPTY.withColor(new Color(250, 250, 100).getRGB()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

