/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlock;
import dev.sterner.witchery.content.block.ritual.RitualChalkBlock;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/content/item/ChalkItem;", "Lnet/minecraft/world/item/ItemNameBlockItem;", "block", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "decrementUses", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "isBarVisible", "", "getBarWidth", "", "getBarColor", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nChalkItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChalkItem.kt\ndev/sterner/witchery/content/item/ChalkItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class ChalkItem
extends ItemNameBlockItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_USES = 96;

    public ChalkItem(@NotNull Block block, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(block, properties.component((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)96));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Item item = context.getItemInHand().getItem();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.item.ChalkItem");
        ChalkItem item2 = (ChalkItem)item;
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player != null) {
            Player it = player;
            boolean bl = false;
            WitcheryApi.INSTANCE.makePlayerWitchy(it);
        }
        if (level.isClientSide) {
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        if (state.getBlock() instanceof RitualChalkBlock && state.is(item2.getBlock())) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RitualChalkBlock.Companion.getVARIANT(), (Comparable)Integer.valueOf(context.getLevel().random.nextIntBetweenInclusive(0, 15))));
            ItemStack itemStack = context.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            this.decrementUses(itemStack, context.getPlayer());
            return InteractionResult.CONSUME;
        }
        if (state.getBlock() instanceof GoldenChalkBlock && state.is(item2.getBlock())) {
            return InteractionResult.FAIL;
        }
        InteractionResult result = super.useOn(context);
        if (result.consumesAction()) {
            ItemStack itemStack = context.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            this.decrementUses(itemStack, context.getPlayer());
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final void decrementUses(ItemStack stack, Player player) {
        Integer currentUses = (Integer)stack.getOrDefault((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)96);
        int newUses = currentUses - 1;
        if (newUses <= 0) {
            stack.shrink(1);
            Player player2 = player;
            if (player2 != null && (player2 = player2.level()) != null) {
                player2.playSound(null, player.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f + player.level().random.nextFloat() * 0.4f);
            }
        } else {
            stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)newUses);
        }
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer uses = (Integer)stack.getOrDefault((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)96);
        return uses < 96;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer uses = (Integer)stack.getOrDefault((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)96);
        Intrinsics.checkNotNull((Object)uses);
        return Math.round(13.0f * (float)uses.intValue() / (float)96);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer uses = (Integer)stack.getOrDefault((DataComponentType)WitcheryDataComponents.INSTANCE.getCHALK_USES().get(), (Object)96);
        float fraction = (float)uses.intValue() / (float)96;
        return Mth.hsvToRgb((float)(fraction / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/item/ChalkItem$Companion;", "", "<init>", "()V", "MAX_USES", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

