/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import dev.sterner.witchery.content.entity.HuntsmanSpearEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015H\u0016\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/content/item/HuntsmanSpearItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "itemStack", "getUseDuration", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "releaseUsing", "", "user", "timeLeft", "hurtEnemy", "", "stack", "target", "attacker", "witchery"})
public final class HuntsmanSpearItem
extends Item {
    public HuntsmanSpearItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return UseAnim.SPEAR;
    }

    public int getUseDuration(@NotNull ItemStack itemStack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    public void releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity user, int timeLeft) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!(user instanceof Player)) {
            return;
        }
        int useTime = this.getUseDuration(itemStack, user) - timeLeft;
        if (useTime < 10) {
            return;
        }
        if (!level.isClientSide) {
            ItemStack itemStack2 = itemStack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copy(...)");
            HuntsmanSpearEntity spearEntity = new HuntsmanSpearEntity(level, user, itemStack2);
            float power = RangesKt.coerceAtMost((float)0.9f, (float)((float)useTime / 20.0f));
            spearEntity.shootFromRotation((Entity)user, ((Player)user).getXRot(), ((Player)user).getYRot(), 0.0f, power * 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, ((Player)user).getX(), ((Player)user).getY(), ((Player)user).getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!((Player)user).getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        ((Player)user).awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        float bonusDamage;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        float f = bonusDamage = attacker instanceof HornedHuntsmanEntity ? 7.0f : 0.0f;
        if (bonusDamage > 0.0f && target.isAlive()) {
            target.hurt(target.level().damageSources().mobAttack(attacker), bonusDamage);
        }
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }
}

