/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.TeleportRequest;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.misc.AccessoryHandler;
import dev.sterner.witchery.features.misc.TeleportQueueHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0007H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/content/item/IcyNeedleItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "handleSpiritWorldReturn", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "handleManifestationEnd", "Lnet/minecraft/world/entity/player/Player;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "playerHasNoBodyClearInv", "witchery"})
public final class IcyNeedleItem
extends Item {
    public IcyNeedleItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer && WitcheryApi.INSTANCE.isInSpiritWorld((Player)livingEntity)) {
            this.handleSpiritWorldReturn((ServerPlayer)livingEntity, level);
            return stack;
        }
        if (livingEntity instanceof Player && Intrinsics.areEqual((Object)livingEntity.level().dimension(), (Object)Level.OVERWORLD) && ManifestationPlayerAttachment.getData((Player)livingEntity).getManifestationTimer() > 0) {
            this.handleManifestationEnd((Player)livingEntity, level);
            if (!((Player)livingEntity).isCreative()) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    private final void handleSpiritWorldReturn(ServerPlayer player, Level level) {
        MinecraftServer minecraftServer = level.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        ServerLevel overworld = minecraftServer.overworld();
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        Intrinsics.checkNotNull((Object)overworld);
        SleepingLevelAttachment.PlayerSleepingData sleepingData = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(uUID, overworld);
        if (sleepingData != null) {
            ChunkPos chunkPos = new ChunkPos(sleepingData.getPos());
            overworld.setChunkForced(chunkPos.x, chunkPos.z, true);
            UUID uUID2 = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            TeleportQueueHandler.INSTANCE.addRequest(overworld, new TeleportRequest(uUID2, sleepingData.getPos(), chunkPos, level.getGameTime(), 0, null, 48, null));
        } else {
            BlockPos pos;
            BlockPos blockPos = player.getRespawnPosition();
            if (blockPos == null) {
                blockPos = overworld.getSharedSpawnPos();
            }
            if ((pos = blockPos) != null) {
                this.playerHasNoBodyClearInv((Player)player);
                player.teleportTo(overworld, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SetsKt.emptySet(), player.getYRot(), player.getXRot());
            }
        }
    }

    private final void handleManifestationEnd(Player player, Level level) {
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        Level level2 = player.level();
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level2;
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        SleepingLevelAttachment.PlayerSleepingData sleepingData = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(uUID, serverLevel);
        player.getInventory().dropAll();
        ManifestationPlayerAttachment.Data oldData = ManifestationPlayerAttachment.getData(player);
        ManifestationPlayerAttachment.setData(player, new ManifestationPlayerAttachment.Data(oldData.getHasRiteOfManifestation(), 0));
        if (sleepingData != null) {
            ChunkPos chunkPos = new ChunkPos(sleepingData.getPos());
            serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
            UUID uUID2 = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            TeleportQueueHandler.INSTANCE.addRequest(serverLevel, new TeleportRequest(uUID2, sleepingData.getPos(), chunkPos, level.getGameTime(), 0, null, 48, null));
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }

    public final void playerHasNoBodyClearInv(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List itemsToKeep = new ArrayList();
        List armorToKeep = new ArrayList();
        try {
            LivingEntity livingEntity = (LivingEntity)player;
            Object object = WitcheryItems.INSTANCE.getDREAMWEAVER_CHARM().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack charmStack = AccessoryHandler.INSTANCE.checkNoConsume(livingEntity, (Item)object);
            if (charmStack != null) {
                for (ItemStack armor : player.getArmorSlots()) {
                    if (armor.isEmpty()) continue;
                    ItemStack itemStack = armor.copy();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                    armorToKeep.add(itemStack);
                }
            }
            int armor = player.getInventory().getContainerSize();
            for (int i = 0; i < armor; ++i) {
                ItemStack itemStack = player.getInventory().getItem(i);
                if (itemStack.isEmpty() || !itemStack.is(WitcheryTags.INSTANCE.getFROM_SPIRIT_WORLD_TRANSFERABLE())) continue;
                ItemStack itemStack2 = itemStack.copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copy(...)");
                itemsToKeep.add(itemStack2);
            }
            player.getInventory().clearContent();
            for (ItemStack item : itemsToKeep) {
                player.getInventory().add(item);
            }
            for (ItemStack armor2 : armorToKeep) {
                EquipmentSlot slot = player.getEquipmentSlotForItem(armor2);
                player.setItemSlot(slot, armor2);
            }
        }
        catch (Exception e) {
            Witchery.Companion.getLOGGER().error("Error clearing inventory for player with no body", (Throwable)e);
        }
    }
}

