/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.projectile.SunGrenadeProjectile;
import dev.sterner.witchery.content.entity.projectile.ThrownBrewEntity;
import dev.sterner.witchery.content.item.LeonardsUrnItem;
import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import dev.sterner.witchery.content.item.potion.WitcheryPotionItem;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.features.infusion.InfusionHandler;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\tH\u0016J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0016J(\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016\u00a8\u0006+"}, d2={"Ldev/sterner/witchery/content/item/QuartzSphereItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ProjectileItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "finishUsingItem", "stack", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "asProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "pos", "Lnet/minecraft/core/Position;", "direction", "Lnet/minecraft/core/Direction;", "createDispenseConfig", "Lnet/minecraft/world/item/ProjectileItem$DispenseConfig;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nQuartzSphereItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuartzSphereItem.kt\ndev/sterner/witchery/content/item/QuartzSphereItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1761#2,3:152\n*S KotlinDebug\n*F\n+ 1 QuartzSphereItem.kt\ndev/sterner/witchery/content/item/QuartzSphereItem\n*L\n50#1:152,3\n*E\n"})
public final class QuartzSphereItem
extends Item
implements ProjectileItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public QuartzSphereItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack urn;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (Intrinsics.areEqual((Object)itemStack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_SUN().get()), (Object)true)) {
            InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
            return interactionResultHolder;
        }
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack loadedPotion = Companion.getLoadedPotion(itemStack);
        if (loadedPotion != null && (loadedPotion.getItem() instanceof ThrowableBrewItem || loadedPotion.getItem() instanceof ThrowablePotionItem || loadedPotion.getItem() instanceof PotionItem || loadedPotion.getItem() instanceof WitcheryPotionItem) && (urn = LeonardsUrnItem.Companion.findUrn(player)) != null) {
            ItemStack itemStack2;
            boolean bl;
            List<ItemStack> urnPotions;
            block12: {
                urnPotions = LeonardsUrnItem.Companion.getStoredPotions(urn);
                InfusionPlayerAttachment.Data infusion = InfusionPlayerAttachment.getData(player);
                if (infusion.getCharge() < 100 && !player.getAbilities().instabuild) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                    return interactionResultHolder;
                }
                Iterable $this$any$iv = urnPotions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        if (!ItemStack.isSameItemSameComponents((ItemStack)it, (ItemStack)loadedPotion)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                itemStack2 = loadedPotion.copy();
            } else if (!((Collection)urnPotions).isEmpty()) {
                itemStack2 = urnPotions.get(0).copy();
            } else {
                Companion.setLoadedPotion(itemStack, null);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            ItemStack potionToThrow = itemStack2;
            if (!level.isClientSide) {
                ThrownBrewEntity thrownPotion = new ThrownBrewEntity(level, (LivingEntity)player);
                thrownPotion.setItem(potionToThrow);
                thrownPotion.setIsQuartzSphere(true);
                thrownPotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
                level.addFreshEntity((Entity)thrownPotion);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, 60);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
                InfusionHandler.decreaseInfusionCharge(player, 100);
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof ServerPlayer && stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_SUN().get()) && Intrinsics.areEqual((Object)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_SUN().get()), (Object)true)) {
            SunGrenadeProjectile grenade = new SunGrenadeProjectile(level, livingEntity);
            grenade.setItem(stack);
            grenade.shootFromRotation((Entity)livingEntity, ((ServerPlayer)livingEntity).getXRot(), ((ServerPlayer)livingEntity).getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)grenade);
            if (!((ServerPlayer)livingEntity).getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_SUN().get()) && Intrinsics.areEqual((Object)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_SUN().get()), (Object)true)) {
            MutableComponent mutableComponent = Component.translatable((String)"witchery.has_sun").setStyle(Style.EMPTY.withColor(new Color(250, 220, 40).getRGB()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public Projectile asProjectile(@NotNull Level level, @NotNull Position pos, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ItemStack itemStack = Companion.getLoadedPotion(stack);
        if (itemStack == null) {
            itemStack = new ItemStack((ItemLike)Items.SPLASH_POTION);
        }
        ItemStack loadedPotion = itemStack;
        ThrownBrewEntity thrownPotion = new ThrownBrewEntity(level, pos.x(), pos.y(), pos.z());
        thrownPotion.setItem(loadedPotion);
        return (Projectile)thrownPotion;
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        ProjectileItem.DispenseConfig dispenseConfig = ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
        Intrinsics.checkNotNullExpressionValue((Object)dispenseConfig, (String)"build(...)");
        return dispenseConfig;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/item/QuartzSphereItem$Companion;", "", "<init>", "()V", "getLoadedPotion", "Lnet/minecraft/world/item/ItemStack;", "stack", "setLoadedPotion", "", "potion", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ItemStack getLoadedPotion(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            ItemContainerContents itemContainerContents = (ItemContainerContents)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getLOADED_POTION().get());
            if (itemContainerContents == null) {
                return null;
            }
            ItemContainerContents contents = itemContainerContents;
            Iterable iterable = contents.nonEmptyItems();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
            return (ItemStack)CollectionsKt.firstOrNull((Iterable)iterable);
        }

        public final void setLoadedPotion(@NotNull ItemStack stack, @Nullable ItemStack potion) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            ItemContainerContents itemContainerContents = potion == null || potion.isEmpty() ? (ItemContainerContents)stack.remove((DataComponentType)WitcheryDataComponents.INSTANCE.getLOADED_POTION().get()) : (ItemContainerContents)stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getLOADED_POTION().get(), (Object)ItemContainerContents.fromItems((List)CollectionsKt.listOf((Object)potion)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

