/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlock;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.content.entity.CovenWitchEntity;
import dev.sterner.witchery.features.coven.CovenHandler;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fH\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J(\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0014H\u0016\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/content/item/SeerStoneItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "findNearbyRitualCircle", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getUseDuration", "", "entity", "use", "Lnet/minecraft/world/InteractionResultHolder;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "releaseUsing", "", "timeCharged", "onUseTick", "remainingUseDuration", "Companion", "witchery"})
public final class SeerStoneItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SeerStoneItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof ServerPlayer && !level.isClientSide) {
            BlockPos ritualPos = this.findNearbyRitualCircle((Player)livingEntity);
            if (ritualPos != null) {
                int witchCount = CovenHandler.INSTANCE.summonCovenAroundRitual((Player)livingEntity, level, ritualPos);
                if (witchCount > 0) {
                    Object[] objectArray = new Object[]{witchCount};
                    ((ServerPlayer)livingEntity).displayClientMessage((Component)Component.translatable((String)"witchery.coven.summoned", (Object[])objectArray), false);
                    level.playSound(null, ritualPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!((ServerPlayer)livingEntity).isCreative()) {
                        stack.hurtAndBreak(1, (ServerLevel)level, (ServerPlayer)livingEntity, SeerStoneItem::finishUsingItem$lambda$0);
                    }
                } else {
                    ((ServerPlayer)livingEntity).displayClientMessage((Component)Component.translatable((String)"witchery.coven.no_witches"), true);
                }
            } else {
                ((ServerPlayer)livingEntity).displayClientMessage((Component)Component.translatable((String)"witchery.coven.no_ritual"), true);
            }
        }
        return stack;
    }

    private final BlockPos findNearbyRitualCircle(Player player) {
        Level level = player.level();
        int searchRadius = 16;
        BlockPos playerPos = player.blockPosition();
        int x = -searchRadius;
        if (x <= searchRadius) {
            while (true) {
                block1: for (int y = -8; y < 9; ++y) {
                    int z = -searchRadius;
                    if (z > searchRadius) continue;
                    BlockEntity be;
                    BlockPos pos;
                    BlockState state;
                    while (!((state = level.getBlockState(pos = playerPos.offset(x, y, z))).getBlock() instanceof GoldenChalkBlock) || !((be = level.getBlockEntity(pos)) instanceof GoldenChalkBlockEntity)) {
                        if (z == searchRadius) continue block1;
                        ++z;
                    }
                    return pos;
                }
                if (x == searchRadius) break;
                ++x;
            }
        }
        return null;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 80;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        BlockPos ritualPos;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide && (ritualPos = this.findNearbyRitualCircle(player)) == null) {
            player.displayClientMessage((Component)Component.translatable((String)"witchery.coven.no_ritual"), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        player.startUsingItem(usedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        int timeUsed;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (!level.isClientSide && livingEntity instanceof Player && (timeUsed = this.getUseDuration(stack, livingEntity) - timeCharged) < 60) {
            ((Player)livingEntity).displayClientMessage((Component)Component.translatable((String)"witchery.coven.interrupted"), true);
        }
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (level.isClientSide && remainingUseDuration % 20 == 0) {
            Player player = livingEntity instanceof Player ? (Player)livingEntity : null;
            if (player == null) {
                return;
            }
            Player player2 = player;
            Vec3 pos = player2.position();
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, pos.x + (level.random.nextDouble() - 0.5) * 2.0, pos.y + level.random.nextDouble() * 2.0, pos.z + (level.random.nextDouble() - 0.5) * 2.0, 0.0, 0.0, 0.0);
        }
    }

    private static final void finishUsingItem$lambda$0(Item it) {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/content/item/SeerStoneItem$Companion;", "", "<init>", "()V", "summonWitchesAroundCircle", "", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/world/level/Level;", "covenSize", "", "findValidSpawnPosition", "Lnet/minecraft/core/BlockPos;", "origin", "radius", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void summonWitchesAroundCircle(@NotNull Player player, @NotNull Level level, int covenSize) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            BlockPos playerPos = player.blockPosition();
            for (int x = -16; x < 17; ++x) {
                for (int y = -8; y < 9; ++y) {
                    for (int z = -16; z < 17; ++z) {
                        BlockEntity be;
                        BlockPos pos = playerPos.offset(x, y, z);
                        BlockState state = level.getBlockState(pos);
                        if (!(state.getBlock() instanceof GoldenChalkBlock) || !((be = level.getBlockEntity(pos)) instanceof GoldenChalkBlockEntity)) continue;
                        double centerX = (double)pos.getX() + 0.5;
                        double centerY = (double)pos.getY() + 1.0;
                        double centerZ = (double)pos.getZ() + 0.5;
                        double radius = 4.5;
                        double angleIncrement = Math.PI * 2 / (double)covenSize;
                        for (int i = 0; i < covenSize; ++i) {
                            CovenWitchEntity witch;
                            double angle = (double)i * angleIncrement;
                            double targetX = centerX + radius * Math.cos(angle);
                            double targetZ = centerZ + radius * Math.sin(angle);
                            BlockPos targetPos = BlockPos.containing((double)targetX, (double)centerY, (double)targetZ);
                            Intrinsics.checkNotNull((Object)targetPos);
                            BlockPos spawnPos = dev.sterner.witchery.content.item.SeerStoneItem$Companion.findValidSpawnPosition$default(this, level, targetPos, 0, 4, null);
                            if (spawnPos == null) continue;
                            CovenWitchEntity covenWitchEntity = witch = CovenHandler.INSTANCE.summonWitchFromCoven(player, i, new Vec3((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5));
                            if (covenWitchEntity != null) {
                                Optional<BlockPos> optional = Optional.of(pos);
                                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                                covenWitchEntity.setLastRitualPos(optional);
                            }
                            CovenWitchEntity covenWitchEntity2 = witch;
                            if (covenWitchEntity2 == null) continue;
                            covenWitchEntity2.setIsCoven(true);
                        }
                        return;
                    }
                }
            }
        }

        private final BlockPos findValidSpawnPosition(Level level, BlockPos origin, int radius) {
            block0: for (int dy = -1; dy < 2; ++dy) {
                int dx = -radius;
                if (dx > radius) continue;
                while (true) {
                    int dz;
                    if ((dz = -radius) <= radius) {
                        while (true) {
                            BlockPos checkPos;
                            if (level.getBlockState(checkPos = origin.offset(dx, dy, dz)).canBeReplaced() && level.getBlockState(checkPos.above()).canBeReplaced()) {
                                return checkPos;
                            }
                            if (dz == radius) break;
                            ++dz;
                        }
                    }
                    if (dx == radius) continue block0;
                    ++dx;
                }
            }
            return null;
        }

        static /* synthetic */ BlockPos findValidSpawnPosition$default(Companion companion, Level level, BlockPos blockPos, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 2;
            }
            return companion.findValidSpawnPosition(level, blockPos, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

