/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.blood_crucible.BloodCrucibleBlockEntity;
import dev.sterner.witchery.content.block.sacrificial_circle.SacrificialBlockEntity;
import dev.sterner.witchery.content.entity.ElleEntity;
import dev.sterner.witchery.content.entity.LilithEntity;
import dev.sterner.witchery.content.entity.VampireEntity;
import dev.sterner.witchery.core.api.interfaces.VillagerTransfix;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010#\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/content/item/WineGlassItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getDrinkingSound", "Lnet/minecraft/sounds/SoundEvent;", "getEatingSound", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "summonElle", "", "pos", "Lnet/minecraft/core/BlockPos;", "appendHoverText", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "interactLivingEntity", "interactionTarget", "Companion", "witchery"})
public final class WineGlassItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WineGlassItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            AfflictionPlayerAttachment.Data data2;
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)livingEntity, stack);
            ((ServerPlayer)livingEntity).awardStat(Stats.ITEM_USED.get((Object)this));
            if (stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get()) && Intrinsics.areEqual((Object)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get()), (Object)true) && (data2 = AfflictionPlayerAttachment.getData((Player)livingEntity)).getVampireLevel() == 0) {
                VampireLeveling.increaseVampireLevel((ServerPlayer)livingEntity);
                BloodPoolHandler.increaseBlood(livingEntity, 300);
            }
        }
        return new ItemStack((ItemLike)WitcheryItems.INSTANCE.getWINE_GLASS().get());
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        SoundEvent soundEvent = SoundEvents.HONEY_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"HONEY_DRINK");
        return soundEvent;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        SoundEvent soundEvent = SoundEvents.HONEY_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"HONEY_DRINK");
        return soundEvent;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (player.getMainHandItem().get((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get()) != null) {
            InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
            return interactionResultHolder;
        }
        UUID data2 = (UUID)player.getMainHandItem().get((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get());
        if (data2 == null && player.isShiftKeyDown() && player.getOffhandItem().is((Item)WitcheryItems.INSTANCE.getBONE_NEEDLE().get())) {
            player.getMainHandItem().set((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get(), (Object)player.getUUID());
            if (AfflictionPlayerAttachment.getData(player).getVampireLevel() == 10) {
                player.getMainHandItem().set((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get(), (Object)true);
            }
            player.hurt(level.damageSources().playerAttack(player), 4.0f);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)player.getMainHandItem());
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        ItemStack item = context.getItemInHand();
        if (level.getBlockEntity(pos) instanceof BloodCrucibleBlockEntity && player != null) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.blood_crucible.BloodCrucibleBlockEntity");
            BloodCrucibleBlockEntity bloodCrucible = (BloodCrucibleBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)item);
            bloodCrucible.handleWineGlass(player, item);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockEntity(pos) instanceof SacrificialBlockEntity && level.isNight()) {
            Player player2 = player;
            ItemStack wine = player2 != null ? player2.getMainHandItem() : null;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.sacrificial_circle.SacrificialBlockEntity");
            SacrificialBlockEntity be = (SacrificialBlockEntity)blockEntity;
            if (be.getCandles().size() >= 8 && be.getHasSkull()) {
                boolean hasChickenBlood;
                ItemStack itemStack = wine;
                boolean bl = itemStack != null ? itemStack.is((Item)WitcheryItems.INSTANCE.getWINE_GLASS().get()) : false;
                if (bl && (hasChickenBlood = wine.has((DataComponentType)WitcheryDataComponents.INSTANCE.getCHICKEN_BLOOD().get())) && Intrinsics.areEqual((Object)wine.get((DataComponentType)WitcheryDataComponents.INSTANCE.getCHICKEN_BLOOD().get()), (Object)true)) {
                    wine.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCHICKEN_BLOOD().get(), (Object)false);
                    wine.remove((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get());
                    be.setHasSkull(false);
                    be.setChanged();
                    Intrinsics.checkNotNull((Object)level);
                    Intrinsics.checkNotNull((Object)pos);
                    this.summonElle(level, pos, player);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    private final void summonElle(Level level, BlockPos pos, Player player) {
        ElleEntity elle;
        LightningBolt lightning;
        LightningBolt lightningBolt = lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        Intrinsics.checkNotNull((Object)lightningBolt);
        lightningBolt.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
        level.addFreshEntity((Entity)lightning);
        ElleEntity elleEntity = elle = (ElleEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getELLE().get()).create(level);
        Intrinsics.checkNotNull((Object)((Object)elleEntity));
        elleEntity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.4, (double)pos.getZ() + 0.5);
        elle.setOwnerUUID(player.getUUID());
        level.addFreshEntity((Entity)elle);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        boolean bl = stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get());
        boolean bl2 = stack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get());
        if (bl2 && Intrinsics.areEqual((Object)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get()), (Object)true)) {
            MutableComponent mutableComponent = Component.translatable((String)"witchery.vampire_blood").setStyle(Style.EMPTY.withColor(new Color(255, 50, 100).getRGB())).withStyle(ChatFormatting.ITALIC);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            v1 = tooltipComponents.add((Component)mutableComponent);
        } else if (bl && stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get()) != null) {
            MutableComponent mutableComponent = Component.translatable((String)"witchery.blood").setStyle(Style.EMPTY.withColor(new Color(255, 50, 80).getRGB()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            v1 = tooltipComponents.add((Component)mutableComponent);
        } else {
            MutableComponent mutableComponent = Component.translatable((String)"witchery.use_with_needle");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            v1 = tooltipComponents.add((Component)mutableComponent);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionTarget, (String)"interactionTarget");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (!player.level().isClientSide && interactionTarget instanceof LilithEntity && ((Boolean)((LilithEntity)interactionTarget).getEntityData().get(LilithEntity.Companion.getIS_DEFEATED())).booleanValue() && !((LilithEntity)interactionTarget).getHasUsedLilith()) {
            stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get(), (Object)true);
            stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get(), (Object)((LilithEntity)interactionTarget).getUUID());
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            ((LilithEntity)interactionTarget).setHasUsedLilith(true);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
        return interactionResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/item/WineGlassItem$Companion;", "", "<init>", "()V", "applyWineOnVillager", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$EntityInteract;", "player", "Lnet/minecraft/world/entity/player/Player;", "entity", "Lnet/minecraft/world/entity/Entity;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void applyWineOnVillager(@NotNull PlayerInteractEvent.EntityInteract event, @Nullable Player player, @Nullable Entity entity) {
            ItemStack item;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (entity instanceof Villager && player != null && (bl = Intrinsics.areEqual((Object)(item = player.getMainHandItem()).get((DataComponentType)WitcheryDataComponents.INSTANCE.getVAMPIRE_BLOOD().get()), (Object)true)) && AfflictionPlayerAttachment.getData(player).getVampireLevel() >= 9) {
                VillagerTransfix transfix = (VillagerTransfix)entity;
                BloodPoolLivingEntityAttachment.Data blood = BloodPoolLivingEntityAttachment.getData((LivingEntity)entity);
                if (blood.getBloodPool() <= blood.getMaxBlood() / 2 && transfix.witchery$isMesmerized()) {
                    VampireEntity vampire;
                    VampireEntity vampireEntity = vampire = (VampireEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getVAMPIRE().get()).create(player.level());
                    Intrinsics.checkNotNull((Object)((Object)vampireEntity));
                    vampireEntity.moveTo(entity.position(), entity.getXRot(), entity.getYRot());
                    vampire.setOwnerUUID(player.getUUID());
                    vampire.setPersistenceRequired();
                    vampire.setCreationPos(entity.blockPosition());
                    player.level().addFreshEntity((Entity)vampire);
                    entity.discard();
                    if (player instanceof ServerPlayer && VampireLeveling.INSTANCE.canPerformQuest((ServerPlayer)player, 9)) {
                        VampireLeveling.increaseVampireLevel((ServerPlayer)player);
                    }
                    event.setCanceled(true);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

