/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import com.google.common.base.Predicate;
import dev.sterner.witchery.content.item.brew.BrewOfErosionItem;
import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfFrostItem;", "Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "predicate", "Lcom/google/common/base/Predicate;", "Lnet/minecraft/core/Direction;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;Lcom/google/common/base/Predicate;)V", "applyEffectOnEntities", "", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "hasFrog", "", "applyEffectOnBlock", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "witchery"})
public final class BrewOfFrostItem
extends ThrowableBrewItem {
    public BrewOfFrostItem(int color, @NotNull Item.Properties properties, @NotNull Predicate<Direction> predicate) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super(color, properties, predicate);
    }

    public /* synthetic */ BrewOfFrostItem(int n, Item.Properties properties, Predicate predicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            predicate = BrewOfFrostItem::_init_$lambda$0;
        }
        this(n, properties, (Predicate<Direction>)predicate);
    }

    @Override
    public void applyEffectOnEntities(@NotNull Level level, @NotNull LivingEntity livingEntity, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20 * (hasFrog ? 5 : 4), 0));
        livingEntity.extinguishFire();
        int req = livingEntity.getTicksRequiredToFreeze();
        int oldFreeze = livingEntity.getTicksFrozen();
        livingEntity.setTicksFrozen(Math.min(oldFreeze + 20 * (hasFrog ? 5 : 4), req));
    }

    @Override
    public void applyEffectOnBlock(@NotNull Level level, @NotNull BlockHitResult blockHit, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockHit, (String)"blockHit");
        BlockPos blockPos = blockHit.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        List<BlockPos> list = BrewOfErosionItem.Companion.collectPositionsInSphere(blockPos, 2);
        for (BlockPos pos : list) {
            if (level.getBlockState(pos).is(Blocks.WATER)) {
                level.setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
            }
            if (!level.getBlockState(pos).is(Blocks.LAVA)) continue;
            level.setBlockAndUpdate(pos, Blocks.OBSIDIAN.defaultBlockState());
        }
    }

    private static final boolean _init_$lambda$0(Direction it) {
        return true;
    }
}

