/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.api.entity.PlayerShellEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.misc.AccessoryHandler;
import dev.sterner.witchery.features.spirit_world.SleepingLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfSleepingItem;", "Ldev/sterner/witchery/content/item/brew/BrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;)V", "applyEffectOnSelf", "", "player", "Lnet/minecraft/world/entity/player/Player;", "hasFrog", "", "calculateDreamDestination", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "Companion", "witchery"})
public final class BrewOfSleepingItem
extends BrewItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_NEARBY_BLOCKS = 4;
    private static final int SEARCH_RADIUS = 6;

    public BrewOfSleepingItem(int color, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(color, properties, null, 4, null);
    }

    @Override
    public void applyEffectOnSelf(@NotNull Player player, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!Intrinsics.areEqual((Object)player.level().dimension(), (Object)Level.OVERWORLD)) {
            player.sendSystemMessage((Component)Component.translatable((String)"witchery.message.cant_sleep_here"));
            return;
        }
        Pair<List<ItemStack>, List<ItemStack>> pair = Companion.savePlayerItems(player, hasFrog);
        List itemsToKeep = (List)pair.component1();
        List armorToKeep = (List)pair.component2();
        SleepingPlayerEntity sleepingPlayer = Companion.createSleepingEntity(player);
        player.getInventory().clearContent();
        Companion.restoreKeptItems(player, itemsToKeep, armorToKeep);
        player.level().addFreshEntity((Entity)sleepingPlayer);
        Companion.forceLoadPlayerChunk(player);
        ResourceKey<Level> destinationKey = this.calculateDreamDestination(player, hasFrog);
        Companion.teleportToDreamDimension(player, destinationKey);
        super.applyEffectOnSelf(player, hasFrog);
    }

    private final ResourceKey<Level> calculateDreamDestination(Player player, boolean hasFrog) {
        int maxDreamweavers = hasFrog ? 3 : 4;
        int maxFlowingSpirits = 4;
        int maxWispyCotton = hasFrog ? 3 : 4;
        Object object = WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_NIGHTMARES().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int dreamweaverCount = dev.sterner.witchery.content.item.brew.BrewOfSleepingItem$Companion.countNearbyBlocks$default(Companion, player, (Block)object, 0, 4, null);
        Object object2 = WitcheryBlocks.INSTANCE.getFLOWING_SPIRIT_BLOCK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int flowingSpiritCount = dev.sterner.witchery.content.item.brew.BrewOfSleepingItem$Companion.countNearbyBlocks$default(Companion, player, (Block)object2, 0, 4, null);
        Object object3 = WitcheryBlocks.INSTANCE.getWISPY_COTTON().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        int wispyCount = dev.sterner.witchery.content.item.brew.BrewOfSleepingItem$Companion.countNearbyBlocks$default(Companion, player, (Block)object3, 0, 4, null);
        double maxEffectCount = maxDreamweavers + maxFlowingSpirits + maxWispyCotton;
        double effectiveCount = RangesKt.coerceAtMost((int)dreamweaverCount, (int)maxDreamweavers) + RangesKt.coerceAtMost((int)flowingSpiritCount, (int)maxFlowingSpirits) + RangesKt.coerceAtMost((int)wispyCount, (int)maxWispyCotton);
        double goodDreamChance = 0.05 + 0.85 * (effectiveCount / maxEffectCount);
        return player.level().random.nextDouble() < goodDreamChance ? WitcheryWorldgenKeys.INSTANCE.getDREAM() : WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ*\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\nJ\"\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0002J.\u0010\u001c\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001e0\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfSleepingItem$Companion;", "", "<init>", "()V", "MAX_NEARBY_BLOCKS", "", "SEARCH_RADIUS", "teleportToDreamDimension", "", "player", "Lnet/minecraft/world/entity/player/Player;", "destinationKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "createSleepingEntity", "Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity;", "restoreKeptItems", "itemsToKeep", "", "Lnet/minecraft/world/item/ItemStack;", "armorToKeep", "forceLoadPlayerChunk", "respawnPlayer", "newServerPlayer", "countNearbyBlocks", "blockToCheck", "Lnet/minecraft/world/level/block/Block;", "radius", "savePlayerItems", "Lkotlin/Pair;", "", "hasFrog", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void teleportToDreamDimension(@NotNull Player player, @NotNull ResourceKey<Level> destinationKey) {
            int solidY;
            double targetZ;
            double targetY;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(destinationKey, (String)"destinationKey");
            MinecraftServer minecraftServer = player.level().getServer();
            if (minecraftServer == null || (minecraftServer = minecraftServer.getLevel(destinationKey)) == null) {
                return;
            }
            MinecraftServer destination = minecraftServer;
            double targetX = player.getX();
            BlockPos blockPos = BlockPos.containing((double)targetX, (double)(targetY = player.getY()), (double)(targetZ = player.getZ()));
            int n = solidY = !destination.getBlockState(blockPos).isSolid() ? blockPos.getY() : destination.getHeight(Heightmap.Types.MOTION_BLOCKING, blockPos.getX(), blockPos.getZ());
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).teleportTo((ServerLevel)destination, targetX, (double)solidY + 1.0, targetZ, ((ServerPlayer)player).getYRot(), ((ServerPlayer)player).getXRot());
            }
        }

        @NotNull
        public final SleepingPlayerEntity createSleepingEntity(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return PlayerShellEntity.Companion.createSleepFromPlayer(player);
        }

        public final void restoreKeptItems(@NotNull Player player, @NotNull List<ItemStack> itemsToKeep, @NotNull List<ItemStack> armorToKeep) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(itemsToKeep, (String)"itemsToKeep");
            Intrinsics.checkNotNullParameter(armorToKeep, (String)"armorToKeep");
            for (ItemStack keep : itemsToKeep) {
                player.getInventory().add(keep.copy());
            }
            for (ItemStack armor : armorToKeep) {
                EquipmentSlot slot = player.getEquipmentSlotForItem(armor);
                player.setItemSlot(slot, armor.copy());
            }
        }

        public final void forceLoadPlayerChunk(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player.level() instanceof ServerLevel) {
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                ChunkPos chunk = new ChunkPos(player.getOnPos());
                serverLevel.setChunkForced(chunk.x, chunk.z, true);
            }
        }

        public final void respawnPlayer(@Nullable Player newServerPlayer) {
            Player player = newServerPlayer;
            if (!((player != null ? player.level() : null) instanceof ServerLevel)) {
                return;
            }
            Level level = newServerPlayer.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            UUID uUID = newServerPlayer.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            SleepingLevelAttachment.PlayerSleepingData hasSleeping = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(uUID, serverLevel);
            if (hasSleeping != null) {
                ChunkPos chunk = new ChunkPos(hasSleeping.getPos());
                serverLevel.setChunkForced(chunk.x, chunk.z, true);
                SleepingPlayerEntity sleepEntity = (SleepingPlayerEntity)serverLevel.getEntity(hasSleeping.getUuid());
                if (sleepEntity != null) {
                    SleepingPlayerEntity.Companion.replaceWithPlayer(newServerPlayer, sleepEntity);
                } else {
                    Witchery.Companion.getLOGGER().warn("Could not find sleeping entity for player " + newServerPlayer.getUUID());
                }
            }
        }

        private final int countNearbyBlocks(Player player, Block blockToCheck, int radius) {
            Level level = player.level();
            BlockPos pos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
            int count = 0;
            int x = -radius;
            if (x <= radius) {
                while (true) {
                    int y;
                    if ((y = -radius) <= radius) {
                        while (true) {
                            int z;
                            if ((z = -radius) <= radius) {
                                while (true) {
                                    BlockPos currentPos;
                                    if (Intrinsics.areEqual((Object)level.getBlockState(currentPos = pos.offset(x, y, z)).getBlock(), (Object)blockToCheck) && ++count >= 4) {
                                        return count;
                                    }
                                    if (z == radius) break;
                                    ++z;
                                }
                            }
                            if (y == radius) break;
                            ++y;
                        }
                    }
                    if (x == radius) break;
                    ++x;
                }
            }
            return count;
        }

        static /* synthetic */ int countNearbyBlocks$default(Companion companion, Player player, Block block, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 6;
            }
            return companion.countNearbyBlocks(player, block, n);
        }

        @NotNull
        public final Pair<List<ItemStack>, List<ItemStack>> savePlayerItems(@NotNull Player player, boolean hasFrog) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            List itemsToKeep = new ArrayList();
            List armorToKeep = new ArrayList();
            LivingEntity livingEntity = (LivingEntity)player;
            Object object = WitcheryItems.INSTANCE.getDREAMWEAVER_CHARM().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack charmStack = AccessoryHandler.INSTANCE.checkNoConsume(livingEntity, (Item)object);
            if (charmStack != null) {
                for (ItemStack armor : player.getArmorSlots()) {
                    if (armor.isEmpty()) continue;
                    ItemStack itemStack = armor.copy();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                    armorToKeep.add(itemStack);
                    player.getInventory().removeItem(armor);
                }
            }
            int n = player.getInventory().getContainerSize();
            for (int i = 0; i < n; ++i) {
                ItemStack itemStack = player.getInventory().getItem(i);
                if (itemStack.isEmpty() || !itemStack.getItem().builtInRegistryHolder().is(WitcheryTags.INSTANCE.getTO_SPIRIT_WORLD_TRANSFERABLE())) continue;
                ItemStack itemStack2 = player.getInventory().removeItem(i, itemStack.getCount());
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"removeItem(...)");
                itemsToKeep.add(itemStack2);
            }
            return new Pair((Object)itemsToKeep, (Object)armorToKeep);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

