/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfWebsItem;", "Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;)V", "applyEffectOnEntities", "", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "hasFrog", "", "applyEffectOnHitLocation", "location", "Lnet/minecraft/world/phys/Vec3;", "Companion", "witchery"})
public final class BrewOfWebsItem
extends ThrowableBrewItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BrewOfWebsItem(int color, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(color, properties, null, 4, null);
    }

    @Override
    public void applyEffectOnEntities(@NotNull Level level, @NotNull LivingEntity livingEntity, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAVING, 20 * (hasFrog ? 25 : 20), 0));
    }

    @Override
    public void applyEffectOnHitLocation(@NotNull Level level, @NotNull Vec3 location, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        BlockPos blockPos = BlockPos.containing((Position)((Position)location));
        BlockState block = level.getBlockState(blockPos);
        if (block.isAir()) {
            level.setBlockAndUpdate(blockPos, Blocks.COBWEB.defaultBlockState());
        }
        Intrinsics.checkNotNull((Object)blockPos);
        List<BlockPos> list = Companion.collectPositionsInDullSphere(blockPos, hasFrog ? 3 : 2);
        for (BlockPos pos : list) {
            BlockState extraPos = level.getBlockState(pos);
            if (!(level.random.nextDouble() > 0.75) || !extraPos.canBeReplaced() && !extraPos.isAir()) continue;
            level.setBlockAndUpdate(pos, Blocks.COBWEB.defaultBlockState());
        }
    }

    @JvmStatic
    @NotNull
    public static final List<BlockPos> collectPositionsInDullSphere(@NotNull BlockPos center, int radius) {
        return Companion.collectPositionsInDullSphere(center, radius);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfWebsItem$Companion;", "", "<init>", "()V", "collectPositionsInDullSphere", "", "Lnet/minecraft/core/BlockPos;", "center", "radius", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<BlockPos> collectPositionsInDullSphere(@NotNull BlockPos center, int radius) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            List positions = new ArrayList();
            int x = -radius;
            if (x <= radius) {
                while (true) {
                    block1: for (int y = -radius + 1; y < radius; ++y) {
                        int z = -radius;
                        if (z > radius) continue;
                        while (true) {
                            BlockPos offset;
                            if ((offset = new BlockPos(x, y, z)).distSqr(Vec3i.ZERO) <= (double)(radius * radius)) {
                                BlockPos blockPos = center.offset((Vec3i)offset);
                                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                                positions.add(blockPos);
                            }
                            if (z == radius) continue block1;
                            ++z;
                        }
                    }
                    if (x == radius) break;
                    ++x;
                }
            }
            return positions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

