/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.menu;

import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryMenuTypes;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/content/menu/AltarMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "data", "Lnet/minecraft/world/inventory/ContainerData;", "getData", "()Lnet/minecraft/world/inventory/ContainerData;", "setData", "(Lnet/minecraft/world/inventory/ContainerData;)V", "altar", "Ldev/sterner/witchery/content/block/altar/AltarBlockEntity;", "getAltar", "()Ldev/sterner/witchery/content/block/altar/AltarBlockEntity;", "setAltar", "(Ldev/sterner/witchery/content/block/altar/AltarBlockEntity;)V", "getCurrentPower", "getMaxPower", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "stillValid", "", "witchery"})
public final class AltarMenu
extends AbstractContainerMenu {
    @NotNull
    private ContainerData data;
    @Nullable
    private AltarBlockEntity altar;

    public AltarMenu(int containerId, @NotNull Inventory inventory, @NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super((MenuType)WitcheryMenuTypes.INSTANCE.getALTAR_MENU_TYPE().get(), containerId);
        this.data = (ContainerData)new SimpleContainerData(2);
        Optional optional = inventory.player.level().getBlockEntity(buf.readBlockPos(), (BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getALTAR().get());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getBlockEntity(...)");
        AltarBlockEntity altarBlockEntity = this.altar = (AltarBlockEntity)OptionalsKt.getOrNull((Optional)optional);
        if (altarBlockEntity != null) {
            AltarBlockEntity altar = altarBlockEntity;
            boolean bl = false;
            this.data = altar.getData();
        }
        this.addDataSlots(this.data);
    }

    @NotNull
    public final ContainerData getData() {
        return this.data;
    }

    public final void setData(@NotNull ContainerData containerData) {
        Intrinsics.checkNotNullParameter((Object)containerData, (String)"<set-?>");
        this.data = containerData;
    }

    @Nullable
    public final AltarBlockEntity getAltar() {
        return this.altar;
    }

    public final void setAltar(@Nullable AltarBlockEntity altarBlockEntity) {
        this.altar = altarBlockEntity;
    }

    public final int getCurrentPower() {
        return this.data.get(0);
    }

    public final int getMaxPower() {
        return this.data.get(1);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }
}

