/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.menu;

import dev.sterner.witchery.content.block.oven.OvenBlockEntity;
import dev.sterner.witchery.content.menu.slot.OvenFuelSlot;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryMenuTypes;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/content/menu/OvenMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "data", "Lnet/minecraft/world/inventory/ContainerData;", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Ldev/sterner/witchery/content/block/oven/OvenBlockEntity;", "stillValid", "", "player", "Lnet/minecraft/world/entity/player/Player;", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "index", "canSmelt", "stack", "isFuel", "isJar", "getBurnProgress", "", "getLitProgress", "isLit", "Companion", "witchery"})
public final class OvenMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ContainerData data;
    @NotNull
    private Level level;
    @Nullable
    private OvenBlockEntity blockEntity;
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int EXTRA_INGREDIENT_SLOT = 3;
    public static final int EXTRA_RESULT_SLOT = 4;

    public OvenMenu(int id, @NotNull Inventory inventory, @NotNull FriendlyByteBuf buf) {
        int i;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super((MenuType)WitcheryMenuTypes.INSTANCE.getOVEN_MENU_TYPE().get(), id);
        this.data = (ContainerData)new SimpleContainerData(4);
        Level level = inventory.player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        BlockPos blockPos = buf.readBlockPos();
        if (this.level.getBlockEntity(blockPos) instanceof OvenBlockEntity) {
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.oven.OvenBlockEntity");
            OvenBlockEntity ovenBlockEntity = this.blockEntity = (OvenBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity));
            this.data = ovenBlockEntity.getDataAccess();
        }
        OvenBlockEntity ovenBlockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity));
        this.addSlot(new Slot((Container)ovenBlockEntity, 0, 36, 17));
        OvenBlockEntity ovenBlockEntity2 = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity2));
        this.addSlot(new Slot((Container)ovenBlockEntity2, 3, 124, 55));
        OvenBlockEntity ovenBlockEntity3 = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity3));
        this.addSlot(new OvenFuelSlot(this, ovenBlockEntity3, 1, 36, 53));
        Player player = inventory.player;
        OvenBlockEntity ovenBlockEntity4 = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity4));
        this.addSlot((Slot)new FurnaceResultSlot(player, (Container)ovenBlockEntity4, 2, 96, 35));
        Player player2 = inventory.player;
        OvenBlockEntity ovenBlockEntity5 = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity5));
        this.addSlot((Slot)new FurnaceResultSlot(player2, (Container)ovenBlockEntity5, 4, 124, 16));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(this.data);
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        OvenBlockEntity ovenBlockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)((Object)ovenBlockEntity));
        return ovenBlockEntity.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot == null || !slot.hasItem()) {
            ItemStack itemStack = resultStack;
            Intrinsics.checkNotNull((Object)itemStack);
            return itemStack;
        }
        ItemStack slotStack = slot.getItem();
        resultStack = slotStack.copy();
        boolean bl = 2 <= index ? index < 5 : false;
        if (bl) {
            if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            slot.onQuickCraft(slotStack, resultStack);
        } else if (index == 0 || index == 1) {
            if (!this.moveItemStackTo(slotStack, 5, 41, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else {
            Intrinsics.checkNotNull((Object)slotStack);
            if (this.isJar(slotStack)) {
                if (!this.moveItemStackTo(slotStack, 1, 2, false)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else if (this.canSmelt(slotStack)) {
                if (!this.moveItemStackTo(slotStack, 0, 1, false)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else if (this.isFuel(slotStack)) {
                if (!this.moveItemStackTo(slotStack, 2, 3, false)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else {
                boolean bl2 = 5 <= index ? index < 32 : false;
                if (bl2) {
                    if (!this.moveItemStackTo(slotStack, 32, 41, false)) {
                        ItemStack itemStack = ItemStack.EMPTY;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                        return itemStack;
                    }
                } else {
                    boolean bl3 = 32 <= index ? index < 41 : false;
                    if (bl3 && !this.moveItemStackTo(slotStack, 5, 32, false)) {
                        ItemStack itemStack = ItemStack.EMPTY;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                        return itemStack;
                    }
                }
            }
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotStack.getCount() == resultStack.getCount()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        slot.onTake(player, slotStack);
        ItemStack itemStack = resultStack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    public final boolean canSmelt(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.level.getRecipeManager().getRecipeFor((RecipeType)WitcheryRecipeTypes.INSTANCE.getOVEN_RECIPE_TYPE().get(), (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    public final boolean isFuel(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return AbstractFurnaceBlockEntity.isFuel((ItemStack)stack);
    }

    public final boolean isJar(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.is((Item)WitcheryItems.INSTANCE.getJAR().get());
    }

    public final float getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public final float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public final boolean isLit() {
        return this.data.get(0) > 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/menu/OvenMenu$Companion;", "", "<init>", "()V", "INGREDIENT_SLOT", "", "FUEL_SLOT", "RESULT_SLOT", "EXTRA_INGREDIENT_SLOT", "EXTRA_RESULT_SLOT", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

