/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.menu;

import dev.sterner.witchery.content.entity.ImpEntity;
import dev.sterner.witchery.core.registry.WitcheryMenuTypes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003>?@B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010'\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00032\b\b\u0002\u0010-\u001a\u00020.J\u0006\u00100\u001a\u00020\u0003J\b\u00101\u001a\u0004\u0018\u00010\u0017J\u0006\u00102\u001a\u00020.J\u0006\u00103\u001a\u00020%J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010*\u001a\u00020\u0003H\u0016J\u0010\u00108\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00109\u001a\u00020%2\u0006\u00106\u001a\u000207H\u0016J\u0018\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u0002052\u0006\u0010<\u001a\u00020=H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006A"}, d2={"Ldev/sterner/witchery/content/menu/SoulTradingMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "impEntity", "Ldev/sterner/witchery/content/entity/ImpEntity;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;Ldev/sterner/witchery/content/entity/ImpEntity;)V", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "getImpEntity", "()Ldev/sterner/witchery/content/entity/ImpEntity;", "availableTrades", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulTrade;", "getAvailableTrades", "()Ljava/util/List;", "setAvailableTrades", "(Ljava/util/List;)V", "availableSouls", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "getAvailableSouls", "setAvailableSouls", "selectedTrades", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SelectedTrade;", "getSelectedTrades", "setSelectedTrades", "selectedSoulIndex", "getSelectedSoulIndex", "()I", "setSelectedSoulIndex", "(I)V", "setTrades", "", "trades", "setSouls", "souls", "selectSoul", "index", "incrementAmount", "tradeIndex", "shift", "", "decrementAmount", "getTotalSoulCost", "getSelectedSoul", "canMakeTrade", "clearSelection", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "stillValid", "removed", "canTakeItemForPickAll", "stack", "slot", "Lnet/minecraft/world/inventory/Slot;", "SoulTrade", "SoulData", "SelectedTrade", "witchery"})
@SourceDebugExtension(value={"SMAP\nSoulTradingMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulTradingMenu.kt\ndev/sterner/witchery/content/menu/SoulTradingMenu\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class SoulTradingMenu
extends AbstractContainerMenu {
    @NotNull
    private final ImpEntity impEntity;
    @NotNull
    private List<SoulTrade> availableTrades;
    @NotNull
    private List<SoulData> availableSouls;
    @NotNull
    private List<SelectedTrade> selectedTrades;
    private int selectedSoulIndex;

    public SoulTradingMenu(int id, @NotNull Inventory playerInventory, @NotNull FriendlyByteBuf buf, @NotNull ImpEntity impEntity) {
        int i;
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)((Object)impEntity), (String)"impEntity");
        super((MenuType)WitcheryMenuTypes.INSTANCE.getSOUL_TRADING_MENU_TYPE().get(), id);
        this.impEntity = impEntity;
        this.availableTrades = CollectionsKt.emptyList();
        this.availableSouls = CollectionsKt.emptyList();
        this.selectedTrades = new ArrayList();
        this.selectedSoulIndex = -1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public final ImpEntity getImpEntity() {
        return this.impEntity;
    }

    public SoulTradingMenu(int id, @NotNull Inventory playerInventory, @NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Entity entity = playerInventory.player.level().getEntity(buf.readInt());
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.entity.ImpEntity");
        this(id, playerInventory, buf, (ImpEntity)entity);
    }

    @NotNull
    public final List<SoulTrade> getAvailableTrades() {
        return this.availableTrades;
    }

    public final void setAvailableTrades(@NotNull List<SoulTrade> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.availableTrades = list;
    }

    @NotNull
    public final List<SoulData> getAvailableSouls() {
        return this.availableSouls;
    }

    public final void setAvailableSouls(@NotNull List<SoulData> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.availableSouls = list;
    }

    @NotNull
    public final List<SelectedTrade> getSelectedTrades() {
        return this.selectedTrades;
    }

    public final void setSelectedTrades(@NotNull List<SelectedTrade> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.selectedTrades = list;
    }

    public final int getSelectedSoulIndex() {
        return this.selectedSoulIndex;
    }

    public final void setSelectedSoulIndex(int n) {
        this.selectedSoulIndex = n;
    }

    public final void setTrades(@NotNull List<SoulTrade> trades) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        this.availableTrades = trades;
    }

    public final void setSouls(@NotNull List<SoulData> souls) {
        Intrinsics.checkNotNullParameter(souls, (String)"souls");
        this.availableSouls = souls;
    }

    public final void selectSoul(int index) {
        this.selectedSoulIndex = index >= 0 && index < this.availableSouls.size() ? index : -1;
    }

    public final void incrementAmount(int tradeIndex, boolean shift) {
        Object v0;
        block4: {
            Iterable iterable = this.selectedTrades;
            for (Object t : iterable) {
                SelectedTrade it = (SelectedTrade)t;
                boolean bl = false;
                if (!(it.getTradeIndex() == tradeIndex)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        SelectedTrade selected = v0;
        if (selected != null) {
            selected.setAmount(RangesKt.coerceAtMost((int)(selected.getAmount() + (shift ? 5 : 1)), (int)64));
        } else if (this.selectedTrades.size() < 3) {
            this.selectedTrades.add(new SelectedTrade(tradeIndex, shift ? 5 : 1));
        }
    }

    public static /* synthetic */ void incrementAmount$default(SoulTradingMenu soulTradingMenu, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        soulTradingMenu.incrementAmount(n, bl);
    }

    public final void decrementAmount(int tradeIndex, boolean shift) {
        Object v0;
        block3: {
            Iterable iterable = this.selectedTrades;
            for (Object t : iterable) {
                SelectedTrade it = (SelectedTrade)t;
                boolean bl = false;
                if (!(it.getTradeIndex() == tradeIndex)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        SelectedTrade selectedTrade = v0;
        if (selectedTrade == null) {
            return;
        }
        SelectedTrade selected = selectedTrade;
        selected.setAmount(selected.getAmount() - (shift ? 5 : 1));
        if (selected.getAmount() <= 0) {
            this.selectedTrades.remove(selected);
        }
    }

    public static /* synthetic */ void decrementAmount$default(SoulTradingMenu soulTradingMenu, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        soulTradingMenu.decrementAmount(n, bl);
    }

    public final int getTotalSoulCost() {
        int total = 0;
        for (SelectedTrade selected : this.selectedTrades) {
            if (selected.getTradeIndex() < 0 || selected.getTradeIndex() >= this.availableTrades.size()) continue;
            SoulTrade trade = this.availableTrades.get(selected.getTradeIndex());
            total += trade.getSoulCost() * selected.getAmount();
        }
        return total;
    }

    @Nullable
    public final SoulData getSelectedSoul() {
        return this.selectedSoulIndex >= 0 && this.selectedSoulIndex < this.availableSouls.size() ? this.availableSouls.get(this.selectedSoulIndex) : null;
    }

    public final boolean canMakeTrade() {
        if (this.selectedTrades.isEmpty()) {
            return false;
        }
        SoulData soulData = this.getSelectedSoul();
        if (soulData == null) {
            return false;
        }
        SoulData soul = soulData;
        return soul.getWeight() >= this.getTotalSoulCost();
    }

    public final void clearSelection() {
        this.selectedTrades.clear();
        this.selectedSoulIndex = -1;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Intrinsics.areEqual((Object)this.impEntity.getTradingPlayer(), (Object)player);
    }

    public void removed(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.impEntity.setTradingPlayer(null);
        super.removed(player);
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slot) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/menu/SoulTradingMenu$SelectedTrade;", "", "tradeIndex", "", "amount", "<init>", "(II)V", "getTradeIndex", "()I", "getAmount", "setAmount", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class SelectedTrade {
        private final int tradeIndex;
        private int amount;

        public SelectedTrade(int tradeIndex, int amount) {
            this.tradeIndex = tradeIndex;
            this.amount = amount;
        }

        public final int getTradeIndex() {
            return this.tradeIndex;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final void setAmount(int n) {
            this.amount = n;
        }

        public final int component1() {
            return this.tradeIndex;
        }

        public final int component2() {
            return this.amount;
        }

        @NotNull
        public final SelectedTrade copy(int tradeIndex, int amount) {
            return new SelectedTrade(tradeIndex, amount);
        }

        public static /* synthetic */ SelectedTrade copy$default(SelectedTrade selectedTrade, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = selectedTrade.tradeIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = selectedTrade.amount;
            }
            return selectedTrade.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "SelectedTrade(tradeIndex=" + this.tradeIndex + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.tradeIndex);
            result = result * 31 + Integer.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SelectedTrade)) {
                return false;
            }
            SelectedTrade selectedTrade = (SelectedTrade)other;
            if (this.tradeIndex != selectedTrade.tradeIndex) {
                return false;
            }
            return this.amount == selectedTrade.amount;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "", "entityId", "", "weight", "entityType", "", "isBlockEntity", "", "<init>", "(IILjava/lang/String;Z)V", "getEntityId", "()I", "getWeight", "getEntityType", "()Ljava/lang/String;", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "witchery"})
    public static final class SoulData {
        private final int entityId;
        private final int weight;
        @NotNull
        private final String entityType;
        private final boolean isBlockEntity;

        public SoulData(int entityId, int weight, @NotNull String entityType, boolean isBlockEntity) {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            this.entityId = entityId;
            this.weight = weight;
            this.entityType = entityType;
            this.isBlockEntity = isBlockEntity;
        }

        public final int getEntityId() {
            return this.entityId;
        }

        public final int getWeight() {
            return this.weight;
        }

        @NotNull
        public final String getEntityType() {
            return this.entityType;
        }

        public final boolean isBlockEntity() {
            return this.isBlockEntity;
        }

        public final int component1() {
            return this.entityId;
        }

        public final int component2() {
            return this.weight;
        }

        @NotNull
        public final String component3() {
            return this.entityType;
        }

        public final boolean component4() {
            return this.isBlockEntity;
        }

        @NotNull
        public final SoulData copy(int entityId, int weight, @NotNull String entityType, boolean isBlockEntity) {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            return new SoulData(entityId, weight, entityType, isBlockEntity);
        }

        public static /* synthetic */ SoulData copy$default(SoulData soulData, int n, int n2, String string, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = soulData.entityId;
            }
            if ((n3 & 2) != 0) {
                n2 = soulData.weight;
            }
            if ((n3 & 4) != 0) {
                string = soulData.entityType;
            }
            if ((n3 & 8) != 0) {
                bl = soulData.isBlockEntity;
            }
            return soulData.copy(n, n2, string, bl);
        }

        @NotNull
        public String toString() {
            return "SoulData(entityId=" + this.entityId + ", weight=" + this.weight + ", entityType=" + this.entityType + ", isBlockEntity=" + this.isBlockEntity + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.entityId);
            result = result * 31 + Integer.hashCode(this.weight);
            result = result * 31 + this.entityType.hashCode();
            result = result * 31 + Boolean.hashCode(this.isBlockEntity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SoulData)) {
                return false;
            }
            SoulData soulData = (SoulData)other;
            if (this.entityId != soulData.entityId) {
                return false;
            }
            if (this.weight != soulData.weight) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entityType, (Object)soulData.entityType)) {
                return false;
            }
            return this.isBlockEntity == soulData.isBlockEntity;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulTrade;", "", "output", "Lnet/minecraft/world/item/ItemStack;", "soulCost", "", "<init>", "(Lnet/minecraft/world/item/ItemStack;I)V", "getOutput", "()Lnet/minecraft/world/item/ItemStack;", "getSoulCost", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class SoulTrade {
        @NotNull
        private final ItemStack output;
        private final int soulCost;

        public SoulTrade(@NotNull ItemStack output, int soulCost) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.output = output;
            this.soulCost = soulCost;
        }

        @NotNull
        public final ItemStack getOutput() {
            return this.output;
        }

        public final int getSoulCost() {
            return this.soulCost;
        }

        @NotNull
        public final ItemStack component1() {
            return this.output;
        }

        public final int component2() {
            return this.soulCost;
        }

        @NotNull
        public final SoulTrade copy(@NotNull ItemStack output, int soulCost) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new SoulTrade(output, soulCost);
        }

        public static /* synthetic */ SoulTrade copy$default(SoulTrade soulTrade, ItemStack itemStack, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                itemStack = soulTrade.output;
            }
            if ((n2 & 2) != 0) {
                n = soulTrade.soulCost;
            }
            return soulTrade.copy(itemStack, n);
        }

        @NotNull
        public String toString() {
            return "SoulTrade(output=" + this.output + ", soulCost=" + this.soulCost + ")";
        }

        public int hashCode() {
            int result = this.output.hashCode();
            result = result * 31 + Integer.hashCode(this.soulCost);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SoulTrade)) {
                return false;
            }
            SoulTrade soulTrade = (SoulTrade)other;
            if (!Intrinsics.areEqual((Object)this.output, (Object)soulTrade.output)) {
                return false;
            }
            return this.soulCost == soulTrade.soulCost;
        }
    }
}

