/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.recipe.oven;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.registry.WitcheryRecipeSerializers;
import dev.sterner.witchery.core.registry.WitcheryRecipeTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002+,B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0016J\f\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\f\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Lnet/minecraft/world/item/crafting/SingleRecipeInput;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "extraIngredient", "result", "Lnet/minecraft/world/item/ItemStack;", "extraOutput", "extraOutputChance", "", "experience", "cookingTime", "", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;FFI)V", "getIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getExtraIngredient", "getResult", "()Lnet/minecraft/world/item/ItemStack;", "getExtraOutput", "getExtraOutputChance", "()F", "getExperience", "getCookingTime", "()I", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "assemble", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Companion", "Serializer", "witchery"})
public final class OvenCookingRecipe
implements Recipe<SingleRecipeInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final Ingredient extraIngredient;
    @NotNull
    private final ItemStack result;
    @NotNull
    private final ItemStack extraOutput;
    private final float extraOutputChance;
    private final float experience;
    private final int cookingTime;
    @NotNull
    public static final String NAME = "oven_cooking";

    public OvenCookingRecipe(@NotNull Ingredient ingredient, @NotNull Ingredient extraIngredient, @NotNull ItemStack result, @NotNull ItemStack extraOutput, float extraOutputChance, float experience, int cookingTime) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)extraIngredient, (String)"extraIngredient");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)extraOutput, (String)"extraOutput");
        this.ingredient = ingredient;
        this.extraIngredient = extraIngredient;
        this.result = result;
        this.extraOutput = extraOutput;
        this.extraOutputChance = extraOutputChance;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public final Ingredient getExtraIngredient() {
        return this.extraIngredient;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public final ItemStack getExtraOutput() {
        return this.extraOutput;
    }

    public final float getExtraOutputChance() {
        return this.extraOutputChance;
    }

    public final float getExperience() {
        return this.experience;
    }

    public final int getCookingTime() {
        return this.cookingTime;
    }

    public boolean matches(@NotNull SingleRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.ingredient.test(input.item());
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.result.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = WitcheryRecipeSerializers.INSTANCE.getOVEN_RECIPE_SERIALIZER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = WitcheryRecipeTypes.INSTANCE.getOVEN_RECIPE_TYPE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe$Companion;", "", "<init>", "()V", "NAME", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "witchery"})
    public static final class Serializer
    implements RecipeSerializer<OvenCookingRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<OvenCookingRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, OvenCookingRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<OvenCookingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, OvenCookingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(Serializer::CODEC$lambda$0$0), (App)Ingredient.CODEC_NONEMPTY.fieldOf("extraIngredient").orElse((Object)Ingredient.of()).forGetter(Serializer::CODEC$lambda$0$1), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(Serializer::CODEC$lambda$0$2), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("extraOutput").forGetter(Serializer::CODEC$lambda$0$3), (App)Codec.FLOAT.fieldOf("extraOutputChance").orElse((Object)Float.valueOf(1.0f)).forGetter(Serializer::CODEC$lambda$0$4), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(Serializer::CODEC$lambda$0$5), (App)Codec.INT.fieldOf("cookingTime").forGetter(Serializer::CODEC$lambda$0$6)).apply((Applicative)obj, OvenCookingRecipe::new);
        }

        private static final Ingredient CODEC$lambda$0$0(OvenCookingRecipe it) {
            return it.getIngredient();
        }

        private static final Ingredient CODEC$lambda$0$1(OvenCookingRecipe it) {
            return it.getExtraIngredient();
        }

        private static final ItemStack CODEC$lambda$0$2(OvenCookingRecipe it) {
            return it.getResult();
        }

        private static final ItemStack CODEC$lambda$0$3(OvenCookingRecipe it) {
            return it.getExtraOutput();
        }

        private static final Float CODEC$lambda$0$4(OvenCookingRecipe it) {
            return Float.valueOf(it.getExtraOutputChance());
        }

        private static final Float CODEC$lambda$0$5(OvenCookingRecipe it) {
            return Float.valueOf(it.getExperience());
        }

        private static final Integer CODEC$lambda$0$6(OvenCookingRecipe it) {
            return it.getCookingTime();
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"fromCodecWithRegistries(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<OvenCookingRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, OvenCookingRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

