/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.content.item.TaglockItem;
import dev.sterner.witchery.core.api.entity.PlayerShellData;
import dev.sterner.witchery.core.registry.WitcheryEntityDataSerializers;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.misc.DeathQueueLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import dev.sterner.witchery.network.SpawnSleepingDeathParticleS2CPayload;
import dev.sterner.witchery.network.SyncSleepingShellS2CPayload;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 D2\u00020\u0001:\u0002CDB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0004J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020!2\u0006\u0010'\u001a\u00020(H&J\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u0010\u00101\u001a\u00020!2\b\u00102\u001a\u0004\u0018\u000100J\f\u00103\u001a\b\u0012\u0004\u0012\u00020504J\u0014\u00106\u001a\u00020!2\f\u00107\u001a\b\u0012\u0004\u0012\u00020504J\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u000209J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020!2\u0006\u0010@\u001a\u00020AH\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006E"}, d2={"Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "data", "Ldev/sterner/witchery/core/api/entity/PlayerShellData;", "getData", "()Ldev/sterner/witchery/core/api/entity/PlayerShellData;", "setData", "(Ldev/sterner/witchery/core/api/entity/PlayerShellData;)V", "hurtCounter", "", "getHurtCounter", "()I", "setHurtCounter", "(I)V", "shellType", "Ldev/sterner/witchery/core/api/entity/PlayerShellEntity$ShellType;", "getShellType", "()Ldev/sterner/witchery/core/api/entity/PlayerShellEntity$ShellType;", "setShellType", "(Ldev/sterner/witchery/core/api/entity/PlayerShellEntity$ShellType;)V", "hurt", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "tick", "", "handleSleepingDamage", "handleShellDeath", "dropInventory", "interactAt", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "vec", "Lnet/minecraft/world/phys/Vec3;", "hand", "Lnet/minecraft/world/InteractionHand;", "mergeSoulWithShell", "getOriginalUUID", "Ljava/util/Optional;", "Ljava/util/UUID;", "setOriginalUUID", "uuid", "getEquipment", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "setEquipment", "equipment", "getModel", "", "setModel", "model", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "ShellType", "Companion", "witchery"})
public abstract class PlayerShellEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PlayerShellData data;
    private int hurtCounter;
    @NotNull
    private ShellType shellType;
    private static final EntityDataAccessor<ResolvableProfile> RESOLVEABLE = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)((EntityDataSerializer)WitcheryEntityDataSerializers.INSTANCE.getRESOLVABLE().get()));
    private static final EntityDataAccessor<Optional<UUID>> UUID = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<NonNullList<ItemStack>> EQUIPMENT = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)((EntityDataSerializer)WitcheryEntityDataSerializers.INSTANCE.getINVENTORY().get()));
    private static final EntityDataAccessor<Byte> MODEL = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> FACEPLANT = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> HURT_TIME = SynchedEntityData.defineId(PlayerShellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PlayerShellEntity(@NotNull EntityType<? extends PlayerShellEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.data = new PlayerShellData(null, null, null, null, null, null, null, 0, 255, null);
        this.shellType = ShellType.SLEEPING;
        this.blocksBuilding = true;
    }

    @NotNull
    public final PlayerShellData getData() {
        return this.data;
    }

    public final void setData(@NotNull PlayerShellData playerShellData) {
        Intrinsics.checkNotNullParameter((Object)playerShellData, (String)"<set-?>");
        this.data = playerShellData;
    }

    public final int getHurtCounter() {
        return this.hurtCounter;
    }

    public final void setHurtCounter(int n) {
        this.hurtCounter = n;
    }

    @NotNull
    protected final ShellType getShellType() {
        return this.shellType;
    }

    protected final void setShellType(@NotNull ShellType shellType) {
        Intrinsics.checkNotNullParameter((Object)((Object)shellType), (String)"<set-?>");
        this.shellType = shellType;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.level() instanceof ServerLevel && this.shellType == ShellType.SLEEPING) {
            return this.handleSleepingDamage(source, amount);
        }
        return super.hurt(source, amount);
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            double motionY = this.getDeltaMovement().y - 0.0625;
            if (this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
                motionY = this.getDeltaMovement().y < 0.0 ? this.getDeltaMovement().y + 0.015 : this.getDeltaMovement().y + (this.getDeltaMovement().y < 0.03 ? 5.0E-4 : 0.0);
            }
            this.setDeltaMovement(this.getDeltaMovement().x * 0.75, RangesKt.coerceAtLeast((double)motionY, (double)-2.0), this.getDeltaMovement().z * 0.75);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (((Number)this.entityData.get(HURT_TIME)).intValue() > 0) {
            this.entityData.set(HURT_TIME, (Object)(((Number)this.entityData.get(HURT_TIME)).intValue() - 1));
        }
        if (!this.level().isClientSide && this.hurtCounter > 0 && this.level().getGameTime() % (long)100 == 0L) {
            int n = this.hurtCounter;
            this.hurtCounter = n + -1;
        }
    }

    public boolean handleSleepingDamage(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int n = this.hurtCounter;
        this.hurtCounter = n + 1;
        this.entityData.set(HURT_TIME, (Object)10);
        this.playSound(SoundEvents.PLAYER_HURT);
        if (this.hurtCounter > 8) {
            this.handleShellDeath();
        }
        return true;
    }

    public void handleShellDeath() {
        this.dropInventory();
        if (this.shellType == ShellType.SLEEPING) {
            UUID uUID = this.uuid;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            SleepingPlayerHandler.INSTANCE.removeBySleepingUUID(uUID, (ServerLevel)level);
            ResolvableProfile resolvableProfile = this.data.getResolvableProfile();
            if ((resolvableProfile != null ? resolvableProfile.id() : null) != null) {
                ResolvableProfile resolvableProfile2 = this.data.getResolvableProfile();
                Intrinsics.checkNotNull((Object)resolvableProfile2);
                if (resolvableProfile2.id().isPresent()) {
                    Level level2 = this.level();
                    Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level2;
                    ResolvableProfile resolvableProfile3 = this.data.getResolvableProfile();
                    Intrinsics.checkNotNull((Object)resolvableProfile3);
                    Object t = resolvableProfile3.id().get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    DeathQueueLevelAttachment.INSTANCE.addDeathToQueue(serverLevel, (UUID)t);
                }
            }
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnSleepingDeathParticleS2CPayload(this.getRandomX(1.5), this.getRandomY(), this.getRandomZ(1.5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected final void dropInventory() {
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), this.data.getMainInventory());
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), this.data.getArmorInventory());
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), this.data.getOffHandInventory());
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), this.data.getExtraInventory());
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player.level() instanceof ServerLevel && hand == InteractionHand.MAIN_HAND && this.shellType == ShellType.SLEEPING && (itemStack = player.getMainHandItem()).is((Item)WitcheryItems.INSTANCE.getBONE_NEEDLE().get()) && player.getOffhandItem().is(Items.GLASS_BOTTLE)) {
            ItemStack taglock = ((TaglockItem)((Object)WitcheryItems.INSTANCE.getTAGLOCK().get())).getDefaultInstance();
            Intrinsics.checkNotNull((Object)taglock);
            TaglockItem.Companion.bindSleepingPlayer(this, taglock);
            WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(player, InteractionHand.OFF_HAND, taglock);
            this.level().playSound(null, BlockPos.containing((Position)((Position)vec)), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.interactAt(player, vec, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactAt(...)");
        return interactionResult;
    }

    public abstract void mergeSoulWithShell(@NotNull Player var1);

    @NotNull
    public final Optional<UUID> getOriginalUUID() {
        Object object = this.entityData.get(UUID);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Optional)object;
    }

    public final void setOriginalUUID(@Nullable UUID uuid) {
        if (uuid == null) {
            this.entityData.set(UUID, Optional.empty());
        } else {
            this.entityData.set(UUID, Optional.of(uuid));
        }
    }

    @NotNull
    public final NonNullList<ItemStack> getEquipment() {
        Object object = this.entityData.get(EQUIPMENT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (NonNullList)object;
    }

    public final void setEquipment(@NotNull NonNullList<ItemStack> equipment) {
        Intrinsics.checkNotNullParameter(equipment, (String)"equipment");
        this.entityData.set(EQUIPMENT, equipment);
    }

    public final byte getModel() {
        Object object = this.entityData.get(MODEL);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).byteValue();
    }

    public final void setModel(byte model) {
        this.entityData.set(MODEL, (Object)model);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(UUID, Optional.empty());
        builder.define(NAME, (Object)"");
        builder.define(EQUIPMENT, (Object)NonNullList.withSize((int)EntriesMappings.entries$0.size(), (Object)ItemStack.EMPTY));
        builder.define(MODEL, (Object)0);
        builder.define(FACEPLANT, (Object)false);
        builder.define(HURT_TIME, (Object)0);
        builder.define(RESOLVEABLE, (Object)new ResolvableProfile(new GameProfile(new UUID(0L, 0L), "")));
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (compound.contains("Data")) {
            CompoundTag compoundTag = compound.getCompound("Data");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            RegistryAccess registryAccess = this.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            this.data = PlayerShellData.Companion.readNbt(compoundTag, (HolderLookup.Provider)registryAccess);
        }
        ResolvableProfile resolvableProfile = this.data.getResolvableProfile();
        Intrinsics.checkNotNull((Object)resolvableProfile);
        this.entityData.set(RESOLVEABLE, (Object)resolvableProfile);
        this.setEquipment(this.data.getEquipment());
        this.hurtCounter = compound.getInt("HurtCounter");
        this.entityData.set(HURT_TIME, (Object)compound.getShort("HurtTime"));
        this.setModel(compound.getByte("Model"));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        RegistryAccess registryAccess = this.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        compound.put("Data", (Tag)this.data.writeNbt((HolderLookup.Provider)registryAccess));
        compound.put("d", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.entityData.get(RESOLVEABLE)).resultOrPartial().get());
        compound.putInt("HurtCounter", this.hurtCounter);
        compound.putShort("HurtTime", (short)((Number)this.entityData.get(HURT_TIME)).intValue());
        compound.putByte("Model", this.getModel());
    }

    @JvmStatic
    private static final <T extends PlayerShellEntity> T createPlayerShell(Player player, Function1<? super Level, ? extends T> factory, Function1<? super T, Unit> extraInit) {
        return (T)((Object)PlayerShellEntity.Companion.createPlayerShell(player, factory, extraInit));
    }

    @JvmStatic
    @NotNull
    public static final SleepingPlayerEntity createSleepFromPlayer(@NotNull Player player) {
        return Companion.createSleepFromPlayer(player);
    }

    @JvmStatic
    @NotNull
    public static final SoulShellPlayerEntity createShellFromPlayer(@NotNull Player player) {
        return Companion.createShellFromPlayer(player);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JK\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00050\n2\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0007R5\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018Rm\u0010\u0019\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001b0\u001b \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001a0\u001a \u0016*.\u0012(\u0012&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001b0\u001b \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001a0\u001a\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R5\u0010\u001d\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001e0\u001e \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018RM\u0010 \u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\" \u0016*\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0! \u0016*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\" \u0016*\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0!\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R5\u0010$\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010%0% \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010%0%\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018R5\u0010'\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010(0( \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010(0(\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R5\u0010*\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010+0+ \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010+0+\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0018\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/core/api/entity/PlayerShellEntity$Companion;", "", "<init>", "()V", "createPlayerShell", "T", "Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "player", "Lnet/minecraft/world/entity/player/Player;", "factory", "Lkotlin/Function1;", "Lnet/minecraft/world/level/Level;", "extraInit", "", "(Lnet/minecraft/world/entity/player/Player;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ldev/sterner/witchery/core/api/entity/PlayerShellEntity;", "createSleepFromPlayer", "Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity;", "createShellFromPlayer", "Ldev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity;", "RESOLVEABLE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/item/component/ResolvableProfile;", "kotlin.jvm.PlatformType", "getRESOLVEABLE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "UUID", "Ljava/util/Optional;", "Ljava/util/UUID;", "getUUID", "NAME", "", "getNAME", "EQUIPMENT", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getEQUIPMENT", "MODEL", "", "getMODEL", "FACEPLANT", "", "getFACEPLANT", "HURT_TIME", "", "getHURT_TIME", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final <T extends PlayerShellEntity> T createPlayerShell(Player player, Function1<? super Level, ? extends T> factory, Function1<? super T, Unit> extraInit) {
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            PlayerShellEntity entity = (PlayerShellEntity)((Object)factory.invoke((Object)level));
            PlayerShellData data2 = PlayerShellData.Companion.fromPlayer(player);
            entity.setData(data2);
            entity.setEquipment(data2.getEquipment());
            entity.setOriginalUUID(player.getUUID());
            ((Entity)entity).setPos(player.getX(), Math.max(player.getY() + (double)0.2f, (double)player.level().getMinBuildHeight()), player.getZ());
            ((Entity)entity).setYRot(player.getYRot());
            entity.setModel(data2.getModel());
            Function1<? super T, Unit> function1 = extraInit;
            if (function1 != null) {
                function1.invoke((Object)entity);
            }
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncSleepingShellS2CPayload(entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ResolvableProfile resolvableProfile = data2.getResolvableProfile();
            Intrinsics.checkNotNull((Object)resolvableProfile);
            if (!resolvableProfile.isResolved()) {
                ResolvableProfile resolvableProfile2 = data2.getResolvableProfile();
                Intrinsics.checkNotNull((Object)resolvableProfile2);
                resolvableProfile2.resolve().thenAccept(arg_0 -> Companion.createPlayerShell$lambda$1(arg_0 -> Companion.createPlayerShell$lambda$0(entity, arg_0), arg_0));
            }
            return (T)((Object)entity);
        }

        static /* synthetic */ PlayerShellEntity createPlayerShell$default(Companion companion, Player player, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 4) != 0) {
                function12 = null;
            }
            return companion.createPlayerShell(player, function1, function12);
        }

        @JvmStatic
        @NotNull
        public final SleepingPlayerEntity createSleepFromPlayer(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return (SleepingPlayerEntity)((Object)this.createPlayerShell(player, Companion::createSleepFromPlayer$lambda$0, arg_0 -> Companion.createSleepFromPlayer$lambda$1(player, arg_0)));
        }

        @JvmStatic
        @NotNull
        public final SoulShellPlayerEntity createShellFromPlayer(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return (SoulShellPlayerEntity)dev.sterner.witchery.core.api.entity.PlayerShellEntity$Companion.createPlayerShell$default(this, player, Companion::createShellFromPlayer$lambda$0, null, 4, null);
        }

        public final EntityDataAccessor<ResolvableProfile> getRESOLVEABLE() {
            return RESOLVEABLE;
        }

        public final EntityDataAccessor<Optional<UUID>> getUUID() {
            return UUID;
        }

        public final EntityDataAccessor<String> getNAME() {
            return NAME;
        }

        public final EntityDataAccessor<NonNullList<ItemStack>> getEQUIPMENT() {
            return EQUIPMENT;
        }

        public final EntityDataAccessor<Byte> getMODEL() {
            return MODEL;
        }

        public final EntityDataAccessor<Boolean> getFACEPLANT() {
            return FACEPLANT;
        }

        public final EntityDataAccessor<Integer> getHURT_TIME() {
            return HURT_TIME;
        }

        private static final Unit createPlayerShell$lambda$0(PlayerShellEntity $entity, ResolvableProfile resolved) {
            $entity.getData().setResolvableProfile(resolved);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncSleepingShellS2CPayload($entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return Unit.INSTANCE;
        }

        private static final void createPlayerShell$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final SleepingPlayerEntity createSleepFromPlayer$lambda$0(Level it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new SleepingPlayerEntity(it);
        }

        private static final Unit createSleepFromPlayer$lambda$1(Player $player, SleepingPlayerEntity entity) {
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            if ($player.level() instanceof ServerLevel) {
                UUID uUID = $player.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                UUID uUID2 = entity.getOriginalUUID().orElse($player.getUUID());
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"orElse(...)");
                BlockPos blockPos = $player.blockPosition();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                Level level = $player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                SleepingPlayerHandler.INSTANCE.add(uUID, uUID2, blockPos, (ServerLevel)level);
            }
            return Unit.INSTANCE;
        }

        private static final SoulShellPlayerEntity createShellFromPlayer$lambda$0(Level it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new SoulShellPlayerEntity(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/core/api/entity/PlayerShellEntity$ShellType;", "", "<init>", "(Ljava/lang/String;I)V", "SLEEPING", "SOUL", "witchery"})
    public static final class ShellType
    extends Enum<ShellType> {
        public static final /* enum */ ShellType SLEEPING = new ShellType();
        public static final /* enum */ ShellType SOUL = new ShellType();
        private static final /* synthetic */ ShellType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ShellType[] values() {
            return (ShellType[])$VALUES.clone();
        }

        public static ShellType valueOf(String value) {
            return Enum.valueOf(ShellType.class, value);
        }

        @NotNull
        public static EnumEntries<ShellType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = shellTypeArray = new ShellType[]{ShellType.SLEEPING, ShellType.SOUL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

