/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.multiblock;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.core.api.multiblock.IMultiBlockCore;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR.\u0010\u000f\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010j\n\u0012\u0006\u0012\u0004\u0018\u00010\b`\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/IMultiBlockCore;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "structure", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "getStructure", "()Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "componentPositions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getComponentPositions", "()Ljava/util/ArrayList;", "setComponentPositions", "(Ljava/util/ArrayList;)V", "structureOffset", "Lnet/minecraft/core/Vec3i;", "getStructureOffset", "()Lnet/minecraft/core/Vec3i;", "setStructureOffset", "(Lnet/minecraft/core/Vec3i;)V", "onBreak", "", "player", "Lnet/minecraft/world/entity/player/Player;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "witchery"})
public class MultiBlockCoreEntity
extends WitcheryBaseBlockEntity
implements IMultiBlockCore {
    @NotNull
    private final MultiBlockStructure structure;
    @NotNull
    private ArrayList<BlockPos> componentPositions;
    @NotNull
    private Vec3i structureOffset;

    public MultiBlockCoreEntity(@NotNull BlockEntityType<?> type, @NotNull MultiBlockStructure structure, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.structure = structure;
        this.componentPositions = new ArrayList();
        Vec3i vec3i = Vec3i.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"ZERO");
        this.structureOffset = vec3i;
        this.setupMultiBlock(pos, state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : null);
    }

    @Override
    @NotNull
    public MultiBlockStructure getStructure() {
        return this.structure;
    }

    @Override
    @NotNull
    public ArrayList<BlockPos> getComponentPositions() {
        return this.componentPositions;
    }

    public void setComponentPositions(@NotNull ArrayList<BlockPos> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.componentPositions = arrayList;
    }

    @NotNull
    public final Vec3i getStructureOffset() {
        return this.structureOffset;
    }

    public final void setStructureOffset(@NotNull Vec3i vec3i) {
        Intrinsics.checkNotNullParameter((Object)vec3i, (String)"<set-?>");
        this.structureOffset = vec3i;
    }

    @Override
    public void onBreak(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        this.destroyMultiBlock(player, level, this.worldPosition);
        super.onBreak(player);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt("OffsetX", this.structureOffset.getX());
        tag.putInt("OffsetY", this.structureOffset.getY());
        tag.putInt("OffsetZ", this.structureOffset.getZ());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.structureOffset = new Vec3i(tag.getInt("OffsetX"), tag.getInt("OffsetY"), tag.getInt("OffsetZ"));
    }
}

