/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.multiblock;

import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "", "structurePieces", "Ljava/util/ArrayList;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/ArrayList;)V", "getStructurePieces", "()Ljava/util/ArrayList;", "canPlace", "", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "place", "", "StructurePiece", "Companion", "witchery"})
public class MultiBlockStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<StructurePiece> structurePieces;

    public MultiBlockStructure(@NotNull ArrayList<StructurePiece> structurePieces) {
        Intrinsics.checkNotNullParameter(structurePieces, (String)"structurePieces");
        this.structurePieces = structurePieces;
    }

    @NotNull
    public final ArrayList<StructurePiece> getStructurePieces() {
        return this.structurePieces;
    }

    public final boolean canPlace(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.structurePieces.stream().allMatch(arg_0 -> MultiBlockStructure.canPlace$lambda$1(arg_0 -> MultiBlockStructure.canPlace$lambda$0(context, arg_0), arg_0));
    }

    public void place(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.structurePieces.forEach(arg_0 -> MultiBlockStructure.place$lambda$0(context, arg_0));
    }

    private static final boolean canPlace$lambda$0(BlockPlaceContext $context, StructurePiece p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.canPlace($context);
    }

    private static final boolean canPlace$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void place$lambda$0(BlockPlaceContext $context, StructurePiece s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        BlockPos blockPos = $context.getClickedPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        Level level = $context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        StructurePiece.place$default(s, blockPos, level, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$Companion;", "", "<init>", "()V", "of", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "pieces", "", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;", "([Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;)Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiBlockStructure of(StructurePiece ... pieces) {
            Intrinsics.checkNotNullParameter((Object)pieces, (String)"pieces");
            return new MultiBlockStructure(new ArrayList<StructurePiece>(CollectionsKt.listOf((Object[])Arrays.copyOf(pieces, pieces.length))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;", "", "xOffset", "", "yOffset", "zOffset", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(IIILnet/minecraft/world/level/block/state/BlockState;)V", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "offset", "Lnet/minecraft/core/Vec3i;", "getOffset", "()Lnet/minecraft/core/Vec3i;", "canPlace", "", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "clickedPos", "Lnet/minecraft/core/BlockPos;", "place", "", "core", "witchery"})
    public static final class StructurePiece {
        @NotNull
        private final BlockState state;
        @NotNull
        private final Vec3i offset;

        public StructurePiece(int xOffset, int yOffset, int zOffset, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
            this.offset = new Vec3i(xOffset, yOffset, zOffset);
        }

        @NotNull
        public final BlockState getState() {
            return this.state;
        }

        @NotNull
        public final Vec3i getOffset() {
            return this.offset;
        }

        public final boolean canPlace(@NotNull BlockPlaceContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Level level = context.getLevel();
            Player player = context.getPlayer();
            BlockPos pos = context.getClickedPos().offset(this.offset);
            BlockState existingState = context.getLevel().getBlockState(pos);
            Player player2 = player;
            CollisionContext collisioncontext = player2 == null ? CollisionContext.empty() : CollisionContext.of((Entity)((Entity)player2));
            return existingState.canBeReplaced() && level.isUnobstructed(this.state, pos, collisioncontext);
        }

        public final boolean canPlace(@NotNull Level level, @NotNull Player player, @NotNull BlockPos clickedPos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)clickedPos, (String)"clickedPos");
            BlockPos pos = clickedPos.offset(this.offset);
            BlockState existingState = level.getBlockState(pos);
            CollisionContext collisioncontext = CollisionContext.of((Entity)((Entity)player));
            return existingState.canBeReplaced() && level.isUnobstructed(this.state, pos, collisioncontext);
        }

        @JvmOverloads
        public final void place(@NotNull BlockPos core, @NotNull Level level, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)core, (String)"core");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            BlockPos pos = core.offset(this.offset);
            level.setBlock(pos, state, 3);
            if (level.getBlockEntity(pos) instanceof MultiBlockComponentBlockEntity) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity");
                MultiBlockComponentBlockEntity component = (MultiBlockComponentBlockEntity)blockEntity;
                component.setCorePos(core);
            }
        }

        public static /* synthetic */ void place$default(StructurePiece structurePiece, BlockPos blockPos, Level level, BlockState blockState, int n, Object object) {
            if ((n & 4) != 0) {
                blockState = structurePiece.state;
            }
            structurePiece.place(blockPos, level, blockState);
        }

        @JvmOverloads
        public final void place(@NotNull BlockPos core, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)core, (String)"core");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            StructurePiece.place$default(this, core, level, null, 4, null);
        }
    }
}

