/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.registry;

import dev.sterner.witchery.core.registry.WitcheryEntityDataSerializers;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/core/registry/WitcheryEntityDataSerializers;", "", "<init>", "()V", "SERIALIZERS", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "Lnet/minecraft/network/syncher/EntityDataSerializer;", "getSERIALIZERS", "()Lnet/neoforged/neoforge/registries/DeferredRegister;", "INVENTORY", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getINVENTORY", "()Lnet/neoforged/neoforge/registries/DeferredHolder;", "RESOLVABLE", "Lnet/minecraft/world/item/component/ResolvableProfile;", "getRESOLVABLE", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
public final class WitcheryEntityDataSerializers {
    @NotNull
    public static final WitcheryEntityDataSerializers INSTANCE = new WitcheryEntityDataSerializers();
    @NotNull
    private static final DeferredRegister<EntityDataSerializer<?>> SERIALIZERS;
    @NotNull
    private static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<NonNullList<ItemStack>>> INVENTORY;
    @NotNull
    private static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<ResolvableProfile>> RESOLVABLE;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, NonNullList<ItemStack>> CODEC;

    private WitcheryEntityDataSerializers() {
    }

    @NotNull
    public final DeferredRegister<EntityDataSerializer<?>> getSERIALIZERS() {
        return SERIALIZERS;
    }

    @NotNull
    public final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<NonNullList<ItemStack>>> getINVENTORY() {
        return INVENTORY;
    }

    @NotNull
    public final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<ResolvableProfile>> getRESOLVABLE() {
        return RESOLVABLE;
    }

    @NotNull
    public final StreamCodec<RegistryFriendlyByteBuf, NonNullList<ItemStack>> getCODEC() {
        return CODEC;
    }

    private static final INVENTORY.1.1 INVENTORY$lambda$0() {
        return new EntityDataSerializer<NonNullList<ItemStack>>(){

            public StreamCodec<? super RegistryFriendlyByteBuf, NonNullList<ItemStack>> codec() {
                return WitcheryEntityDataSerializers.INSTANCE.getCODEC();
            }

            public NonNullList<ItemStack> copy(NonNullList<ItemStack> itemStacks) {
                Intrinsics.checkNotNullParameter(itemStacks, (String)"itemStacks");
                NonNullList list = NonNullList.withSize((int)itemStacks.size(), (Object)ItemStack.EMPTY);
                int n = ((Collection)itemStacks).size();
                for (int i = 0; i < n; ++i) {
                    list.set(i, (Object)((ItemStack)itemStacks.get(i)).copy());
                }
                Intrinsics.checkNotNull((Object)list);
                return list;
            }
        };
    }

    private static final RESOLVABLE.1.1 RESOLVABLE$lambda$0() {
        return new EntityDataSerializer<ResolvableProfile>(){

            public StreamCodec<? super RegistryFriendlyByteBuf, ResolvableProfile> codec() {
                StreamCodec streamCodec = ResolvableProfile.STREAM_CODEC;
                Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"STREAM_CODEC");
                return streamCodec;
            }

            public ResolvableProfile copy(ResolvableProfile value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ResolvableProfile(value.gameProfile());
            }
        };
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"witchery");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        SERIALIZERS = deferredRegister;
        DeferredHolder deferredHolder = SERIALIZERS.register("inventory", WitcheryEntityDataSerializers::INVENTORY$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder, (String)"register(...)");
        INVENTORY = deferredHolder;
        DeferredHolder deferredHolder2 = SERIALIZERS.register("resolvable", WitcheryEntityDataSerializers::RESOLVABLE$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)deferredHolder2, (String)"register(...)");
        RESOLVABLE = deferredHolder2;
        CODEC = (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, NonNullList<ItemStack>>(){

            public void encode(RegistryFriendlyByteBuf buf, NonNullList<ItemStack> itemStacks) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter(itemStacks, (String)"itemStacks");
                buf.writeInt(itemStacks.size());
                Iterator iterator = itemStacks.iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    ItemStack itemStack = (ItemStack)iterator2.next();
                    ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemStack);
                }
            }

            public NonNullList<ItemStack> decode(RegistryFriendlyByteBuf itemStacks) {
                Intrinsics.checkNotNullParameter((Object)itemStacks, (String)"itemStacks");
                int size = itemStacks.readInt();
                NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                int n = ((Collection)list).size();
                for (int i = 0; i < n; ++i) {
                    list.set(i, ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)itemStacks));
                }
                Intrinsics.checkNotNull((Object)list);
                return list;
            }
        };
    }
}

