/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.world;

import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0006\u001a&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/core/world/WitcheryWorldState;", "Lnet/minecraft/world/level/saveddata/SavedData;", "level", "Lnet/minecraft/server/level/ServerLevel;", "<init>", "(Lnet/minecraft/server/level/ServerLevel;)V", "pendingRestores", "", "Lnet/minecraft/core/GlobalPos;", "Lkotlin/Pair;", "", "", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "getPendingRestores", "()Ljava/util/Map;", "cacheMap", "getCache", "origin", "get", "pos", "put", "", "state", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryWorldState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryWorldState.kt\ndev/sterner/witchery/core/world/WitcheryWorldState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n382#2,7:152\n*S KotlinDebug\n*F\n+ 1 WitcheryWorldState.kt\ndev/sterner/witchery/core/world/WitcheryWorldState\n*L\n23#1:152,7\n*E\n"})
public final class WitcheryWorldState
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final Map<GlobalPos, Pair<Integer, Map<BlockPos, BlockState>>> pendingRestores;
    @NotNull
    private final Map<GlobalPos, Map<BlockPos, BlockState>> cacheMap;

    public WitcheryWorldState(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.level = level;
        this.pendingRestores = new LinkedHashMap();
        this.cacheMap = new LinkedHashMap();
    }

    @NotNull
    public final Map<GlobalPos, Pair<Integer, Map<BlockPos, BlockState>>> getPendingRestores() {
        return this.pendingRestores;
    }

    @Nullable
    public final Map<BlockPos, BlockState> getCache(@NotNull GlobalPos origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return this.cacheMap.get(origin);
    }

    @Nullable
    public final BlockState get(@NotNull GlobalPos origin, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Map<BlockPos, BlockState> map = this.cacheMap.get(origin);
        return map != null ? map.get(pos) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void put(@NotNull GlobalPos origin, @NotNull BlockPos pos, @NotNull BlockState state) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<GlobalPos, Map<BlockPos, BlockState>> map = this.cacheMap;
        GlobalPos key$iv = origin;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map cache = (Map)object;
        cache.put(pos, state);
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag allCaches = new ListTag();
        for (Map.Entry<GlobalPos, Map<BlockPos, BlockState>> object : this.cacheMap.entrySet()) {
            GlobalPos globalPos = object.getKey();
            Map<BlockPos, BlockState> stateMap = object.getValue();
            CompoundTag cacheTag = new CompoundTag();
            cacheTag.put("origin", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)globalPos).result().orElseThrow(() -> WitcheryWorldState.save$lambda$0(globalPos)));
            ListTag stateList = new ListTag();
            for (Map.Entry<BlockPos, BlockState> entry : stateMap.entrySet()) {
                BlockPos pos = entry.getKey();
                BlockState state = entry.getValue();
                CompoundTag entry2 = new CompoundTag();
                entry2.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
                entry2.put("state", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)state).result().orElseThrow(() -> WitcheryWorldState.save$lambda$1(pos)));
                stateList.add((Object)entry2);
            }
            cacheTag.put("states", (Tag)stateList);
            allCaches.add((Object)cacheTag);
        }
        tag.put("StateCaches", (Tag)allCaches);
        ListTag restoreList = new ListTag();
        for (Map.Entry<GlobalPos, Pair<Integer, Map<BlockPos, BlockState>>> entry : this.pendingRestores.entrySet()) {
            GlobalPos globalPos = entry.getKey();
            Pair<Integer, Map<BlockPos, BlockState>> pair = entry.getValue();
            int ticks = ((Number)pair.component1()).intValue();
            Map stateMap = (Map)pair.component2();
            CompoundTag entry3 = new CompoundTag();
            entry3.put("pos", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)globalPos).result().orElseThrow());
            entry3.putInt("ticks", ticks);
            ListTag stateList = new ListTag();
            for (Map.Entry entry2 : stateMap.entrySet()) {
                BlockPos pos = (BlockPos)entry2.getKey();
                BlockState state = (BlockState)entry2.getValue();
                CompoundTag stateTag = new CompoundTag();
                stateTag.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
                stateTag.put("state", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)state).result().orElseThrow());
                stateList.add((Object)stateTag);
            }
            entry3.put("states", (Tag)stateList);
            restoreList.add((Object)entry3);
        }
        tag.put("PendingRestores", (Tag)restoreList);
        return tag;
    }

    private static final IllegalStateException save$lambda$0(GlobalPos $globalOrigin) {
        return new IllegalStateException("Failed to encode GlobalPos " + $globalOrigin);
    }

    private static final IllegalStateException save$lambda$1(BlockPos $pos) {
        return new IllegalStateException("Failed to encode BlockState at " + $pos);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/core/world/WitcheryWorldState$Companion;", "", "<init>", "()V", "factory", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "Ldev/sterner/witchery/core/world/WitcheryWorldState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "witchery"})
    @SourceDebugExtension(value={"SMAP\nWitcheryWorldState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryWorldState.kt\ndev/sterner/witchery/core/world/WitcheryWorldState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SavedData.Factory<WitcheryWorldState> factory(ServerLevel level) {
            return new SavedData.Factory(() -> Companion.factory$lambda$0(level), (arg_0, arg_1) -> Companion.factory$lambda$1(level, arg_0, arg_1), DataFixTypes.LEVEL);
        }

        private final WitcheryWorldState load(ServerLevel level, CompoundTag tag, HolderLookup.Provider registries) {
            WitcheryWorldState data2 = new WitcheryWorldState(level);
            ListTag allCaches = tag.getList("StateCaches", 10);
            Iterator iterator = allCaches.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                GlobalPos globalPos;
                Iterator iterator3;
                Tag cacheTag = (Tag)iterator2.next();
                if (!(cacheTag instanceof CompoundTag) || (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)((CompoundTag)cacheTag).get("origin")).result().orElse(null) == null) continue;
                ListTag stateList = ((CompoundTag)cacheTag).getList("states", 10);
                Map stateMap = new LinkedHashMap();
                Intrinsics.checkNotNullExpressionValue((Object)stateList.iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    BlockState state;
                    BlockPos pos;
                    Tag entry = (Tag)iterator3.next();
                    if (!(entry instanceof CompoundTag)) continue;
                    if (((CompoundTag)entry).get("pos") != null) {
                        Tag it;
                        boolean bl = false;
                        v1 = NbtUtils.readBlockPos((CompoundTag)((CompoundTag)it), (String)"pos").orElse(null);
                    } else {
                        v1 = pos = null;
                    }
                    if (((CompoundTag)entry).get("state") != null) {
                        Tag it;
                        boolean bl = false;
                        v2 = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)it).result().orElse(null);
                    } else {
                        v2 = state = null;
                    }
                    if (pos == null || state == null) continue;
                    stateMap.put(pos, state);
                }
                data2.cacheMap.put(globalPos, stateMap);
            }
            ListTag restoreList = tag.getList("PendingRestores", 10);
            Iterator iterator4 = restoreList.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator4, (String)"iterator(...)");
            Iterator iterator5 = iterator4;
            while (iterator5.hasNext()) {
                GlobalPos globalPos;
                Iterator iterator6;
                Tag entry = (Tag)iterator5.next();
                if (!(entry instanceof CompoundTag) || (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)((CompoundTag)entry).get("pos")).result().orElse(null) == null) continue;
                int ticks = ((CompoundTag)entry).getInt("ticks");
                ListTag stateList = ((CompoundTag)entry).getList("states", 10);
                Map stateMap = new LinkedHashMap();
                Intrinsics.checkNotNullExpressionValue((Object)stateList.iterator(), (String)"iterator(...)");
                while (iterator6.hasNext()) {
                    Tag stateEntry = (Tag)iterator6.next();
                    if (!(stateEntry instanceof CompoundTag)) continue;
                    BlockPos pos = NbtUtils.readBlockPos((CompoundTag)((CompoundTag)stateEntry), (String)"pos").orElse(null);
                    BlockState state = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)((CompoundTag)stateEntry).get("state")).result().orElse(null);
                    if (pos == null || state == null) continue;
                    stateMap.put(pos, state);
                }
                data2.getPendingRestores().put(globalPos, (Pair<Integer, Map<BlockPos, BlockState>>)TuplesKt.to((Object)ticks, (Object)stateMap));
            }
            return data2;
        }

        @NotNull
        public final WitcheryWorldState get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            SavedData savedData = level.getDataStorage().computeIfAbsent(this.factory(level), "witchery_world_state");
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (WitcheryWorldState)savedData;
        }

        private static final WitcheryWorldState factory$lambda$0(ServerLevel $level) {
            return new WitcheryWorldState($level);
        }

        private static final WitcheryWorldState factory$lambda$1(ServerLevel $level, CompoundTag tag, HolderLookup.Provider lookup) {
            Intrinsics.checkNotNull((Object)tag);
            return Companion.load($level, tag, lookup);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

