/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.data_gen.bootstrap;

import com.google.common.collect.ImmutableList;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/data_gen/bootstrap/WitcheryPlacedFeatureBootstrap;", "", "<init>", "()V", "bootstrap", "", "context", "Lnet/minecraft/data/worldgen/BootstrapContext;", "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;", "bushPlacement", "Lcom/google/common/collect/ImmutableList$Builder;", "Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;", "witchery"})
public final class WitcheryPlacedFeatureBootstrap {
    @NotNull
    public static final WitcheryPlacedFeatureBootstrap INSTANCE = new WitcheryPlacedFeatureBootstrap();

    private WitcheryPlacedFeatureBootstrap() {
    }

    public final void bootstrap(@NotNull BootstrapContext<PlacedFeature> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ResourceKey<PlacedFeature> resourceKey = WitcheryWorldgenKeys.INSTANCE.getROWAN_PLACED_KEY();
        Holder holder = (Holder)configuredFeatures.getOrThrow(WitcheryWorldgenKeys.INSTANCE.getROWAN_KEY());
        List list = VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)2), (Block)((Block)WitcheryBlocks.INSTANCE.getROWAN_SAPLING().get()));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"treePlacement(...)");
        context.register(resourceKey, (Object)new PlacedFeature(holder, CollectionsKt.toList((Iterable)list)));
        ResourceKey<PlacedFeature> resourceKey2 = WitcheryWorldgenKeys.INSTANCE.getALDER_PLACED_KEY();
        Holder holder2 = (Holder)configuredFeatures.getOrThrow(WitcheryWorldgenKeys.INSTANCE.getALDER_KEY());
        List list2 = VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)2), (Block)((Block)WitcheryBlocks.INSTANCE.getALDER_SAPLING().get()));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"treePlacement(...)");
        context.register(resourceKey2, (Object)new PlacedFeature(holder2, CollectionsKt.toList((Iterable)list2)));
        ResourceKey<PlacedFeature> resourceKey3 = WitcheryWorldgenKeys.INSTANCE.getHAWTHORN_PLACED_KEY();
        Holder holder3 = (Holder)configuredFeatures.getOrThrow(WitcheryWorldgenKeys.INSTANCE.getHAWTHORN_KEY());
        List list3 = VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)2), (Block)((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_SAPLING().get()));
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"treePlacement(...)");
        context.register(resourceKey3, (Object)new PlacedFeature(holder3, CollectionsKt.toList((Iterable)list3)));
        ResourceKey<PlacedFeature> resourceKey4 = WitcheryWorldgenKeys.INSTANCE.getWISPY_PLACED_KEY();
        Holder holder4 = (Holder)configuredFeatures.getOrThrow(WitcheryWorldgenKeys.INSTANCE.getWISPY_KEY());
        ImmutableList immutableList = this.bushPlacement().build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        context.register(resourceKey4, (Object)new PlacedFeature(holder4, CollectionsKt.toList((Iterable)((Iterable)immutableList))));
        context.register(WitcheryWorldgenKeys.INSTANCE.getWITCH_CIRCLE_PLACED_KEY(), (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(WitcheryWorldgenKeys.INSTANCE.getWITCH_CIRCLE_KEY()), (List)ImmutableList.builder().add((Object)RarityFilter.onAverageOnceEvery((int)16)).add((Object)InSquarePlacement.spread()).add((Object)NoiseThresholdCountPlacement.of((double)-0.8, (int)15, (int)4)).add((Object)PlacementUtils.HEIGHTMAP).add((Object)BiomeFilter.biome()).build()));
    }

    private final ImmutableList.Builder<PlacementModifier> bushPlacement() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)RarityFilter.onAverageOnceEvery((int)6)).add((Object)InSquarePlacement.spread()).add((Object)NoiseThresholdCountPlacement.of((double)-0.8, (int)15, (int)4)).add((Object)PlacementUtils.HEIGHTMAP).add((Object)BiomeFilter.biome());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
        return builder;
    }
}

