/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.event;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ0\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/affliction/event/AfflictionClientEventHandler;", "", "<init>", "()V", "overlay", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "drawAbilityBar", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "player", "Lnet/minecraft/world/entity/player/Player;", "x", "", "y", "drawCooldownOverlay", "iconX", "iconY", "currentCooldown", "maxCooldown", "witchery"})
public final class AfflictionClientEventHandler {
    @NotNull
    public static final AfflictionClientEventHandler INSTANCE = new AfflictionClientEventHandler();
    private static final ResourceLocation overlay = Witchery.Companion.id("textures/gui/ability_hotbar_selection.png");

    private AfflictionClientEventHandler() {
    }

    public final void drawAbilityBar(@NotNull GuiGraphics guiGraphics, @NotNull Player player, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int abilityIndex = AfflictionPlayerAttachment.getData(player).getAbilityIndex();
        List<AfflictionAbility> abilities = AfflictionAbilityHandler.INSTANCE.getAbilities(player);
        int n = ((Collection)abilities).size();
        for (int i = 0; i < n; ++i) {
            String name = abilities.get(i).getId();
            int iconX = x - 25 * i + 4;
            int iconY = y + 4;
            guiGraphics.blit(Witchery.Companion.id("textures/gui/affliction_abilities/" + name + ".png"), iconX, iconY, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
            int cooldown = AbilityCooldownManager.INSTANCE.getCooldown(player, abilities.get(i));
            if (cooldown <= 0) continue;
            this.drawCooldownOverlay(guiGraphics, iconX, iconY, cooldown, abilities.get(i).getCooldown());
        }
        if (abilityIndex != -1) {
            guiGraphics.blit(overlay, x - 25 * abilityIndex, y, 24, 23, 0.0f, 0.0f, 24, 23, 24, 23);
        }
    }

    private final void drawCooldownOverlay(GuiGraphics guiGraphics, int iconX, int iconY, int currentCooldown, int maxCooldown) {
        float cooldownPercent = (float)currentCooldown / (float)maxCooldown;
        int fillStart = iconY + Mth.floor((float)(16.0f * (1.0f - cooldownPercent)));
        int fillEnd = fillStart + Mth.ceil((float)(16.0f * cooldownPercent));
        guiGraphics.fill(RenderType.guiOverlay(), iconX, fillStart, iconX + 16, fillEnd, -1442840576);
    }
}

