/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.lich;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.PhylacteryLevelDataAttachment;
import dev.sterner.witchery.features.necromancy.SoulPoolPlayerAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0015\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/affliction/lich/LichdomSoulPoolHandler;", "", "<init>", "()V", "increaseSouls", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "amount", "pos", "Lnet/minecraft/core/BlockPos;", "decreaseSouls", "getMaxSouls", "getCurrentSouls", "destroyPhylactery", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "getPhylacterySouls", "setMaxSouls", "entity", "Lnet/minecraft/world/entity/player/Player;", "lichLevel", "updateLichHunger", "witchery"})
@SourceDebugExtension(value={"SMAP\nLichdomSoulPoolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LichdomSoulPoolHandler.kt\ndev/sterner/witchery/features/affliction/lich/LichdomSoulPoolHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,149:1\n1#2:150\n774#3:151\n865#3,2:152\n774#3:154\n865#3,2:155\n1788#3,4:157\n69#4,15:161\n*S KotlinDebug\n*F\n+ 1 LichdomSoulPoolHandler.kt\ndev/sterner/witchery/features/affliction/lich/LichdomSoulPoolHandler\n*L\n30#1:151\n30#1:152,2\n62#1:154\n62#1:155,2\n89#1:157,4\n103#1:161,15\n*E\n"})
public final class LichdomSoulPoolHandler {
    @NotNull
    public static final LichdomSoulPoolHandler INSTANCE = new LichdomSoulPoolHandler();

    private LichdomSoulPoolHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public final int increaseSouls(@NotNull ServerPlayer player, int amount, @Nullable BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (amount <= 0) {
            return 0;
        }
        Level level = player.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return 0;
        }
        ServerLevel level2 = serverLevel;
        UUID playerUuid = player.getUUID();
        PhylacteryLevelDataAttachment.Data data2 = PhylacteryLevelDataAttachment.getData(level2);
        int remaining = amount;
        if (pos != null) {
            Object v1;
            block8: {
                Iterable iterable = data2.getPhylacteries();
                for (Object t : iterable) {
                    PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUuid) && Intrinsics.areEqual((Object)it.getPos(), (Object)pos) && !it.getHasSoul())) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            PhylacteryLevelDataAttachment.PhylacteryRecord rec = v1;
            if (rec != null) {
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(level2, pos, true);
                --remaining;
            }
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = data2.getPhylacteries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUuid) && !it.getHasSoul())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            for (PhylacteryLevelDataAttachment.PhylacteryRecord rec : candidates) {
                if (remaining <= 0) break;
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(level2, rec.getPos(), true);
                --remaining;
            }
        }
        PhylacteryLevelDataAttachment.setData(level2, data2);
        SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData((Player)player);
        int added = amount - remaining;
        SoulPoolPlayerAttachment.setData((Player)player, SoulPoolPlayerAttachment.Data.copy$default(pool, 0, pool.getSoulPool() + added, 1, null));
        return added;
    }

    public static /* synthetic */ int increaseSouls$default(LichdomSoulPoolHandler lichdomSoulPoolHandler, ServerPlayer serverPlayer, int n, BlockPos blockPos, int n2, Object object) {
        if ((n2 & 4) != 0) {
            blockPos = null;
        }
        return lichdomSoulPoolHandler.increaseSouls(serverPlayer, n, blockPos);
    }

    /*
     * WARNING - void declaration
     */
    public final int decreaseSouls(@NotNull ServerPlayer player, int amount, @Nullable BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (amount <= 0) {
            return 0;
        }
        Level level = player.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return 0;
        }
        ServerLevel level2 = serverLevel;
        UUID playerUuid = player.getUUID();
        PhylacteryLevelDataAttachment.Data data2 = PhylacteryLevelDataAttachment.getData(level2);
        int remaining = amount;
        if (pos != null) {
            Object v1;
            block8: {
                Iterable iterable = data2.getPhylacteries();
                for (Object t : iterable) {
                    PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUuid) && Intrinsics.areEqual((Object)it.getPos(), (Object)pos) && it.getHasSoul())) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            PhylacteryLevelDataAttachment.PhylacteryRecord rec = v1;
            if (rec != null) {
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(level2, pos, false);
                --remaining;
            }
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = data2.getPhylacteries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getOwner(), (Object)playerUuid) && it.getHasSoul())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filled = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            for (PhylacteryLevelDataAttachment.PhylacteryRecord rec : filled) {
                if (remaining <= 0) break;
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(level2, rec.getPos(), false);
                --remaining;
            }
        }
        PhylacteryLevelDataAttachment.setData(level2, data2);
        SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData((Player)player);
        int removed = amount - remaining;
        SoulPoolPlayerAttachment.setData((Player)player, SoulPoolPlayerAttachment.Data.copy$default(pool, 0, pool.getSoulPool() - removed, 1, null));
        return removed;
    }

    public static /* synthetic */ int decreaseSouls$default(LichdomSoulPoolHandler lichdomSoulPoolHandler, ServerPlayer serverPlayer, int n, BlockPos blockPos, int n2, Object object) {
        if ((n2 & 4) != 0) {
            blockPos = null;
        }
        return lichdomSoulPoolHandler.decreaseSouls(serverPlayer, n, blockPos);
    }

    public final int getMaxSouls(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return 0;
        }
        ServerLevel level2 = serverLevel;
        UUID playerUuid = player.getUUID();
        Intrinsics.checkNotNull((Object)playerUuid);
        return PhylacteryLevelDataAttachment.INSTANCE.listPhylacteriesForPlayer(level2, playerUuid).size();
    }

    public final int getCurrentSouls(@NotNull ServerPlayer player) {
        int n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return 0;
        }
        ServerLevel level2 = serverLevel;
        UUID playerUuid = player.getUUID();
        Intrinsics.checkNotNull((Object)playerUuid);
        Iterable $this$count$iv = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteriesForPlayer(level2, playerUuid);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)element$iv;
                boolean bl = false;
                if (!it.getHasSoul() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public final void destroyPhylactery(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Object v0;
        PhylacteryLevelDataAttachment.Data data2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            data2 = PhylacteryLevelDataAttachment.getData(level);
            Iterable iterable = data2.getPhylacteries();
            for (Object t : iterable) {
                PhylacteryLevelDataAttachment.PhylacteryRecord it = (PhylacteryLevelDataAttachment.PhylacteryRecord)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPos(), (Object)pos)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        PhylacteryLevelDataAttachment.PhylacteryRecord phylacteryRecord = v0;
        if (phylacteryRecord == null) {
            LichdomSoulPoolHandler $this$destroyPhylactery_u24lambda_u241 = this;
            boolean bl = false;
            PhylacteryLevelDataAttachment.INSTANCE.queueRemovePhylactery(level, pos);
            return;
        }
        PhylacteryLevelDataAttachment.PhylacteryRecord rec = phylacteryRecord;
        if (rec.getHasSoul()) {
            Player ownerPlayer = level.getPlayerByUUID(rec.getOwner());
            if (ownerPlayer != null && ownerPlayer instanceof ServerPlayer) {
                AfflictionPlayerAttachment.Data currentData$iv;
                PhylacteryLevelDataAttachment.INSTANCE.setPhylacteryHasSoul(level, pos, false);
                AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
                Player player$iv = ownerPlayer;
                boolean sync$iv = true;
                boolean $i$f$smartUpdate = false;
                AfflictionPlayerAttachment.Data $this$destroyPhylactery_u24lambda_u242 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
                boolean bl = false;
                AfflictionPlayerAttachment.Data newData$iv = $this$destroyPhylactery_u24lambda_u242.withPhylacterySouls(LichdomSoulPoolHandler.INSTANCE.getPhylacterySouls((ServerPlayer)ownerPlayer) - 1);
                AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
                if (player$iv.level() instanceof ServerLevel) {
                    AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
                }
            } else {
                PhylacteryLevelDataAttachment.INSTANCE.addPendingPlayerDelta(level, rec.getOwner(), -1);
                List<PhylacteryLevelDataAttachment.PendingPhylacteryChange> list = data2.getPendingPhylacteryChanges();
                Optional<UUID> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                list.add(new PhylacteryLevelDataAttachment.PendingPhylacteryChange(pos, "remove", optional, false));
                PhylacteryLevelDataAttachment.setData(level, data2);
            }
        } else {
            PhylacteryLevelDataAttachment.INSTANCE.removePhylactery(level, pos);
        }
    }

    private final int getPhylacterySouls(ServerPlayer player) {
        return this.getCurrentSouls(player);
    }

    public final void setMaxSouls(@NotNull Player entity, int lichLevel) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int maxSouls = (2 <= lichLevel ? lichLevel < 4 : false) ? 1 : ((4 <= lichLevel ? lichLevel < 6 : false) ? 2 : (lichLevel >= 6 ? 3 : 0));
        SoulPoolPlayerAttachment.Data data2 = SoulPoolPlayerAttachment.getData(entity);
        int clampedSouls = RangesKt.coerceAtMost((int)data2.getSoulPool(), (int)maxSouls);
        SoulPoolPlayerAttachment.setData(entity, data2.copy(maxSouls, clampedSouls));
    }

    public final void updateLichHunger(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int lichLevel = AfflictionPlayerAttachment.getData(player).getLichLevel();
        if (lichLevel < 2) {
            return;
        }
        SoulPoolPlayerAttachment.Data data2 = SoulPoolPlayerAttachment.getData(player);
        if (data2.getSoulPool() > 0) {
            player.getFoodData().setFoodLevel(20);
            player.getFoodData().setSaturation(5.0f);
        } else {
            player.getFoodData().setFoodLevel(1);
            player.getFoodData().setSaturation(0.0f);
        }
    }
}

