/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.vampire;

import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.TransformationPlayerAttachment;
import dev.sterner.witchery.features.affliction.event.AfflictionClientEventHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireClientSpecificEventHandler;", "", "<init>", "()V", "sun", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "renderHud", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderSunOverlay", "minecraft", "Lnet/minecraft/client/Minecraft;", "hasReversedSunTarot", "", "player", "Lnet/minecraft/world/entity/player/Player;", "drawSun", "drawBatFormHud", "Lnet/minecraft/client/player/LocalPlayer;", "drawBloodSense", "witchery"})
public final class VampireClientSpecificEventHandler {
    @NotNull
    public static final VampireClientSpecificEventHandler INSTANCE = new VampireClientSpecificEventHandler();
    private static final ResourceLocation sun = Witchery.Companion.id("textures/gui/affliction_abilities/sun_");

    private VampireClientSpecificEventHandler() {
    }

    @JvmStatic
    public static final void renderHud(@NotNull GuiGraphics guiGraphics) {
        boolean isVampire;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Minecraft client = Minecraft.getInstance();
        LocalPlayer localPlayer = client.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        boolean bl = isVampire = AfflictionPlayerAttachment.getData((Player)player).getVampireLevel() > 0;
        if (isVampire) {
            boolean hasOffhand = !player.getOffhandItem().isEmpty();
            int y = guiGraphics.guiHeight() - 18 - 5;
            int x = guiGraphics.guiWidth() / 2 - 36 - 72 - 5 - (hasOffhand ? 32 : 0);
            AfflictionClientEventHandler.INSTANCE.drawAbilityBar(guiGraphics, (Player)player, x, y);
            MultiPlayerGameMode multiPlayerGameMode = client.gameMode;
            Intrinsics.checkNotNull((Object)multiPlayerGameMode);
            boolean canHurtPlayer = multiPlayerGameMode.canHurtPlayer();
            if (canHurtPlayer) {
                INSTANCE.drawBloodSense(guiGraphics);
                INSTANCE.drawBatFormHud(guiGraphics, player);
            }
        }
    }

    @JvmStatic
    public static final void renderSunOverlay(@NotNull GuiGraphics guiGraphics, @NotNull Minecraft minecraft) {
        boolean canHurtPlayer;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        boolean isVampire = AfflictionPlayerAttachment.getData((Player)player).getVampireLevel() > 0;
        boolean hasSunReversed = INSTANCE.hasReversedSunTarot((Player)player);
        if (!isVampire && !hasSunReversed) {
            return;
        }
        MultiPlayerGameMode multiPlayerGameMode = minecraft.gameMode;
        boolean bl = canHurtPlayer = multiPlayerGameMode != null ? multiPlayerGameMode.canHurtPlayer() : false;
        if (!canHurtPlayer) {
            return;
        }
        INSTANCE.drawSun(guiGraphics, (Player)player);
    }

    private final boolean hasReversedSunTarot(Player player) {
        TarotPlayerAttachment.Data tarotData = TarotPlayerAttachment.getData(player);
        int sunCardIndex = tarotData.getDrawnCards().indexOf(20);
        if (sunCardIndex != -1) {
            Boolean bl = (Boolean)CollectionsKt.getOrNull(tarotData.getReversedCards(), (int)sunCardIndex);
            return bl != null ? bl : false;
        }
        return false;
    }

    private final void drawSun(GuiGraphics guiGraphics, Player player) {
        int sunTick;
        int y = guiGraphics.guiHeight() - 36 - 18 - 2;
        int x = guiGraphics.guiWidth() / 2 - 8;
        int raw = AfflictionPlayerAttachment.getData(player).getInSunTick();
        int maxSunTicks = AfflictionPlayerAttachment.getData(player).getMaxInSunTickClient();
        int n = sunTick = maxSunTicks > 0 ? ScreenManager.clamp((int)((int)((float)raw / (float)maxSunTicks * (float)4)), (int)0, (int)4) : 0;
        if (raw > 1) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0, 0.0, 200.0);
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, sun.withSuffix(sunTick + ".png"), x, y, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, 0, 3072, null);
            guiGraphics.pose().popPose();
        }
    }

    private final void drawBatFormHud(GuiGraphics guiGraphics, LocalPlayer player) {
        if (TransformationHandler.isBat((Player)player)) {
            int maxTicks = TransformationPlayerAttachment.getData((Player)player).getMaxBatTimeClient();
            int currentTicks = maxTicks - TransformationPlayerAttachment.getData((Player)player).getBatFormTicker();
            boolean hasArmor = player.getArmorValue() > 0;
            int y = guiGraphics.guiHeight() - 36 - 10 - (hasArmor ? 10 : 0);
            int x = guiGraphics.guiWidth() / 2 - 72 - 11;
            RenderUtils.INSTANCE.innerRenderBat(guiGraphics, maxTicks, currentTicks, y, x);
        }
    }

    private final void drawBloodSense(GuiGraphics guiGraphics) {
        int x = guiGraphics.guiWidth() / 2 + 13;
        int y = guiGraphics.guiHeight() / 2 + 9;
        Entity target = Minecraft.getInstance().crosshairPickEntity;
        if (target instanceof LivingEntity && BloodPoolLivingEntityAttachment.getData((LivingEntity)target).getMaxBlood() > 0) {
            RenderUtils.INSTANCE.innerRenderBlood(guiGraphics, (LivingEntity)target, y, x);
        }
    }
}

