/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.vampire;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.event.VampireEvent;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.network.RefreshDimensionsS2CPayload;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0007J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0007J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010%\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002JE\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010/\u001a\u00020\u0014H\u0007J \u00105\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0016\u00105\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020201\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireLeveling;", "", "<init>", "()V", "KNOCKBACK_BONUS", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "BAT_WEAKNESS", "BAT_HEALTH", "setLevel", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "level", "", "increaseVampireLevel", "setMaxBlood", "Lnet/minecraft/world/entity/player/Player;", "levelToBlood", "updateModifiers", "toBat", "", "canPerformQuest", "targetLevel", "increaseVillagersHalfBlood", "villager", "Lnet/minecraft/world/entity/npc/Villager;", "removeVillagerHalfBlood", "increaseNightTicker", "resetNightCounter", "increaseUsedSunGrenades", "increaseKilledBlazes", "givePoppy", "addVillage", "pos", "Lnet/minecraft/world/level/ChunkPos;", "resetVillages", "increaseTrappedVillagers", "removeTrappedVillager", "checkAndLevelUp", "data", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "setVampireProgress", "killedBlazes", "usedSunGrenades", "nightTicker", "(Lnet/minecraft/server/level/ServerPlayer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "resetVampireProgress", "keepLevel", "LEVEL_REQUIREMENTS", "", "Ldev/sterner/witchery/features/affliction/vampire/VampireLeveling$Requirement;", "getLEVEL_REQUIREMENTS", "()Ljava/util/Map;", "canLevelUp", "Requirement", "witchery"})
@SourceDebugExtension(value={"SMAP\nVampireLeveling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VampireLeveling.kt\ndev/sterner/witchery/features/affliction/vampire/VampireLeveling\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,443:1\n69#2,15:444\n69#2,15:459\n69#2,15:474\n74#2,10:489\n74#2,10:499\n69#2,15:509\n69#2,15:524\n69#2,15:539\n69#2,7:554\n77#2,7:563\n69#2,15:570\n69#2,15:585\n69#2,15:600\n69#2,15:615\n1869#3,2:561\n1#4:630\n*S KotlinDebug\n*F\n+ 1 VampireLeveling.kt\ndev/sterner/witchery/features/affliction/vampire/VampireLeveling\n*L\n49#1:444,15\n163#1:459,15\n174#1:474,15\n190#1:489,10\n199#1:499,10\n214#1:509,15\n231#1:524,15\n265#1:539,15\n275#1:554,7\n275#1:563,7\n296#1:570,15\n307#1:585,15\n340#1:600,15\n365#1:615,15\n277#1:561,2\n*E\n"})
public final class VampireLeveling {
    @NotNull
    public static final VampireLeveling INSTANCE = new VampireLeveling();
    @NotNull
    private static final AttributeModifier KNOCKBACK_BONUS = new AttributeModifier(Witchery.Companion.id("vampire_knockback"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier BAT_WEAKNESS = new AttributeModifier(Witchery.Companion.id("bat_weakness"), -2.5, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier BAT_HEALTH = new AttributeModifier(Witchery.Companion.id("bat_health"), -4.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final Map<Integer, Requirement> LEVEL_REQUIREMENTS;

    private VampireLeveling() {
    }

    @JvmStatic
    public static final void setLevel(@NotNull ServerPlayer player, int level) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int previousLevel = AfflictionPlayerAttachment.getData((Player)player).getVampireLevel();
        if (level == 0) {
            AfflictionPlayerAttachment.Data newData = AfflictionPlayerAttachment.getData((Player)player).setLevel(AfflictionTypes.VAMPIRISM, 0).withAbilityIndex(-1).withNightVision(false).withSpeedBoost(false).withBatForm(false);
            AfflictionPlayerAttachment.setData((Player)player, newData, false);
            AfflictionPlayerAttachment.syncFull((Player)player, newData);
            TransformationHandler.removeForm((Player)player);
        } else {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment newData = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$setLevel_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$setLevel_u24lambda_u240.setLevel(AfflictionTypes.VAMPIRISM, level);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
        INSTANCE.updateModifiers((Player)player, level, false);
        player.refreshDimensions();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), (CustomPacketPayload)new RefreshDimensionsS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (level > previousLevel) {
            AfflictionAbilityHandler.addAbilityOnLevelUp$default(AfflictionAbilityHandler.INSTANCE, (Player)player, level, AfflictionTypes.VAMPIRISM, false, 8, null);
        }
    }

    @JvmStatic
    public static final void increaseVampireLevel(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data currentData = AfflictionPlayerAttachment.getData((Player)player);
        int currentLevel = currentData.getVampireLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel > 10) {
            return;
        }
        if (nextLevel > 2 && !INSTANCE.canLevelUp(player, currentData, nextLevel)) {
            return;
        }
        VampireEvent.LevelUp event = new VampireEvent.LevelUp((Player)player, currentLevel, nextLevel);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        VampireLeveling.setLevel(player, nextLevel);
        INSTANCE.setMaxBlood((Player)player, nextLevel);
        player.sendSystemMessage((Component)Component.literal((String)("Vampire Level Up: " + nextLevel)));
        INSTANCE.updateModifiers((Player)player, nextLevel, false);
        WitcheryApi.INSTANCE.makePlayerWitchy((Player)player);
    }

    private final void setMaxBlood(Player player, int level) {
        int maxBlood = this.levelToBlood(level);
        BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        BloodPoolLivingEntityAttachment.setData((LivingEntity)player, BloodPoolLivingEntityAttachment.Data.copy$default(bloodData, maxBlood, 0, 2, null));
    }

    public final int levelToBlood(int level) {
        return switch (level) {
            case 1 -> 900;
            case 2 -> 1200;
            case 3 -> 1500;
            case 4 -> 1500;
            case 5 -> 1800;
            case 6 -> 2100;
            case 7 -> 2400;
            case 8 -> 2700;
            case 9 -> 3000;
            case 10 -> 3600;
            default -> 0;
        };
    }

    public final void updateModifiers(@NotNull Player player, int level, boolean toBat) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(KNOCKBACK_BONUS);
            }
            AttributeInstance attributeInstance2 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance2 != null) {
                attributeInstance2.removeModifier(BAT_HEALTH);
            }
            AttributeInstance attributeInstance3 = player.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance3 != null) {
                attributeInstance3.removeModifier(BAT_WEAKNESS);
            }
            if (level >= 3) {
                AttributeInstance attributeInstance4 = player.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK);
                if (attributeInstance4 != null) {
                    attributeInstance4.addPermanentModifier(KNOCKBACK_BONUS);
                }
            }
            if (!toBat) break block7;
            AttributeInstance attributeInstance5 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance5 != null) {
                attributeInstance5.addPermanentModifier(BAT_HEALTH);
            }
            AttributeInstance attributeInstance6 = player.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance6 != null) {
                attributeInstance6.addPermanentModifier(BAT_WEAKNESS);
            }
        }
    }

    public final boolean canPerformQuest(@NotNull ServerPlayer player, int targetLevel) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getVampireLevel() != targetLevel) {
            return false;
        }
        Requirement requirement = LEVEL_REQUIREMENTS.get(targetLevel);
        if (requirement == null || (requirement = requirement.getAdvancement()) == null) {
            return false;
        }
        Requirement requiredAdvancement = requirement;
        return WitcheryUtil.INSTANCE.hasAdvancement(player, (ResourceLocation)requiredAdvancement);
    }

    @JvmStatic
    public static final void increaseVillagersHalfBlood(@NotNull ServerPlayer player, @NotNull Villager villager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)villager, (String)"villager");
        if (!INSTANCE.canPerformQuest(player, 2)) {
            return;
        }
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (!data2.getVillagersHalfBlood().contains(villager.getUUID())) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$increaseVillagersHalfBlood_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            UUID uUID = villager.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            AfflictionPlayerAttachment.Data newData$iv = $this$increaseVillagersHalfBlood_u24lambda_u240.addVillagerHalfBlood(uUID);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            UUID uUID2 = villager.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            INSTANCE.checkAndLevelUp(player, data2.addVillagerHalfBlood(uUID2));
        }
    }

    @JvmStatic
    public static final void removeVillagerHalfBlood(@NotNull Player player, @NotNull Villager villager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)villager, (String)"villager");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(player);
        if (data2.getVillagersHalfBlood().contains(villager.getUUID())) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$removeVillagerHalfBlood_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            UUID uUID = villager.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            AfflictionPlayerAttachment.Data newData$iv = $this$removeVillagerHalfBlood_u24lambda_u240.removeVillagerHalfBlood(uUID);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void increaseNightTicker(@NotNull ServerPlayer player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 3)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = (Player)player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseNightTicker_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$increaseNightTicker_u24lambda_u240.incrementNightTicker();
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void resetNightCounter(@NotNull Player player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$resetNightCounter_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$resetNightCounter_u24lambda_u240.withNightTicker(0);
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
    }

    @JvmStatic
    public static final void increaseUsedSunGrenades(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 4)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseUsedSunGrenades_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementUsedSunGrenades$default($this$increaseUsedSunGrenades_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void increaseKilledBlazes(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 5)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseKilledBlazes_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementKilledBlazes$default($this$increaseKilledBlazes_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        AfflictionPlayerAttachment.Data newData = newData$iv;
        INSTANCE.checkAndLevelUp(player, newData);
    }

    @JvmStatic
    public static final void givePoppy(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!INSTANCE.canPerformQuest(player, 6)) {
            return;
        }
        VampireLeveling.increaseVampireLevel(player);
    }

    @JvmStatic
    public static final void addVillage(@NotNull ServerPlayer player, @NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!INSTANCE.canPerformQuest(player, 7)) {
            return;
        }
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        long longPos = ChunkPos.asLong((int)pos.x, (int)pos.z);
        if (!data2.getVisitedVillages().contains(longPos)) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$addVillage_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$addVillage_u24lambda_u240.addVisitedVillage(longPos);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            AfflictionPlayerAttachment.Data newData = newData$iv;
            INSTANCE.checkAndLevelUp(player, newData);
        }
    }

    @JvmStatic
    public static final void resetVillages(@NotNull Player player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(player);
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$resetVillages_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data result = null;
        result = $this$resetVillages_u24lambda_u240;
        Iterable $this$forEach$iv = data2.getVisitedVillages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long village = ((Number)element$iv).longValue();
            boolean bl2 = false;
            result = result.removeVisitedVillage(village);
        }
        AfflictionPlayerAttachment.Data newData$iv = result;
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    @JvmStatic
    public static final void increaseTrappedVillagers(@NotNull ServerPlayer player, @NotNull Villager villager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)villager, (String)"villager");
        if (!INSTANCE.canPerformQuest(player, 8)) {
            return;
        }
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (!data2.getTrappedVillagers().contains(villager.getUUID())) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$increaseTrappedVillagers_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            UUID uUID = villager.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            AfflictionPlayerAttachment.Data newData$iv = $this$increaseTrappedVillagers_u24lambda_u240.addTrappedVillager(uUID);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            AfflictionPlayerAttachment.Data newData = newData$iv;
            INSTANCE.checkAndLevelUp(player, newData);
        }
    }

    @JvmStatic
    public static final void removeTrappedVillager(@NotNull Player player, @NotNull Villager villager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)villager, (String)"villager");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(player);
        if (data2.getTrappedVillagers().contains(villager.getUUID())) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$removeTrappedVillager_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            UUID uUID = villager.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            AfflictionPlayerAttachment.Data newData$iv = $this$removeTrappedVillager_u24lambda_u240.removeTrappedVillager(uUID);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
    }

    private final void checkAndLevelUp(ServerPlayer player, AfflictionPlayerAttachment.Data data2) {
        int currentLevel = data2.getVampireLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel <= 10 && this.canLevelUp(player, data2, nextLevel)) {
            VampireLeveling.increaseVampireLevel(player);
        }
    }

    @JvmStatic
    public static final void setVampireProgress(@NotNull ServerPlayer player, @Nullable Integer level, @Nullable Integer killedBlazes, @Nullable Integer usedSunGrenades, @Nullable Integer nightTicker) {
        int it;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$setVampireProgress_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data result = null;
        result = $this$setVampireProgress_u24lambda_u240;
        Integer n = level;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            result = result.setLevel(AfflictionTypes.VAMPIRISM, it);
        }
        Integer n2 = killedBlazes;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl3 = false;
            result = result.withKilledBlazes(it);
        }
        Integer n3 = usedSunGrenades;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl4 = false;
            result = result.withUsedSunGrenades(it);
        }
        Integer n4 = nightTicker;
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl5 = false;
            result = result.withNightTicker(it);
        }
        AfflictionPlayerAttachment.Data newData$iv = result;
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    public static /* synthetic */ void setVampireProgress$default(ServerPlayer serverPlayer, Integer n, Integer n2, Integer n3, Integer n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = null;
        }
        if ((n5 & 4) != 0) {
            n2 = null;
        }
        if ((n5 & 8) != 0) {
            n3 = null;
        }
        if ((n5 & 0x10) != 0) {
            n4 = null;
        }
        VampireLeveling.setVampireProgress(serverPlayer, n, n2, n3, n4);
    }

    @JvmStatic
    public static final void resetVampireProgress(@NotNull ServerPlayer player, boolean keepLevel) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$resetVampireProgress_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data result = $this$resetVampireProgress_u24lambda_u240;
        if (!keepLevel) {
            result = result.setLevel(AfflictionTypes.VAMPIRISM, 0);
        }
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.withInSunTick$default(result.withKilledBlazes(0).withUsedSunGrenades(0).withNightTicker(0).withNightVision(false).withSpeedBoost(false).withBatForm(false).withAbilityIndex(-1), 0, null, 2, null).withMaxInSunTickClient(0).clearKilledBlazes().clearTrappedVillager().clearVisitedVillages().clearUsedSunGrenades().clearVillagerHalfBlood();
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    public static /* synthetic */ void resetVampireProgress$default(ServerPlayer serverPlayer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        VampireLeveling.resetVampireProgress(serverPlayer, bl);
    }

    @NotNull
    public final Map<Integer, Requirement> getLEVEL_REQUIREMENTS() {
        return LEVEL_REQUIREMENTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canLevelUp(ServerPlayer player, AfflictionPlayerAttachment.Data data2, int targetLevel) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int it;
        if (targetLevel > 10) {
            return false;
        }
        if (targetLevel <= 2) {
            return true;
        }
        Requirement requirement = LEVEL_REQUIREMENTS.get(targetLevel);
        if (requirement == null) {
            return false;
        }
        Requirement requirement2 = requirement;
        ResourceLocation it2 = requirement2.getAdvancement();
        boolean bl6 = false;
        if (!WitcheryUtil.INSTANCE.hasAdvancement(player, it2)) return false;
        Integer n = requirement2.getHalfVillagers();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl7 = false;
            if (data2.getVillagersHalfBlood().size() < it) return false;
            bl5 = true;
        } else {
            bl5 = true;
        }
        if (!bl5) return false;
        Integer n2 = requirement2.getNightCounter();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl8 = false;
            if (data2.getNightTicker() < it) return false;
            if (!player.level().isNight()) return false;
            bl4 = true;
        } else {
            bl4 = true;
        }
        if (!bl4) return false;
        Integer n3 = requirement2.getSunGrenades();
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl9 = false;
            if (data2.getUsedSunGrenades() < it) return false;
            bl3 = true;
        } else {
            bl3 = true;
        }
        if (!bl3) return false;
        Integer n4 = requirement2.getBlazesKilled();
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl10 = false;
            if (data2.getKilledBlazes() < it) return false;
            bl2 = true;
        } else {
            bl2 = true;
        }
        if (!bl2) return false;
        Integer n5 = requirement2.getVillagesVisited();
        if (n5 != null) {
            it = ((Number)n5).intValue();
            boolean bl11 = false;
            if (data2.getVisitedVillages().size() < it) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        Integer n6 = requirement2.getTrappedVillagers();
        if (n6 == null) return true;
        it = ((Number)n6).intValue();
        boolean bl12 = false;
        if (data2.getTrappedVillagers().size() < it) return false;
        return true;
    }

    public final boolean canLevelUp(@NotNull ServerPlayer player, int targetLevel) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        return this.canLevelUp(player, data2, targetLevel);
    }

    static {
        Pair[] pairArray = new Pair[8];
        Integer n = 3;
        ResourceLocation resourceLocation = Witchery.Companion.id("vampire/2");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        pairArray[0] = TuplesKt.to((Object)n, (Object)new Requirement(resourceLocation, 5, null, null, null, null, null, 124, null));
        Integer n2 = 4;
        ResourceLocation resourceLocation2 = Witchery.Companion.id("vampire/3");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"id(...)");
        pairArray[1] = TuplesKt.to((Object)n2, (Object)new Requirement(resourceLocation2, null, 24000, null, null, null, null, 122, null));
        Integer n3 = 5;
        ResourceLocation resourceLocation3 = Witchery.Companion.id("vampire/4");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"id(...)");
        pairArray[2] = TuplesKt.to((Object)n3, (Object)new Requirement(resourceLocation3, null, null, 10, null, null, null, 118, null));
        Integer n4 = 6;
        ResourceLocation resourceLocation4 = Witchery.Companion.id("vampire/5");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"id(...)");
        pairArray[3] = TuplesKt.to((Object)n4, (Object)new Requirement(resourceLocation4, null, null, null, 20, null, null, 110, null));
        Integer n5 = 7;
        ResourceLocation resourceLocation5 = Witchery.Companion.id("vampire/6");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"id(...)");
        pairArray[4] = TuplesKt.to((Object)n5, (Object)new Requirement(resourceLocation5, null, null, null, null, null, null, 126, null));
        Integer n6 = 8;
        ResourceLocation resourceLocation6 = Witchery.Companion.id("vampire/7");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"id(...)");
        pairArray[5] = TuplesKt.to((Object)n6, (Object)new Requirement(resourceLocation6, null, null, null, null, 2, null, 94, null));
        Integer n7 = 9;
        ResourceLocation resourceLocation7 = Witchery.Companion.id("vampire/8");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"id(...)");
        pairArray[6] = TuplesKt.to((Object)n7, (Object)new Requirement(resourceLocation7, null, null, null, null, null, 5, 62, null));
        Integer n8 = 10;
        ResourceLocation resourceLocation8 = Witchery.Companion.id("vampire/9");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"id(...)");
        pairArray[7] = TuplesKt.to((Object)n8, (Object)new Requirement(resourceLocation8, null, null, null, null, null, null, 126, null));
        LEVEL_REQUIREMENTS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J`\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0014\u0010\u0010R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0015\u0010\u0010R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006&"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireLeveling$Requirement;", "", "advancement", "Lnet/minecraft/resources/ResourceLocation;", "halfVillagers", "", "nightCounter", "sunGrenades", "blazesKilled", "villagesVisited", "trappedVillagers", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getAdvancement", "()Lnet/minecraft/resources/ResourceLocation;", "getHalfVillagers", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getNightCounter", "getSunGrenades", "getBlazesKilled", "getVillagesVisited", "getTrappedVillagers", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Ldev/sterner/witchery/features/affliction/vampire/VampireLeveling$Requirement;", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class Requirement {
        @NotNull
        private final ResourceLocation advancement;
        @Nullable
        private final Integer halfVillagers;
        @Nullable
        private final Integer nightCounter;
        @Nullable
        private final Integer sunGrenades;
        @Nullable
        private final Integer blazesKilled;
        @Nullable
        private final Integer villagesVisited;
        @Nullable
        private final Integer trappedVillagers;

        public Requirement(@NotNull ResourceLocation advancement, @Nullable Integer halfVillagers, @Nullable Integer nightCounter, @Nullable Integer sunGrenades, @Nullable Integer blazesKilled, @Nullable Integer villagesVisited, @Nullable Integer trappedVillagers) {
            Intrinsics.checkNotNullParameter((Object)advancement, (String)"advancement");
            this.advancement = advancement;
            this.halfVillagers = halfVillagers;
            this.nightCounter = nightCounter;
            this.sunGrenades = sunGrenades;
            this.blazesKilled = blazesKilled;
            this.villagesVisited = villagesVisited;
            this.trappedVillagers = trappedVillagers;
        }

        public /* synthetic */ Requirement(ResourceLocation resourceLocation, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 2) != 0) {
                n = null;
            }
            if ((n7 & 4) != 0) {
                n2 = null;
            }
            if ((n7 & 8) != 0) {
                n3 = null;
            }
            if ((n7 & 0x10) != 0) {
                n4 = null;
            }
            if ((n7 & 0x20) != 0) {
                n5 = null;
            }
            if ((n7 & 0x40) != 0) {
                n6 = null;
            }
            this(resourceLocation, n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public final ResourceLocation getAdvancement() {
            return this.advancement;
        }

        @Nullable
        public final Integer getHalfVillagers() {
            return this.halfVillagers;
        }

        @Nullable
        public final Integer getNightCounter() {
            return this.nightCounter;
        }

        @Nullable
        public final Integer getSunGrenades() {
            return this.sunGrenades;
        }

        @Nullable
        public final Integer getBlazesKilled() {
            return this.blazesKilled;
        }

        @Nullable
        public final Integer getVillagesVisited() {
            return this.villagesVisited;
        }

        @Nullable
        public final Integer getTrappedVillagers() {
            return this.trappedVillagers;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.advancement;
        }

        @Nullable
        public final Integer component2() {
            return this.halfVillagers;
        }

        @Nullable
        public final Integer component3() {
            return this.nightCounter;
        }

        @Nullable
        public final Integer component4() {
            return this.sunGrenades;
        }

        @Nullable
        public final Integer component5() {
            return this.blazesKilled;
        }

        @Nullable
        public final Integer component6() {
            return this.villagesVisited;
        }

        @Nullable
        public final Integer component7() {
            return this.trappedVillagers;
        }

        @NotNull
        public final Requirement copy(@NotNull ResourceLocation advancement, @Nullable Integer halfVillagers, @Nullable Integer nightCounter, @Nullable Integer sunGrenades, @Nullable Integer blazesKilled, @Nullable Integer villagesVisited, @Nullable Integer trappedVillagers) {
            Intrinsics.checkNotNullParameter((Object)advancement, (String)"advancement");
            return new Requirement(advancement, halfVillagers, nightCounter, sunGrenades, blazesKilled, villagesVisited, trappedVillagers);
        }

        public static /* synthetic */ Requirement copy$default(Requirement requirement, ResourceLocation resourceLocation, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                resourceLocation = requirement.advancement;
            }
            if ((n7 & 2) != 0) {
                n = requirement.halfVillagers;
            }
            if ((n7 & 4) != 0) {
                n2 = requirement.nightCounter;
            }
            if ((n7 & 8) != 0) {
                n3 = requirement.sunGrenades;
            }
            if ((n7 & 0x10) != 0) {
                n4 = requirement.blazesKilled;
            }
            if ((n7 & 0x20) != 0) {
                n5 = requirement.villagesVisited;
            }
            if ((n7 & 0x40) != 0) {
                n6 = requirement.trappedVillagers;
            }
            return requirement.copy(resourceLocation, n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "Requirement(advancement=" + this.advancement + ", halfVillagers=" + this.halfVillagers + ", nightCounter=" + this.nightCounter + ", sunGrenades=" + this.sunGrenades + ", blazesKilled=" + this.blazesKilled + ", villagesVisited=" + this.villagesVisited + ", trappedVillagers=" + this.trappedVillagers + ")";
        }

        public int hashCode() {
            int result = this.advancement.hashCode();
            result = result * 31 + (this.halfVillagers == null ? 0 : ((Object)this.halfVillagers).hashCode());
            result = result * 31 + (this.nightCounter == null ? 0 : ((Object)this.nightCounter).hashCode());
            result = result * 31 + (this.sunGrenades == null ? 0 : ((Object)this.sunGrenades).hashCode());
            result = result * 31 + (this.blazesKilled == null ? 0 : ((Object)this.blazesKilled).hashCode());
            result = result * 31 + (this.villagesVisited == null ? 0 : ((Object)this.villagesVisited).hashCode());
            result = result * 31 + (this.trappedVillagers == null ? 0 : ((Object)this.trappedVillagers).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Requirement)) {
                return false;
            }
            Requirement requirement = (Requirement)other;
            if (!Intrinsics.areEqual((Object)this.advancement, (Object)requirement.advancement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.halfVillagers, (Object)requirement.halfVillagers)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nightCounter, (Object)requirement.nightCounter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sunGrenades, (Object)requirement.sunGrenades)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.blazesKilled, (Object)requirement.blazesKilled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.villagesVisited, (Object)requirement.villagesVisited)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trappedVillagers, (Object)requirement.trappedVillagers);
        }
    }
}

