/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.werewolf;

import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.mixin_logic.SummonedWolf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u00132\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0013B#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility;", "Ldev/sterner/witchery/features/affliction/ability/AfflictionAbility;", "", "requiredLevel", "", "cooldown", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "<init>", "(Ljava/lang/String;IIILdev/sterner/witchery/features/affliction/AfflictionTypes;)V", "getRequiredLevel", "()I", "getCooldown", "getAffliction", "()Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "BITE", "PACK_SUMMON", "WOLF_FORM", "WEREWOLF_FORM", "Companion", "witchery"})
public abstract class WerewolfAbility
extends Enum<WerewolfAbility>
implements AfflictionAbility {
    @NotNull
    public static final Companion Companion;
    private final int requiredLevel;
    private final int cooldown;
    @NotNull
    private final AfflictionTypes affliction;
    public static final /* enum */ WerewolfAbility BITE;
    public static final /* enum */ WerewolfAbility PACK_SUMMON;
    public static final /* enum */ WerewolfAbility WOLF_FORM;
    public static final /* enum */ WerewolfAbility WEREWOLF_FORM;
    private static final /* synthetic */ WerewolfAbility[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private WerewolfAbility(int requiredLevel, int cooldown, AfflictionTypes affliction) {
        this.requiredLevel = requiredLevel;
        this.cooldown = cooldown;
        this.affliction = affliction;
    }

    /* synthetic */ WerewolfAbility(String string, int n, int n2, int n3, AfflictionTypes afflictionTypes, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            afflictionTypes = AfflictionTypes.LYCANTHROPY;
        }
        this(n2, n3, afflictionTypes);
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    @NotNull
    public AfflictionTypes getAffliction() {
        return this.affliction;
    }

    public static WerewolfAbility[] values() {
        return (WerewolfAbility[])$VALUES.clone();
    }

    public static WerewolfAbility valueOf(String value) {
        return Enum.valueOf(WerewolfAbility.class, value);
    }

    @NotNull
    public static EnumEntries<WerewolfAbility> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    public static final boolean hasMoonCharm(@NotNull Player player) {
        return Companion.hasMoonCharm(player);
    }

    static {
        BITE = new BITE("BITE", 0);
        PACK_SUMMON = new PACK_SUMMON("PACK_SUMMON", 1);
        WOLF_FORM = new WOLF_FORM("WOLF_FORM", 2);
        WEREWOLF_FORM = new WEREWOLF_FORM("WEREWOLF_FORM", 3);
        $VALUES = werewolfAbilityArray = new WerewolfAbility[]{WerewolfAbility.BITE, WerewolfAbility.PACK_SUMMON, WerewolfAbility.WOLF_FORM, WerewolfAbility.WEREWOLF_FORM};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/werewolf/WerewolfAbility.BITE", "Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nWerewolfAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfAbility.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfAbility$BITE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n2423#2,14:258\n*S KotlinDebug\n*F\n+ 1 WerewolfAbility.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfAbility$BITE\n*L\n60#1:258,14\n*E\n"})
    static final class BITE
    extends WerewolfAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        BITE() {
            void var1_1;
            this.id = "bite";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Object v0;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            Vec3 lookVec = ((ServerPlayer)player).getLookAngle();
            double lungeStrength = 1.2;
            ((ServerPlayer)player).setDeltaMovement(((ServerPlayer)player).getDeltaMovement().add(lookVec.x * lungeStrength, 0.2, lookVec.z * lungeStrength));
            player.hurtMarked = true;
            AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            AABB searchBox = ((ServerPlayer)player).getBoundingBox().expandTowards(lookVec.scale(3.0)).inflate(1.0, 0.5, 1.0);
            List targets = player.level().getEntitiesOfClass(LivingEntity.class, searchBox, arg_0 -> BITE.use$lambda$1(arg_0 -> BITE.use$lambda$0(player, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)targets);
            Iterable $this$minByOrNull$iv = targets;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    LivingEntity it = (LivingEntity)minElem$iv;
                    boolean bl = false;
                    double minValue$iv = player.distanceToSqr((Entity)it);
                    do {
                        Object e$iv = iterator$iv.next();
                        LivingEntity it2 = (LivingEntity)e$iv;
                        $i$a$-minByOrNull-WerewolfAbility$BITE$use$target$1 = false;
                        double v$iv = player.distanceToSqr((Entity)it2);
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            LivingEntity target = v0;
            if (target != null) {
                float damage = TransformationHandler.isWerewolf(player) ? 8.0f : 6.0f;
                target.hurt(player.damageSources().playerAttack(player), damage);
                player.heal(1.0f);
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
                player.level().playSound(null, player.blockPosition(), SoundEvents.WOLF_HURT, SoundSource.PLAYERS, 1.0f, 0.8f);
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 5, 0.2, 0.2, 0.2, 0.1);
                return true;
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.WOLF_GROWL, SoundSource.PLAYERS, 0.8f, 1.0f);
            return true;
        }

        private static final boolean use$lambda$0(Player $player, LivingEntity entity) {
            return !Intrinsics.areEqual((Object)entity, (Object)$player) && entity.isAlive() && !entity.isSpectator() && $player.canAttack(entity);
        }

        private static final boolean use$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility$Companion;", "", "<init>", "()V", "hasMoonCharm", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nWerewolfAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfAbility.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfAbility$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1563#2:258\n1634#2,3:259\n*S KotlinDebug\n*F\n+ 1 WerewolfAbility.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfAbility$Companion\n*L\n254#1:258\n254#1:259,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean hasMoonCharm(@NotNull Player player) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$map$iv = WitcheryUtil.allEquippedAccessories(player);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ItemStack itemStack = (ItemStack)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getItem());
            }
            return ((List)destination$iv$iv).contains(WitcheryItems.INSTANCE.getMOON_CHARM().get());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/werewolf/WerewolfAbility.PACK_SUMMON", "Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class PACK_SUMMON
    extends WerewolfAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        PACK_SUMMON() {
            void var1_1;
            this.id = "pack_summon";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            int wolfCount = TransformationHandler.isWerewolf(player) ? 3 : 2;
            for (int i = 0; i < wolfCount; ++i) {
                Wolf wolf;
                if ((Wolf)EntityType.WOLF.create(player.level()) == null) continue;
                double angle = (double)(i * 2) * Math.PI / (double)wolfCount;
                double xOffset = Math.cos(angle) * (double)2;
                double zOffset = Math.sin(angle) * (double)2;
                wolf.moveTo(((ServerPlayer)player).getX() + xOffset, ((ServerPlayer)player).getY(), ((ServerPlayer)player).getZ() + zOffset, ((ServerPlayer)player).getYRot(), 0.0f);
                wolf.tame(player);
                wolf.setOwnerUUID(((ServerPlayer)player).getUUID());
                ((SummonedWolf)wolf).witchery$setSummoned(true);
                ((SummonedWolf)wolf).witchery$setSummonDuration(600);
                wolf.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 2400, 1));
                wolf.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 2400, 0));
                wolf.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 2400, 0));
                player.level().addFreshEntity((Entity)wolf);
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HEART, ((Entity)wolf).getX(), ((Entity)wolf).getY() + 1.0, ((Entity)wolf).getZ(), 5, 0.5, 0.5, 0.5, 0.0);
            }
            AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            player.level().playSound(null, player.blockPosition(), SoundEvents.WOLF_HOWL, SoundSource.PLAYERS, 1.5f, 1.2f);
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/werewolf/WerewolfAbility.WEREWOLF_FORM", "Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class WEREWOLF_FORM
    extends WerewolfAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        WEREWOLF_FORM() {
            void var1_1;
            this.id = "werewolf_form";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            if (!Companion.hasMoonCharm(player)) {
                return false;
            }
            if (TransformationHandler.isWerewolf(player)) {
                TransformationHandler.removeForm(player);
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            } else {
                TransformationHandler.setWereWolfForm(player);
                player.level().playSound(null, player.blockPosition(), SoundEvents.WOLF_GROWL, SoundSource.PLAYERS, 1.0f, 0.2f);
                if (player instanceof ServerPlayer) {
                    Level level = player.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, ((ServerPlayer)player).getX(), ((ServerPlayer)player).getY() + 1.0, ((ServerPlayer)player).getZ(), 10, 0.5, 0.5, 0.5, 0.0);
                }
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/werewolf/WerewolfAbility.WOLF_FORM", "Ldev/sterner/witchery/features/affliction/werewolf/WerewolfAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class WOLF_FORM
    extends WerewolfAbility {
        @NotNull
        private final String id;

        /*
         * WARNING - void declaration
         */
        WOLF_FORM() {
            void var1_1;
            this.id = "wolf_form";
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            if (!Companion.hasMoonCharm(player)) {
                return false;
            }
            if (TransformationHandler.isWolf(player)) {
                TransformationHandler.removeForm(player);
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            } else {
                TransformationHandler.setWolfForm(player);
                player.level().playSound(null, player.blockPosition(), SoundEvents.WOLF_GROWL, SoundSource.PLAYERS, 1.0f, 0.5f);
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, ((ServerPlayer)player).getX(), ((ServerPlayer)player).getY() + 1.0, ((ServerPlayer)player).getZ(), 20, 0.5, 0.5, 0.5, 0.05);
            }
            return true;
        }
    }
}

