/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.blood;

import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001a\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/blood/BloodPoolHandler;", "", "<init>", "()V", "ticker", "", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "setBloodOnAdded", "entity", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "tickBloodRegen", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "increaseBlood", "amount", "decreaseBlood", "witchery"})
@SourceDebugExtension(value={"SMAP\nBloodPoolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloodPoolHandler.kt\ndev/sterner/witchery/features/blood/BloodPoolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n*S KotlinDebug\n*F\n+ 1 BloodPoolHandler.kt\ndev/sterner/witchery/features/blood/BloodPoolHandler\n*L\n27#1:98\n27#1:99,2\n*E\n"})
public final class BloodPoolHandler {
    @NotNull
    public static final BloodPoolHandler INSTANCE = new BloodPoolHandler();
    private static int ticker;

    private BloodPoolHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(@Nullable Player player) {
        if (player != null && player.level() instanceof ServerLevel) {
            int n;
            boolean bl;
            boolean bl2 = bl = AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0;
            if (bl && (ticker = (n = ticker) + 1) > 10) {
                void $this$filterTo$iv$iv;
                ticker = 0;
                List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(5.0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Entity it = (Entity)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.isAlive() && it instanceof LivingEntity && !Intrinsics.areEqual((Object)it, (Object)player) && BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().containsKey(((LivingEntity)it).getType()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List entities = (List)destination$iv$iv;
                for (Entity entity : entities) {
                    Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
                    BloodPoolLivingEntityAttachment.INSTANCE.sync((LivingEntity)entity, BloodPoolLivingEntityAttachment.getData((LivingEntity)entity));
                }
                BloodPoolLivingEntityAttachment.INSTANCE.sync((LivingEntity)player, BloodPoolLivingEntityAttachment.getData((LivingEntity)player));
            }
        }
    }

    public final void setBloodOnAdded(@Nullable Entity entity, @Nullable Level level) {
        if (entity instanceof LivingEntity) {
            EntityType entityType;
            BloodPoolReloadListener.BloodData bloodValue;
            BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData((LivingEntity)entity);
            Map<EntityType<?>, BloodPoolReloadListener.BloodData> bloodJson = BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR();
            if (data2.getMaxBlood() == 0 && data2.getBloodPool() == 0 && (bloodValue = bloodJson.get(entityType = ((LivingEntity)entity).getType())) != null) {
                int maxBlood = bloodValue.getBloodDrops() * 300;
                BloodPoolLivingEntityAttachment.Data initializedData = data2.copy(maxBlood, maxBlood);
                BloodPoolLivingEntityAttachment.setData((LivingEntity)entity, initializedData);
            }
        }
    }

    public final void tickBloodRegen(@NotNull LivingEntity livingEntity) {
        BloodPoolLivingEntityAttachment.Data bloodData;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof Player || livingEntity.level().isClientSide) {
            return;
        }
        if (BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().containsKey(livingEntity.getType()) && (bloodData = BloodPoolLivingEntityAttachment.getData(livingEntity)).getBloodPool() < bloodData.getMaxBlood() && bloodData.getMaxBlood() > 0 && livingEntity.tickCount % 1000 == 0) {
            BloodPoolReloadListener.BloodData bloodPool;
            BloodPoolReloadListener.BloodData bloodData2 = bloodPool = BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().get(livingEntity.getType());
            Intrinsics.checkNotNull((Object)bloodData2);
            BloodPoolHandler.increaseBlood(livingEntity, (bloodData2.getQualityBloodDrops() + 1) * 2);
        }
    }

    @JvmStatic
    public static final void increaseBlood(@NotNull LivingEntity livingEntity, int amount) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData(livingEntity);
        int maxBlood = data2.getMaxBlood();
        int newBloodPool = RangesKt.coerceAtMost((int)(data2.getBloodPool() + amount), (int)maxBlood);
        BloodPoolLivingEntityAttachment.setData(livingEntity, BloodPoolLivingEntityAttachment.Data.copy$default(data2, 0, newBloodPool, 1, null));
        if (livingEntity instanceof ServerPlayer && AfflictionPlayerAttachment.getData((Player)livingEntity).getVampireLevel() == 1 && newBloodPool == 900) {
            VampireLeveling.increaseVampireLevel((ServerPlayer)livingEntity);
        }
    }

    @JvmStatic
    public static final void decreaseBlood(@NotNull LivingEntity livingEntity, int amount) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData(livingEntity);
        int newBloodPool = RangesKt.coerceAtLeast((int)(data2.getBloodPool() - amount), (int)0);
        BloodPoolLivingEntityAttachment.setData(livingEntity, BloodPoolLivingEntityAttachment.Data.copy$default(data2, 0, newBloodPool, 1, null));
    }
}

