/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.curse;

import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.WitcheryApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/curse/CurseOfBefuddlement;", "Ldev/sterner/witchery/core/api/Curse;", "<init>", "()V", "onTickCurse", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "catBoosted", "", "onAdded", "witchery"})
public final class CurseOfBefuddlement
extends Curse {
    @Override
    public void onTickCurse(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        long baseInterval;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onTickCurse(level, player, catBoosted);
        float effectivenessMultiplier = this.getEffectivenessMultiplier(player);
        long l = baseInterval = WitcheryApi.INSTANCE.isWitchy(player) ? 100L : 300L;
        if (level.getGameTime() % baseInterval == 0L) {
            float nauseaChance = 0.3f * effectivenessMultiplier;
            int confusionDuration = (int)((float)40 * effectivenessMultiplier);
            if (level.random.nextFloat() < nauseaChance) {
                player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, confusionDuration, 0));
            }
            if (level.random.nextFloat() < nauseaChance * 0.5f) {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, confusionDuration / 2, 0));
            }
        }
        if (level.isClientSide && level.random.nextFloat() < 0.05f * effectivenessMultiplier) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX() + ((double)level.random.nextFloat() - 0.5) * 0.5, player.getY() + (double)(level.random.nextFloat() * player.getBbHeight()), player.getZ() + ((double)level.random.nextFloat() - 0.5) * 0.5, ((double)level.random.nextFloat() - 0.5) * 0.1, 0.0, ((double)level.random.nextFloat() - 0.5) * 0.1);
        }
    }

    @Override
    public void onAdded(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onAdded(level, player, catBoosted);
        player.displayClientMessage((Component)Component.translatable((String)"curse.witchery.befuddlement.applied").withStyle(ChatFormatting.DARK_PURPLE), true);
    }
}

