/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.curse;

import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.WitcheryApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/features/curse/CurseOfSinking;", "Ldev/sterner/witchery/core/api/Curse;", "<init>", "()V", "onTickCurse", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "catBoosted", "", "witchery"})
public final class CurseOfSinking
extends Curse {
    @Override
    public void onTickCurse(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        double sinkStrength;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.isInWaterOrRain()) {
            super.onTickCurse(level, player, catBoosted);
            return;
        }
        boolean isWitch = WitcheryApi.INSTANCE.isWitchy(player);
        double d = sinkStrength = isWitch ? 0.06 : 0.03;
        if (level.isRainingAt(player.blockPosition())) {
            sinkStrength *= 1.3;
        }
        Vec3 motion = player.getDeltaMovement();
        double newY = RangesKt.coerceAtLeast((double)(motion.y - sinkStrength), (double)-0.5);
        double resistedY = motion.y > 0.0 ? motion.y * (isWitch ? 0.5 : 0.75) : newY;
        player.setDeltaMovement(motion.multiply(0.9, 1.0, 0.9).with(Direction.Axis.Y, resistedY));
        super.onTickCurse(level, player, catBoosted);
    }
}

