/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.fetish;

import dev.sterner.witchery.content.block.effigy.EffigyBlockEntity;
import dev.sterner.witchery.content.block.effigy.EffigyState;
import dev.sterner.witchery.content.entity.DeathEntity;
import dev.sterner.witchery.core.api.FetishEffect;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.misc.MiscPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/features/fetish/SummonDeathFetishEffect;", "Ldev/sterner/witchery/core/api/FetishEffect;", "<init>", "()V", "onTickEffect", "", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Ldev/sterner/witchery/content/block/effigy/EffigyBlockEntity;", "state", "Ldev/sterner/witchery/content/block/effigy/EffigyState;", "pos", "Lnet/minecraft/core/BlockPos;", "taglock", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "tickRate", "", "teleportDeathPlayer", "player", "Lnet/minecraft/world/entity/player/Player;", "summonPos", "Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/server/level/ServerLevel;", "summonDeathEntity", "witchery"})
public final class SummonDeathFetishEffect
extends FetishEffect {
    public SummonDeathFetishEffect() {
        super(0, 1, null);
    }

    @Override
    public void onTickEffect(@NotNull Level level, @NotNull EffigyBlockEntity blockEntity, @Nullable EffigyState state, @NotNull BlockPos pos, @NotNull NonNullList<ItemStack> taglock, int tickRate) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(taglock, (String)"taglock");
        if (level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 summonPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
        Player deathPlayer = DeathTransformationHelper.INSTANCE.findDeathPlayer(level);
        if (deathPlayer != null) {
            this.teleportDeathPlayer(deathPlayer, summonPos, serverLevel, pos);
        } else {
            this.summonDeathEntity(summonPos, serverLevel, pos);
        }
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    private final void teleportDeathPlayer(Player player, Vec3 summonPos, ServerLevel level, BlockPos pos) {
        level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY() + (double)(player.getBbHeight() / (float)2), player.getZ(), 50, 0.5, 1.0, 0.5, 0.5);
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, player.getX(), player.getY() + (double)(player.getBbHeight() / (float)2), player.getZ(), 30, 0.5, 0.5, 0.5, 0.1);
        level.playSound(null, player.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.8f);
        player.teleportTo(summonPos.x, summonPos.y, summonPos.z);
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, summonPos.x, summonPos.y + 1.0, summonPos.z, 50, 0.5, 1.0, 0.5, 0.1);
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, summonPos.x, summonPos.y, summonPos.z, 30, 0.5, 0.5, 0.5, 0.05);
        level.playSound(null, pos, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.5f, 0.5f);
        MiscPlayerAttachment.Data data2 = MiscPlayerAttachment.getData(player);
        data2.setHasDeathTeleport(true);
        MiscPlayerAttachment.setData(player, data2);
    }

    private final void summonDeathEntity(Vec3 summonPos, ServerLevel level, BlockPos pos) {
        DeathEntity deathEntity = new DeathEntity((Level)level);
        deathEntity.moveTo(summonPos);
        level.addFreshEntity((Entity)deathEntity);
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, summonPos.x, summonPos.y + 1.0, summonPos.z, 50, 0.5, 1.0, 0.5, 0.1);
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, summonPos.x, summonPos.y, summonPos.z, 30, 0.5, 0.5, 0.5, 0.05);
        for (int i = 0; i < 40; ++i) {
            double angle = (double)i / 40.0 * Math.PI * (double)2;
            double radius = 2.0;
            double px = summonPos.x + Math.cos(angle) * radius;
            double pz = summonPos.z + Math.sin(angle) * radius;
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, px, summonPos.y + 0.1, pz, 1, 0.0, 0.5, 0.0, 0.1);
        }
        level.playSound(null, pos, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.5f, 0.5f);
    }
}

