/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.hags_ring;

import dev.sterner.witchery.content.item.curios.HagsRingItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/features/hags_ring/VeinMiningTracker;", "", "<init>", "()V", "playerVeins", "", "Ljava/util/UUID;", "", "Ldev/sterner/witchery/features/hags_ring/VeinMiningTracker$BreakingBlock;", "startVeinMining", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "orePositions", "", "Lnet/minecraft/core/BlockPos;", "generateFacePositions", "Lnet/minecraft/world/phys/Vec3;", "pos", "tick", "cancelVeinMining", "isVeinMining", "", "generatePosHash", "", "blockPos", "BreakingBlock", "witchery"})
@SourceDebugExtension(value={"SMAP\nVeinMiningTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VeinMiningTracker.kt\ndev/sterner/witchery/features/hags_ring/VeinMiningTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1563#2:176\n1634#2,3:177\n*S KotlinDebug\n*F\n+ 1 VeinMiningTracker.kt\ndev/sterner/witchery/features/hags_ring/VeinMiningTracker\n*L\n33#1:176\n33#1:177,3\n*E\n"})
public final class VeinMiningTracker {
    @NotNull
    public static final VeinMiningTracker INSTANCE = new VeinMiningTracker();
    @NotNull
    private static final Map<UUID, List<BreakingBlock>> playerVeins = new LinkedHashMap();

    private VeinMiningTracker() {
    }

    /*
     * WARNING - void declaration
     */
    public final void startVeinMining(@NotNull ServerPlayer player, @NotNull List<? extends BlockPos> orePositions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(orePositions, (String)"orePositions");
        if (playerVeins.containsKey(player.getUUID())) {
            return;
        }
        ServerLevel level = player.serverLevel();
        Iterable $this$map$iv = orePositions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pos;
            BlockPos blockPos = (BlockPos)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BlockState state = level.getBlockState((BlockPos)pos);
            float destroySpeed = state.getDestroySpeed((BlockGetter)level, (BlockPos)pos);
            int maxBreakTime = RangesKt.coerceAtLeast((int)((int)((float)20 * destroySpeed)), (int)1);
            Intrinsics.checkNotNull((Object)state);
            collection.add(new BreakingBlock((BlockPos)pos, state, 0, maxBreakTime, -1));
        }
        List breakingBlocks = (List)destination$iv$iv;
        playerVeins.put(player.getUUID(), CollectionsKt.toMutableList((Collection)breakingBlocks));
        if (!((Collection)orePositions).isEmpty()) {
            BlockPos clickedPos = (BlockPos)CollectionsKt.last(orePositions);
            List<Vec3> facePositions = this.generateFacePositions(clickedPos);
            for (Vec3 facePos : facePositions) {
                level.sendParticles((ParticleOptions)ParticleTypes.POOF, facePos.x, facePos.y, facePos.z, 3, 0.1, 0.1, 0.1, 0.02);
            }
            level.playSound(null, clickedPos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.8f, 1.5f);
        }
    }

    private final List<Vec3> generateFacePositions(BlockPos pos) {
        List positions = new ArrayList();
        double center = 0.5;
        double offset = 0.5;
        positions.add(new Vec3((double)pos.getX() + center, (double)pos.getY() + center, (double)pos.getZ() - offset + 0.05));
        positions.add(new Vec3((double)pos.getX() + center, (double)pos.getY() + center, (double)pos.getZ() + offset + 0.95));
        positions.add(new Vec3((double)pos.getX() - offset + 0.05, (double)pos.getY() + center, (double)pos.getZ() + center));
        positions.add(new Vec3((double)pos.getX() + offset + 0.95, (double)pos.getY() + center, (double)pos.getZ() + center));
        positions.add(new Vec3((double)pos.getX() + center, (double)pos.getY() - offset + 0.05, (double)pos.getZ() + center));
        positions.add(new Vec3((double)pos.getX() + center, (double)pos.getY() + offset + 0.95, (double)pos.getZ() + center));
        return positions;
    }

    public final void tick(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<BreakingBlock> list = playerVeins.get(player.getUUID());
        if (list == null) {
            return;
        }
        List<BreakingBlock> veins = list;
        ServerLevel level = player.serverLevel();
        int fortuneLevel = HagsRingItem.Companion.getFortuneLevel((Player)player);
        Iterator<BreakingBlock> iterator = veins.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack;
            BreakingBlock block = iterator.next();
            BlockState currentState = level.getBlockState(block.getPos());
            if (currentState.isAir() || !Intrinsics.areEqual((Object)currentState, (Object)block.getState())) {
                level.destroyBlockProgress(player.getId() + this.generatePosHash(block.getPos()), block.getPos(), -1);
                iterator.remove();
                continue;
            }
            int n = block.getBreakTime();
            block.setBreakTime(n + 1);
            int progress = RangesKt.coerceIn((int)((int)((float)block.getBreakTime() / (float)block.getMaxBreakTime() * (float)10)), (int)0, (int)10);
            if (block.getBreakTime() % 6 == 0) {
                level.playSound(null, block.getPos(), block.getState().getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (progress != block.getBreakProgress()) {
                block.setBreakProgress(progress);
                level.destroyBlockProgress(player.getId() + this.generatePosHash(block.getPos()), block.getPos(), progress);
            }
            if (block.getBreakTime() < block.getMaxBreakTime()) continue;
            if (fortuneLevel > 0) {
                ItemStack tempTool = player.getMainHandItem().copy();
                tempTool.enchant((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), fortuneLevel);
                itemStack = tempTool;
            } else {
                itemStack = player.getMainHandItem();
            }
            ItemStack tool = itemStack;
            Block.dropResources((BlockState)block.getState(), (Level)((Level)level), (BlockPos)block.getPos(), (BlockEntity)level.getBlockEntity(block.getPos()), (Entity)((Entity)player), (ItemStack)tool);
            level.removeBlock(block.getPos(), false);
            level.levelEvent(2001, block.getPos(), Block.getId((BlockState)block.getState()));
            level.destroyBlockProgress(player.getId() + this.generatePosHash(block.getPos()), block.getPos(), -1);
            iterator.remove();
        }
        if (veins.isEmpty()) {
            playerVeins.remove(player.getUUID());
        }
    }

    public final void cancelVeinMining(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<BreakingBlock> list = playerVeins.remove(player.getUUID());
        if (list == null) {
            return;
        }
        List<BreakingBlock> veins = list;
        ServerLevel level = player.serverLevel();
        for (BreakingBlock block : veins) {
            level.destroyBlockProgress(player.getId() + this.generatePosHash(block.getPos()), block.getPos(), -1);
        }
    }

    public final boolean isVeinMining(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return playerVeins.containsKey(player.getUUID());
    }

    private final int generatePosHash(BlockPos blockPos) {
        return 961 * blockPos.getX() + 31 * blockPos.getY() + blockPos.getZ();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/features/hags_ring/VeinMiningTracker$BreakingBlock;", "", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "breakTime", "", "maxBreakTime", "breakProgress", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;III)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "getBreakTime", "()I", "setBreakTime", "(I)V", "getMaxBreakTime", "getBreakProgress", "setBreakProgress", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "witchery"})
    public static final class BreakingBlock {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final BlockState state;
        private int breakTime;
        private final int maxBreakTime;
        private int breakProgress;

        public BreakingBlock(@NotNull BlockPos pos, @NotNull BlockState state, int breakTime, int maxBreakTime, int breakProgress) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.pos = pos;
            this.state = state;
            this.breakTime = breakTime;
            this.maxBreakTime = maxBreakTime;
            this.breakProgress = breakProgress;
        }

        public /* synthetic */ BreakingBlock(BlockPos blockPos, BlockState blockState, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n = 0;
            }
            if ((n4 & 0x10) != 0) {
                n3 = -1;
            }
            this(blockPos, blockState, n, n2, n3);
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final BlockState getState() {
            return this.state;
        }

        public final int getBreakTime() {
            return this.breakTime;
        }

        public final void setBreakTime(int n) {
            this.breakTime = n;
        }

        public final int getMaxBreakTime() {
            return this.maxBreakTime;
        }

        public final int getBreakProgress() {
            return this.breakProgress;
        }

        public final void setBreakProgress(int n) {
            this.breakProgress = n;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockState component2() {
            return this.state;
        }

        public final int component3() {
            return this.breakTime;
        }

        public final int component4() {
            return this.maxBreakTime;
        }

        public final int component5() {
            return this.breakProgress;
        }

        @NotNull
        public final BreakingBlock copy(@NotNull BlockPos pos, @NotNull BlockState state, int breakTime, int maxBreakTime, int breakProgress) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new BreakingBlock(pos, state, breakTime, maxBreakTime, breakProgress);
        }

        public static /* synthetic */ BreakingBlock copy$default(BreakingBlock breakingBlock, BlockPos blockPos, BlockState blockState, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                blockPos = breakingBlock.pos;
            }
            if ((n4 & 2) != 0) {
                blockState = breakingBlock.state;
            }
            if ((n4 & 4) != 0) {
                n = breakingBlock.breakTime;
            }
            if ((n4 & 8) != 0) {
                n2 = breakingBlock.maxBreakTime;
            }
            if ((n4 & 0x10) != 0) {
                n3 = breakingBlock.breakProgress;
            }
            return breakingBlock.copy(blockPos, blockState, n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "BreakingBlock(pos=" + this.pos + ", state=" + this.state + ", breakTime=" + this.breakTime + ", maxBreakTime=" + this.maxBreakTime + ", breakProgress=" + this.breakProgress + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.state.hashCode();
            result = result * 31 + Integer.hashCode(this.breakTime);
            result = result * 31 + Integer.hashCode(this.maxBreakTime);
            result = result * 31 + Integer.hashCode(this.breakProgress);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BreakingBlock)) {
                return false;
            }
            BreakingBlock breakingBlock = (BreakingBlock)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)breakingBlock.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)breakingBlock.state)) {
                return false;
            }
            if (this.breakTime != breakingBlock.breakTime) {
                return false;
            }
            if (this.maxBreakTime != breakingBlock.maxBreakTime) {
                return false;
            }
            return this.breakProgress == breakingBlock.breakProgress;
        }
    }
}

