/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.hunter;

import dev.sterner.witchery.features.hunter.HunterArmorDefenseHandler;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/hunter/HunterArmorParticleEffects;", "", "<init>", "()V", "spawnProtectionParticles", "", "player", "Lnet/minecraft/world/entity/player/Player;", "type", "Ldev/sterner/witchery/features/hunter/HunterArmorParticleEffects$ProtectionType;", "spawnShieldEffect", "level", "Lnet/minecraft/server/level/ServerLevel;", "position", "Lnet/minecraft/world/phys/Vec3;", "playSoundEffect", "spawnCurseReflectionEffect", "target", "Lnet/minecraft/server/level/ServerPlayer;", "ProtectionType", "witchery"})
public final class HunterArmorParticleEffects {
    @NotNull
    public static final HunterArmorParticleEffects INSTANCE = new HunterArmorParticleEffects();

    private HunterArmorParticleEffects() {
    }

    public final void spawnProtectionParticles(@NotNull Player player, @NotNull ProtectionType type) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        Vec3 position = player.position();
        int particleCount = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 15;
            case 2 -> 20;
            case 3 -> 25;
            case 4 -> 20;
            case 5 -> 30;
            default -> throw new NoWhenBranchMatchedException();
        };
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (level2.random.nextDouble() - 0.5) * 1.5;
            double offsetY = level2.random.nextDouble() * 2.0;
            double offsetZ = (level2.random.nextDouble() - 0.5) * 1.5;
            double velocityX = (level2.random.nextDouble() - 0.5) * 0.1;
            double velocityY = level2.random.nextDouble() * 0.2;
            double velocityZ = (level2.random.nextDouble() - 0.5) * 0.1;
            level2.sendParticles((ParticleOptions)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 5 -> ParticleTypes.ENCHANTED_HIT;
                case 4 -> ParticleTypes.CRIT;
                default -> ParticleTypes.WAX_ON;
            }), position.x + offsetX, position.y + offsetY, position.z + offsetZ, 1, velocityX, velocityY, velocityZ, 0.1);
        }
        if (HunterArmorDefenseHandler.INSTANCE.getHunterArmorPieceCount(player) > 0) {
            Intrinsics.checkNotNull((Object)position);
            this.spawnShieldEffect(level2, position);
        }
        this.playSoundEffect(level2, player, type);
    }

    private final void spawnShieldEffect(ServerLevel level, Vec3 position) {
        double radius = 1.0;
        int points = 20;
        for (int i = 0; i < points; ++i) {
            double angle = (double)i / (double)points * Math.PI * (double)2;
            double x = position.x + Math.cos(angle) * radius;
            double z = position.z + Math.sin(angle) * radius;
            for (int j = 0; j < 4; ++j) {
                double y = position.y + (double)j * 0.5;
                level.sendParticles((ParticleOptions)ParticleTypes.WAX_ON, x, y, z, 1, 0.0, 0.1, 0.0, 0.05);
            }
        }
    }

    private final void playSoundEffect(ServerLevel level, Player player, ProtectionType type) {
        SoundEvent sound = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 5 -> SoundEvents.SHIELD_BLOCK;
            case 4 -> SoundEvents.ENCHANTMENT_TABLE_USE;
            case 3 -> (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value();
            case 1 -> SoundEvents.BREWING_STAND_BREW;
            case 2 -> SoundEvents.TOTEM_USE;
            default -> throw new NoWhenBranchMatchedException();
        };
        level.playSound(null, player.blockPosition(), sound, SoundSource.PLAYERS, 0.5f, 1.0f + (level.random.nextFloat() - 0.5f) * 0.2f);
    }

    public final void spawnCurseReflectionEffect(@NotNull Player player, @NotNull ServerPlayer target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        Vec3 startPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 endPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 direction = endPos.subtract(startPos).normalize();
        double distance = startPos.distanceTo(endPos);
        int steps = RangesKt.coerceAtLeast((int)((int)(distance * (double)5)), (int)10);
        int i = 0;
        if (i <= steps) {
            while (true) {
                double progress = (double)i / (double)steps;
                Vec3 particlePos = startPos.add(direction.scale(distance * progress));
                level2.sendParticles((ParticleOptions)ParticleTypes.WITCH, particlePos.x, particlePos.y, particlePos.z, 2, 0.1, 0.1, 0.1, 0.05);
                level2.sendParticles((ParticleOptions)ParticleTypes.PORTAL, particlePos.x, particlePos.y, particlePos.z, 1, 0.05, 0.05, 0.05, 0.1);
                if (i == steps) break;
                ++i;
            }
        }
        for (i = 0; i < 21; ++i) {
            double offsetX = (level2.random.nextDouble() - 0.5) * 0.5;
            double offsetY = (level2.random.nextDouble() - 0.5) * 0.5;
            double offsetZ = (level2.random.nextDouble() - 0.5) * 0.5;
            level2.sendParticles((ParticleOptions)ParticleTypes.SMOKE, endPos.x + offsetX, endPos.y + offsetY, endPos.z + offsetZ, 1, 0.0, 0.1, 0.0, 0.05);
        }
        level2.playSound(null, target.blockPosition(), (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.PLAYERS, 1.0f, 0.8f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/hunter/HunterArmorParticleEffects$ProtectionType;", "", "<init>", "(Ljava/lang/String;I)V", "POTION_REDUCTION", "CURSE_REDUCTION", "POPPET_DAMAGE", "MAGIC_RESISTANCE", "CURSE_REFLECTION", "witchery"})
    public static final class ProtectionType
    extends Enum<ProtectionType> {
        public static final /* enum */ ProtectionType POTION_REDUCTION = new ProtectionType();
        public static final /* enum */ ProtectionType CURSE_REDUCTION = new ProtectionType();
        public static final /* enum */ ProtectionType POPPET_DAMAGE = new ProtectionType();
        public static final /* enum */ ProtectionType MAGIC_RESISTANCE = new ProtectionType();
        public static final /* enum */ ProtectionType CURSE_REFLECTION = new ProtectionType();
        private static final /* synthetic */ ProtectionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProtectionType[] values() {
            return (ProtectionType[])$VALUES.clone();
        }

        public static ProtectionType valueOf(String value) {
            return Enum.valueOf(ProtectionType.class, value);
        }

        @NotNull
        public static EnumEntries<ProtectionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = protectionTypeArray = new ProtectionType[]{ProtectionType.POTION_REDUCTION, ProtectionType.CURSE_REDUCTION, ProtectionType.POPPET_DAMAGE, ProtectionType.MAGIC_RESISTANCE, ProtectionType.CURSE_REFLECTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtectionType.values().length];
            try {
                nArray[ProtectionType.POTION_REDUCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtectionType.CURSE_REDUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtectionType.POPPET_DAMAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtectionType.MAGIC_RESISTANCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtectionType.CURSE_REFLECTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

