/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.infusion;

import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\"\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionHandler;", "", "<init>", "()V", "increaseInfusionCharge", "", "player", "Lnet/minecraft/world/entity/player/Player;", "toAdd", "", "decreaseInfusionCharge", "toRemove", "hasWitchesHand", "", "canUse", "onHoldRightClick", "onHoldReleaseRightClick", "leftClickEntity", "entity", "Lnet/minecraft/world/entity/Entity;", "leftClickBlock", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "blockPos", "Lnet/minecraft/core/BlockPos;", "witchery"})
public final class InfusionHandler {
    @NotNull
    public static final InfusionHandler INSTANCE = new InfusionHandler();

    private InfusionHandler() {
    }

    @JvmStatic
    public static final void increaseInfusionCharge(@NotNull Player player, int toAdd) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int currentCharge = InfusionPlayerAttachment.getInfusionCharge(player);
        int newCharge = RangesKt.coerceAtMost((int)(currentCharge + toAdd), (int)6000);
        InfusionPlayerAttachment.setInfusionCharge(player, newCharge);
    }

    @JvmStatic
    public static final void decreaseInfusionCharge(@NotNull Player player, int toRemove) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int currentCharge = InfusionPlayerAttachment.getInfusionCharge(player);
        if (currentCharge > 0) {
            InfusionPlayerAttachment.setInfusionCharge(player, currentCharge - toRemove);
        }
    }

    private final boolean hasWitchesHand(Player player) {
        return player.getMainHandItem().is((Item)WitcheryItems.INSTANCE.getWITCHES_HAND().get());
    }

    public final boolean canUse(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.hasWitchesHand(player) && InfusionPlayerAttachment.getData(player).getType() != InfusionType.NONE;
    }

    public final void onHoldRightClick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.canUse(player)) {
            InfusionType infusionType = InfusionPlayerAttachment.getData(player).getType();
            infusionType.onHoldRightClick(player);
        }
    }

    public final void onHoldReleaseRightClick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.canUse(player)) {
            InfusionType infusionType = InfusionPlayerAttachment.getData(player).getType();
            boolean bl = player.isShiftKeyDown() ? infusionType.onReleaseRightClickShift(player) : infusionType.onReleaseRightClick(player);
        }
    }

    public final void leftClickEntity(@NotNull Player player, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.canUse(player)) {
            InfusionType infusionType = InfusionPlayerAttachment.getData(player).getType();
            boolean bl = player.isShiftKeyDown() ? infusionType.leftClickEntityShift(player, entity) : infusionType.leftClickEntity(player, entity);
        }
    }

    public final void leftClickBlock(@NotNull Player player, @Nullable InteractionHand interactionHand, @Nullable BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.canUse(player)) {
            InfusionType infusionType = InfusionPlayerAttachment.getData(player).getType();
            boolean bl = player.isShiftKeyDown() ? infusionType.leftClickBlockShift(player, blockPos) : infusionType.leftClickBlock(player, blockPos);
        }
    }
}

