/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.infusion;

import com.mojang.serialization.Codec;
import dev.sterner.witchery.features.infusion.CreatureType;
import dev.sterner.witchery.features.infusion.InfernalInfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionHandler;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.LightInfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.OtherwhereInfusionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.NecroHandler;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u001b2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionType;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "LIGHT", "OVERWORLD", "INFERNAL", "OTHERWHERE", "NECRO", "onHoldRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onReleaseRightClick", "leftClickEntity", "entity", "Lnet/minecraft/world/entity/Entity;", "leftClickBlock", "blockPos", "Lnet/minecraft/core/BlockPos;", "onReleaseRightClickShift", "leftClickEntityShift", "leftClickBlockShift", "getSerializedName", "", "Companion", "witchery"})
public class InfusionType
extends Enum<InfusionType>
implements StringRepresentable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Codec<InfusionType> CODEC;
    public static final /* enum */ InfusionType NONE;
    public static final /* enum */ InfusionType LIGHT;
    public static final /* enum */ InfusionType OVERWORLD;
    public static final /* enum */ InfusionType INFERNAL;
    public static final /* enum */ InfusionType OTHERWHERE;
    public static final /* enum */ InfusionType NECRO;
    private static final /* synthetic */ InfusionType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private InfusionType() {
    }

    public boolean onHoldRightClick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean onReleaseRightClick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean leftClickEntity(@NotNull Player player, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean leftClickBlock(@NotNull Player player, @Nullable BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean onReleaseRightClickShift(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean leftClickEntityShift(@NotNull Player player, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    public boolean leftClickBlockShift(@NotNull Player player, @Nullable BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    @NotNull
    public String getSerializedName() {
        String string = this.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    public static InfusionType[] values() {
        return (InfusionType[])$VALUES.clone();
    }

    public static InfusionType valueOf(String value) {
        return Enum.valueOf(InfusionType.class, value);
    }

    @NotNull
    public static EnumEntries<InfusionType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ InfusionType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        NONE = new InfusionType();
        LIGHT = new LIGHT("LIGHT", 1);
        OVERWORLD = new OVERWORLD("OVERWORLD", 2);
        INFERNAL = new INFERNAL("INFERNAL", 3);
        OTHERWHERE = new OTHERWHERE("OTHERWHERE", 4);
        NECRO = new NECRO("NECRO", 5);
        $VALUES = infusionTypeArray = new InfusionType[]{InfusionType.NONE, InfusionType.LIGHT, InfusionType.OVERWORLD, InfusionType.INFERNAL, InfusionType.OTHERWHERE, InfusionType.NECRO};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(InfusionType::values);
        Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
        CODEC = (Codec)enumCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionType$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/infusion/InfusionType;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "isPosClear", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "raytraceForTeleport", "Lnet/minecraft/world/phys/Vec3;", "player", "Lnet/minecraft/world/entity/player/Player;", "teleportHoldTicks", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<InfusionType> getCODEC() {
            return CODEC;
        }

        private final boolean isPosClear(Level level, BlockPos pos) {
            return !(!level.isEmptyBlock(pos) && !level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty() || !level.isEmptyBlock(pos.above()) && !level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos.above()).isEmpty());
        }

        @Nullable
        public final Vec3 raytraceForTeleport(@NotNull Player player, int teleportHoldTicks) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Level level = player.level();
            int bonusDistance = teleportHoldTicks / 20 * 16;
            Vec3 eyePos = player.getEyePosition(0.0f);
            Vec3 dir = player.getViewVector(0.0f);
            double maxDistance = 16.0 + (double)bonusDistance;
            Vec3 rayEnd = eyePos.add(dir.scale(maxDistance));
            BlockHitResult blockHitResult = level.clip(new ClipContext(eyePos, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
            BlockHitResult result = blockHitResult;
            Direction direction = result.getDirection();
            BlockPos targetPos = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> result.getBlockPos().below(2);
                case 2 -> result.getBlockPos().above();
                default -> result.getBlockPos().relative(result.getDirection());
            };
            Intrinsics.checkNotNull((Object)level);
            BlockPos blockPos = targetPos;
            Intrinsics.checkNotNull((Object)blockPos);
            boolean posIsFree = this.isPosClear(level, blockPos);
            while (!posIsFree) {
                blockPos = targetPos = targetPos.below();
                Intrinsics.checkNotNull((Object)blockPos);
                boolean bl = posIsFree = this.isPosClear(level, blockPos) && level.clip(new ClipContext(eyePos, Vec3.atCenterOf((Vec3i)((Vec3i)targetPos.above())), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
                if (targetPos.getY() > level.getMinBuildHeight()) continue;
            }
            return posIsFree ? Vec3.atCenterOf((Vec3i)((Vec3i)targetPos)) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.DOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.UP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"dev/sterner/witchery/features/infusion/InfusionType.INFERNAL", "Ldev/sterner/witchery/features/infusion/InfusionType;", "onReleaseRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class INFERNAL
    extends InfusionType {
        /*
         * WARNING - void declaration
         */
        INFERNAL() {
            void var1_1;
        }

        @Override
        public boolean onReleaseRightClick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InfernalInfusionPlayerAttachment.Data data2 = InfernalInfusionPlayerAttachment.getData(player);
            HitResult hit = ProjectileUtil.getHitResultOnViewVector((Entity)((Entity)player), INFERNAL::onReleaseRightClick$lambda$0, (double)player.blockInteractionRange());
            CreatureType creatureType = data2.getCurrentCreature();
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Vec3 vec3 = player.getLookAngle();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLookAngle(...)");
            Intrinsics.checkNotNull((Object)hit);
            boolean bl = creatureType.usePower(player, level, vec3, hit);
            if (bl) {
                InfusionHandler.decreaseInfusionCharge(player, data2.getCurrentCreature().getCost());
            }
            return false;
        }

        private static final boolean onReleaseRightClick$lambda$0(Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return !entity.isSpectator() && entity.isPickable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"dev/sterner/witchery/features/infusion/InfusionType.LIGHT", "Ldev/sterner/witchery/features/infusion/InfusionType;", "onHoldRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class LIGHT
    extends InfusionType {
        /*
         * WARNING - void declaration
         */
        LIGHT() {
            void var1_1;
        }

        @Override
        public boolean onHoldRightClick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            LightInfusionPlayerAttachment.Data data2 = LightInfusionPlayerAttachment.isInvisible(player);
            if (InfusionPlayerAttachment.getInfusionCharge(player) >= 200 && !data2.isInvisible()) {
                LightInfusionPlayerAttachment.setInvisible(player, true, 10);
                InfusionHandler.decreaseInfusionCharge(player, 200);
                return true;
            }
            if (InfusionPlayerAttachment.getInfusionCharge(player) > 2 && data2.getInvisibleTimer() > 4) {
                LightInfusionPlayerAttachment.setInvisible(player, true, 6);
                InfusionHandler.decreaseInfusionCharge(player, 2);
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"dev/sterner/witchery/features/infusion/InfusionType.NECRO", "Ldev/sterner/witchery/features/infusion/InfusionType;", "onReleaseRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class NECRO
    extends InfusionType {
        /*
         * WARNING - void declaration
         */
        NECRO() {
            void var1_1;
        }

        @Override
        public boolean onReleaseRightClick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (InfusionPlayerAttachment.getInfusionCharge(player) >= 500) {
                HitResult hit = ProjectileUtil.getHitResultOnViewVector((Entity)((Entity)player), NECRO::onReleaseRightClick$lambda$0, (double)(player.blockInteractionRange() * (double)2));
                if (player.level() instanceof ServerLevel) {
                    Level level = player.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockPos blockPos = BlockPos.containing((Position)((Position)hit.getLocation()));
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
                    NecroHandler.INSTANCE.summonNecroAroundPos(serverLevel, player, blockPos, 8);
                }
                InfusionHandler.decreaseInfusionCharge(player, 500);
                return true;
            }
            return false;
        }

        private static final boolean onReleaseRightClick$lambda$0(Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return !entity.isSpectator() && entity.isPickable();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"dev/sterner/witchery/features/infusion/InfusionType.OTHERWHERE", "Ldev/sterner/witchery/features/infusion/InfusionType;", "onReleaseRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onHoldRightClick", "witchery"})
    static final class OTHERWHERE
    extends InfusionType {
        /*
         * WARNING - void declaration
         */
        OTHERWHERE() {
            void var1_1;
        }

        @Override
        public boolean onReleaseRightClick(@NotNull Player player) {
            OtherwhereInfusionPlayerAttachment.Data data2;
            Vec3 target;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (InfusionPlayerAttachment.getInfusionCharge(player) >= 500 && (target = Companion.raytraceForTeleport(player, (data2 = OtherwhereInfusionPlayerAttachment.getInfusion(player)).getTeleportHoldTicks())) != null) {
                InfusionHandler.decreaseInfusionCharge(player, 500);
                player.teleportTo(target.x, target.y, target.z);
                OtherwhereInfusionPlayerAttachment.Data old = OtherwhereInfusionPlayerAttachment.getInfusion(player);
                OtherwhereInfusionPlayerAttachment.setInfusion(player, 0, old.getTeleportCooldown());
                return true;
            }
            OtherwhereInfusionPlayerAttachment.Data old = OtherwhereInfusionPlayerAttachment.getInfusion(player);
            OtherwhereInfusionPlayerAttachment.setInfusion(player, 0, old.getTeleportCooldown());
            return false;
        }

        @Override
        public boolean onHoldRightClick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            OtherwhereInfusionPlayerAttachment.Data old = OtherwhereInfusionPlayerAttachment.getInfusion(player);
            int n = old.getTeleportHoldTicks() + 1;
            OtherwhereInfusionPlayerAttachment.setInfusion(player, Math.min(n, 80), old.getTeleportCooldown());
            if (n % 40 == 0) {
                player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
            }
            return super.onHoldRightClick(player);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"dev/sterner/witchery/features/infusion/InfusionType.OVERWORLD", "Ldev/sterner/witchery/features/infusion/InfusionType;", "onReleaseRightClick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class OVERWORLD
    extends InfusionType {
        /*
         * WARNING - void declaration
         */
        OVERWORLD() {
            void var1_1;
        }

        @Override
        public boolean onReleaseRightClick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return false;
        }
    }
}

