/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.mirror;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.mirror.MirrorBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.mirror.MirrorRegistryAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J \u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J&\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$Data;", "level", "Lnet/minecraft/server/level/ServerLevel;", "setData", "", "data", "registerMirror", "pairId", "Ljava/util/UUID;", "pos", "Lnet/minecraft/core/GlobalPos;", "unregisterMirror", "updateLoadedMirrorsForPair", "allEntries", "", "Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$MirrorEntry;", "findPairedMirror", "currentPos", "Data", "MirrorEntry", "witchery"})
@SourceDebugExtension(value={"SMAP\nMirrorRegistryAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirrorRegistryAttachment.kt\ndev/sterner/witchery/features/mirror/MirrorRegistryAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n774#3:102\n865#3,2:103\n774#3:105\n865#3,2:106\n295#3,2:108\n*S KotlinDebug\n*F\n+ 1 MirrorRegistryAttachment.kt\ndev/sterner/witchery/features/mirror/MirrorRegistryAttachment\n*L\n45#1:102\n45#1:103,2\n55#1:105\n55#1:106,2\n58#1:108,2\n*E\n"})
public final class MirrorRegistryAttachment {
    @NotNull
    public static final MirrorRegistryAttachment INSTANCE = new MirrorRegistryAttachment();

    private MirrorRegistryAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = level.getData(WitcheryDataAttachments.getMIRROR_REGISTRY_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull ServerLevel level, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        level.setData(WitcheryDataAttachments.getMIRROR_REGISTRY_ATTACHMENT(), (Object)data2);
    }

    @JvmStatic
    public static final void registerMirror(@NotNull ServerLevel level, @NotNull UUID pairId, @NotNull GlobalPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pairId, (String)"pairId");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Data data2 = MirrorRegistryAttachment.getData(level);
        List updatedEntries = CollectionsKt.toMutableList((Collection)data2.getEntries());
        updatedEntries.removeIf(arg_0 -> MirrorRegistryAttachment.registerMirror$lambda$1(arg_0 -> MirrorRegistryAttachment.registerMirror$lambda$0(pos, arg_0), arg_0));
        updatedEntries.add(new MirrorEntry(pairId, pos));
        MirrorRegistryAttachment.setData(level, new Data(updatedEntries));
        INSTANCE.updateLoadedMirrorsForPair(level, pairId, updatedEntries);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void unregisterMirror(@NotNull ServerLevel level, @NotNull GlobalPos pos) {
        void $this$filterTo$iv$iv;
        Object v0;
        Object object2;
        Data data2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            data2 = MirrorRegistryAttachment.getData(level);
            Iterable iterable = data2.getEntries();
            for (Object object2 : iterable) {
                MirrorEntry it = (MirrorEntry)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPos(), (Object)pos)) continue;
                v0 = object2;
                break block3;
            }
            v0 = null;
        }
        MirrorEntry removedEntry = v0;
        Iterable $this$filter$iv = data2.getEntries();
        boolean $i$f$filter = false;
        object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MirrorEntry it = (MirrorEntry)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getPos(), (Object)pos))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List updatedEntries = (List)destination$iv$iv;
        MirrorRegistryAttachment.setData(level, new Data(updatedEntries));
        if (removedEntry != null) {
            INSTANCE.updateLoadedMirrorsForPair(level, removedEntry.getPairId(), updatedEntries);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLoadedMirrorsForPair(ServerLevel level, UUID pairId, List<MirrorEntry> allEntries) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allEntries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MirrorEntry it = (MirrorEntry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPairId(), (Object)pairId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pairEntries = (List)destination$iv$iv;
        for (MirrorEntry entry : pairEntries) {
            BlockEntity be;
            GlobalPos pairedPos;
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = pairEntries;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MirrorEntry it = (MirrorEntry)element$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getPos(), (Object)entry.getPos()))) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            MirrorEntry mirrorEntry = v0;
            Object object = pairedPos = mirrorEntry != null ? mirrorEntry.getPos() : null;
            ServerLevel targetLevel = level.getServer().getLevel(entry.getPos().dimension());
            if (targetLevel == null || !((be = targetLevel.getBlockEntity(entry.getPos().pos())) instanceof MirrorBlockEntity)) continue;
            ((MirrorBlockEntity)be).setCachedLinkedMirror(pairedPos);
            ((MirrorBlockEntity)be).setChanged();
        }
    }

    @JvmStatic
    @Nullable
    public static final GlobalPos findPairedMirror(@NotNull ServerLevel level, @NotNull UUID pairId, @NotNull GlobalPos currentPos) {
        MirrorEntry pairedMirror;
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pairId, (String)"pairId");
            Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
            Data data2 = MirrorRegistryAttachment.getData(level);
            Iterable iterable = data2.getEntries();
            for (Object t : iterable) {
                MirrorEntry it = (MirrorEntry)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getPairId(), (Object)pairId) && !Intrinsics.areEqual((Object)it.getPos(), (Object)currentPos))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MirrorEntry mirrorEntry = pairedMirror = (MirrorEntry)v0;
        return mirrorEntry != null ? mirrorEntry.getPos() : null;
    }

    private static final boolean registerMirror$lambda$0(GlobalPos $pos, MirrorEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getPos(), (Object)$pos);
    }

    private static final boolean registerMirror$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$Data;", "", "entries", "", "Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$MirrorEntry;", "<init>", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<MirrorEntry> entries;
        @NotNull
        private static final ResourceLocation ID;
        @NotNull
        private static final Codec<Data> DATA_CODEC;

        public Data(@NotNull List<MirrorEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
        }

        public /* synthetic */ Data(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<MirrorEntry> getEntries() {
            return this.entries;
        }

        @NotNull
        public final List<MirrorEntry> component1() {
            return this.entries;
        }

        @NotNull
        public final Data copy(@NotNull List<MirrorEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            return new Data(entries);
        }

        public static /* synthetic */ Data copy$default(Data data2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = data2.entries;
            }
            return data2.copy(list);
        }

        @NotNull
        public String toString() {
            return "Data(entries=" + this.entries + ")";
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            return Intrinsics.areEqual(this.entries, data2.entries);
        }

        private static final Data DATA_CODEC$lambda$0(Function1 $tmp0, Object p0) {
            return (Data)$tmp0.invoke(p0);
        }

        private static final List DATA_CODEC$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        public Data() {
            this(null, 1, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("mirror_registry");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = MirrorEntry.Companion.getCODEC().listOf().fieldOf("entries").xmap(arg_0 -> Data.DATA_CODEC$lambda$0(Companion.DATA_CODEC.1.INSTANCE, arg_0), arg_0 -> Data.DATA_CODEC$lambda$1((Function1)Companion.DATA_CODEC.2.INSTANCE, arg_0)).codec();
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec(...)");
            DATA_CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "DATA_CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$Data;", "getDATA_CODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getDATA_CODEC() {
                return DATA_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$MirrorEntry;", "", "pairId", "Ljava/util/UUID;", "pos", "Lnet/minecraft/core/GlobalPos;", "<init>", "(Ljava/util/UUID;Lnet/minecraft/core/GlobalPos;)V", "getPairId", "()Ljava/util/UUID;", "getPos", "()Lnet/minecraft/core/GlobalPos;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class MirrorEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UUID pairId;
        @NotNull
        private final GlobalPos pos;
        @NotNull
        private static final Codec<MirrorEntry> CODEC;

        public MirrorEntry(@NotNull UUID pairId, @NotNull GlobalPos pos) {
            Intrinsics.checkNotNullParameter((Object)pairId, (String)"pairId");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pairId = pairId;
            this.pos = pos;
        }

        @NotNull
        public final UUID getPairId() {
            return this.pairId;
        }

        @NotNull
        public final GlobalPos getPos() {
            return this.pos;
        }

        @NotNull
        public final UUID component1() {
            return this.pairId;
        }

        @NotNull
        public final GlobalPos component2() {
            return this.pos;
        }

        @NotNull
        public final MirrorEntry copy(@NotNull UUID pairId, @NotNull GlobalPos pos) {
            Intrinsics.checkNotNullParameter((Object)pairId, (String)"pairId");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new MirrorEntry(pairId, pos);
        }

        public static /* synthetic */ MirrorEntry copy$default(MirrorEntry mirrorEntry, UUID uUID, GlobalPos globalPos, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = mirrorEntry.pairId;
            }
            if ((n & 2) != 0) {
                globalPos = mirrorEntry.pos;
            }
            return mirrorEntry.copy(uUID, globalPos);
        }

        @NotNull
        public String toString() {
            return "MirrorEntry(pairId=" + this.pairId + ", pos=" + this.pos + ")";
        }

        public int hashCode() {
            int result = this.pairId.hashCode();
            result = result * 31 + this.pos.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MirrorEntry)) {
                return false;
            }
            MirrorEntry mirrorEntry = (MirrorEntry)other;
            if (!Intrinsics.areEqual((Object)this.pairId, (Object)mirrorEntry.pairId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pos, (Object)mirrorEntry.pos);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance inst) {
            return inst.group((App)UUIDUtil.CODEC.fieldOf("pairId").forGetter(arg_0 -> MirrorEntry.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)GlobalPos.CODEC.fieldOf("pos").forGetter(arg_0 -> MirrorEntry.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)inst, MirrorEntry::new);
        }

        private static final UUID CODEC$lambda$0$0(KProperty1 $tmp0, MirrorEntry p0) {
            return (UUID)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final GlobalPos CODEC$lambda$0$1(KProperty1 $tmp0, MirrorEntry p0) {
            return (GlobalPos)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(MirrorEntry::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$MirrorEntry$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/mirror/MirrorRegistryAttachment$MirrorEntry;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<MirrorEntry> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

