/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.misc.BindingRitualAttachment;
import dev.sterner.witchery.network.SyncBindingRitualS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/misc/BindingRitualAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/misc/BindingRitualAttachment$Data;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setData", "", "data", "sync", "player", "Lnet/minecraft/world/entity/player/Player;", "tick", "Data", "witchery"})
public final class BindingRitualAttachment {
    @NotNull
    public static final BindingRitualAttachment INSTANCE = new BindingRitualAttachment();

    private BindingRitualAttachment() {
    }

    @NotNull
    public final Data getData(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Object object = livingEntity.getData(WitcheryDataAttachments.getBINDING_CURSE());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    public final void setData(@NotNull LivingEntity livingEntity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        livingEntity.setData(WitcheryDataAttachments.getBINDING_CURSE(), (Object)data2);
        if (livingEntity instanceof Player) {
            this.sync((Player)livingEntity);
        }
    }

    public final void sync(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player instanceof ServerPlayer) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncBindingRitualS2CPayload(player, this.getData((LivingEntity)player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void tick(@NotNull LivingEntity livingEntity) {
        int newDuration;
        boolean isOutsideBox;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity.level().isClientSide) {
            return;
        }
        Data data2 = this.getData(livingEntity);
        if (!data2.isActive()) {
            return;
        }
        BlockPos centerPos = data2.getCenterPos();
        double radius = data2.getRadius();
        boolean bl = isOutsideBox = livingEntity.getX() < (double)centerPos.getX() - radius + 1.0 || livingEntity.getX() > (double)centerPos.getX() + radius || livingEntity.getY() < (double)centerPos.getY() - radius + 1.0 || livingEntity.getY() > (double)centerPos.getY() + radius || livingEntity.getZ() < (double)centerPos.getZ() - radius + 1.0 || livingEntity.getZ() > (double)centerPos.getZ() + radius;
        if (isOutsideBox) {
            Vec3 direction = new Vec3((double)centerPos.getX() + 0.5 - livingEntity.getX(), (double)centerPos.getY() + 0.5 - livingEntity.getY(), (double)centerPos.getZ() + 0.5 - livingEntity.getZ()).normalize();
            double pullStrength = 0.5;
            livingEntity.setDeltaMovement(livingEntity.getDeltaMovement().add(direction.x * pullStrength, direction.y * pullStrength * 0.5, direction.z * pullStrength));
            livingEntity.hurtMarked = true;
            if (livingEntity.level() instanceof ServerLevel) {
                Level level = livingEntity.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, livingEntity.getX(), livingEntity.getY() + 1.0, livingEntity.getZ(), 5, 0.3, 0.3, 0.3, 0.05);
                if (livingEntity.level().getGameTime() % (long)40 == 0L) {
                    livingEntity.level().playSound(null, livingEntity.blockPosition(), SoundEvents.CHAIN_BREAK, SoundSource.PLAYERS, 0.5f, 1.5f);
                }
            }
        }
        if ((newDuration = data2.getDuration() - 1) <= 0) {
            Data newData = new Data(centerPos, radius, 0, false);
            this.setData(livingEntity, newData);
        } else {
            Data newData = new Data(centerPos, radius, newDuration, true);
            this.setData(livingEntity, newData);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/features/misc/BindingRitualAttachment$Data;", "", "centerPos", "Lnet/minecraft/core/BlockPos;", "radius", "", "duration", "", "isActive", "", "<init>", "(Lnet/minecraft/core/BlockPos;DIZ)V", "getCenterPos", "()Lnet/minecraft/core/BlockPos;", "getRadius", "()D", "getDuration", "()I", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BlockPos centerPos;
        private final double radius;
        private final int duration;
        private final boolean isActive;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC;

        public Data(@NotNull BlockPos centerPos, double radius, int duration, boolean isActive) {
            Intrinsics.checkNotNullParameter((Object)centerPos, (String)"centerPos");
            this.centerPos = centerPos;
            this.radius = radius;
            this.duration = duration;
            this.isActive = isActive;
        }

        public /* synthetic */ Data(BlockPos blockPos, double d, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                BlockPos blockPos2 = BlockPos.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"ZERO");
                blockPos = blockPos2;
            }
            if ((n2 & 2) != 0) {
                d = 0.0;
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(blockPos, d, n, bl);
        }

        @NotNull
        public final BlockPos getCenterPos() {
            return this.centerPos;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        @NotNull
        public final BlockPos component1() {
            return this.centerPos;
        }

        public final double component2() {
            return this.radius;
        }

        public final int component3() {
            return this.duration;
        }

        public final boolean component4() {
            return this.isActive;
        }

        @NotNull
        public final Data copy(@NotNull BlockPos centerPos, double radius, int duration, boolean isActive) {
            Intrinsics.checkNotNullParameter((Object)centerPos, (String)"centerPos");
            return new Data(centerPos, radius, duration, isActive);
        }

        public static /* synthetic */ Data copy$default(Data data2, BlockPos blockPos, double d, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                blockPos = data2.centerPos;
            }
            if ((n2 & 2) != 0) {
                d = data2.radius;
            }
            if ((n2 & 4) != 0) {
                n = data2.duration;
            }
            if ((n2 & 8) != 0) {
                bl = data2.isActive;
            }
            return data2.copy(blockPos, d, n, bl);
        }

        @NotNull
        public String toString() {
            return "Data(centerPos=" + this.centerPos + ", radius=" + this.radius + ", duration=" + this.duration + ", isActive=" + this.isActive + ")";
        }

        public int hashCode() {
            int result = this.centerPos.hashCode();
            result = result * 31 + Double.hashCode(this.radius);
            result = result * 31 + Integer.hashCode(this.duration);
            result = result * 31 + Boolean.hashCode(this.isActive);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual((Object)this.centerPos, (Object)data2.centerPos)) {
                return false;
            }
            if (Double.compare(this.radius, data2.radius) != 0) {
                return false;
            }
            if (this.duration != data2.duration) {
                return false;
            }
            return this.isActive == data2.isActive;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)BlockPos.CODEC.fieldOf("centerPos").forGetter(Data::CODEC$lambda$0$0), (App)Codec.DOUBLE.fieldOf("radius").forGetter(Data::CODEC$lambda$0$1), (App)Codec.INT.fieldOf("duration").forGetter(Data::CODEC$lambda$0$2), (App)Codec.BOOL.fieldOf("isActive").forGetter(Data::CODEC$lambda$0$3)).apply((Applicative)instance, Data::new);
        }

        private static final BlockPos CODEC$lambda$0$0(Data it) {
            return it.centerPos;
        }

        private static final Double CODEC$lambda$0$1(Data it) {
            return it.radius;
        }

        private static final Integer CODEC$lambda$0$2(Data it) {
            return it.duration;
        }

        private static final Boolean CODEC$lambda$0$3(Data it) {
            return it.isActive;
        }

        private static final BlockPos STREAM_CODEC$lambda$0(KProperty1 $tmp0, Data p0) {
            return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Double STREAM_CODEC$lambda$1(KProperty1 $tmp0, Data p0) {
            return (Double)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer STREAM_CODEC$lambda$2(KProperty1 $tmp0, Data p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean STREAM_CODEC$lambda$3(KProperty1 $tmp0, Data p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        public Data() {
            this(null, 0.0, 0, false, 15, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, arg_0 -> Data.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.DOUBLE, arg_0 -> Data.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.VAR_INT, arg_0 -> Data.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> Data.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.4.INSTANCE, arg_0), Data::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/features/misc/BindingRitualAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/misc/BindingRitualAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, Data> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

