/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/features/misc/PotionHandler;", "", "<init>", "()V", "poisonWeaponAttack", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "handleHurt", "entity", "remainingDamage", "witchery"})
public final class PotionHandler {
    @NotNull
    public static final PotionHandler INSTANCE = new PotionHandler();

    private PotionHandler() {
    }

    public final void poisonWeaponAttack(@NotNull LivingEntity livingEntity, @Nullable DamageSource damageSource, float amount) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (damageSource != null && damageSource.getEntity() instanceof LivingEntity) {
            Entity entity = damageSource.getEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker.hasEffect((Holder)WitcheryMobEffects.INSTANCE.getPOISON_WEAPON())) {
                MobEffectInstance mobEffectInstance = attacker.getEffect((Holder)WitcheryMobEffects.INSTANCE.getPOISON_WEAPON());
                int amp = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, amp));
            }
        }
    }

    public final float handleHurt(@NotNull LivingEntity entity, @NotNull DamageSource damageSource, float remainingDamage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (entity.getType().is(EntityTypeTags.ARTHROPOD) && damageSource.getEntity() instanceof LivingEntity) {
            Entity entity2 = damageSource.getEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity attacker = (LivingEntity)entity2;
            if (attacker.hasEffect((Holder)WitcheryMobEffects.INSTANCE.getBANE_OF_ARTHROPODS_WEAPON())) {
                MobEffectInstance mobEffectInstance = attacker.getEffect((Holder)WitcheryMobEffects.INSTANCE.getBANE_OF_ARTHROPODS_WEAPON());
                int amp = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
                return remainingDamage + (float)amp * (float)2;
            }
        }
        return remainingDamage;
    }
}

