/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.core.api.TeleportRequest;
import dev.sterner.witchery.features.misc.TeleportQueueLevelAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020!H\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020!H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020!H\u0002J\u0016\u0010&\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/sterner/witchery/features/misc/TeleportQueueHandler;", "", "<init>", "()V", "PROCESS_INTERVAL", "", "MIN_WAIT_TICKS", "MAX_ATTEMPTS", "STALE_REQUEST_TIME", "", "clearQueue", "", "server", "Lnet/minecraft/server/MinecraftServer;", "processQueue", "processLevelQueue", "level", "Lnet/minecraft/server/level/ServerLevel;", "safelyUnforceChunk", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "updatePendingTeleports", "data", "Ldev/sterner/witchery/features/misc/TeleportQueueLevelAttachment$Data;", "toRemove", "", "Ldev/sterner/witchery/core/api/TeleportRequest;", "handleTeleport", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "request", "findSafeSpot", "Lnet/minecraft/core/BlockPos;", "pos", "isSafeTeleportPos", "findSleepingEntityAt", "Ldev/sterner/witchery/content/entity/player_shell/SleepingPlayerEntity;", "addRequest", "witchery"})
@SourceDebugExtension(value={"SMAP\nTeleportQueueHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeleportQueueHandler.kt\ndev/sterner/witchery/features/misc/TeleportQueueHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1869#2:216\n1869#2,2:217\n1870#2:219\n1869#2,2:220\n1869#2,2:222\n1#3:224\n*S KotlinDebug\n*F\n+ 1 TeleportQueueHandler.kt\ndev/sterner/witchery/features/misc/TeleportQueueHandler\n*L\n21#1:216\n23#1:217,2\n21#1:219\n37#1:220,2\n52#1:222,2\n*E\n"})
public final class TeleportQueueHandler {
    @NotNull
    public static final TeleportQueueHandler INSTANCE = new TeleportQueueHandler();
    private static final int PROCESS_INTERVAL = 10;
    private static final int MIN_WAIT_TICKS = 5;
    private static final int MAX_ATTEMPTS = 10;
    private static final long STALE_REQUEST_TIME = 6000L;

    private TeleportQueueHandler() {
    }

    public final void clearQueue(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable iterable = server.getAllLevels();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)level);
            TeleportQueueLevelAttachment.Data data2 = TeleportQueueLevelAttachment.getData(level);
            Iterable $this$forEach$iv2 = data2.getPendingTeleports();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TeleportRequest request = (TeleportRequest)element$iv2;
                boolean bl2 = false;
                level.setChunkForced(request.getChunkPos().x, request.getChunkPos().z, false);
            }
            TeleportQueueLevelAttachment.setData(level, new TeleportQueueLevelAttachment.Data(new ArrayList()));
        }
    }

    public final void processQueue(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (server.getTickCount() % 10 != 0) {
            return;
        }
        Iterable iterable = server.getAllLevels();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (level == null) continue;
            INSTANCE.processLevelQueue(level);
        }
    }

    private final void processLevelQueue(ServerLevel level) {
        TeleportQueueLevelAttachment.Data data2 = TeleportQueueLevelAttachment.getData(level);
        long currentTime = level.getGameTime();
        List toRemove = new ArrayList();
        Iterable $this$forEach$iv = data2.getPendingTeleports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TeleportRequest request = (TeleportRequest)element$iv;
            boolean bl = false;
            try {
                if (currentTime - request.getCreatedGameTime() < 5L) continue;
                ServerPlayer player = level.getServer().getPlayerList().getPlayer(request.getPlayer());
                if (player != null) {
                    boolean success = INSTANCE.handleTeleport(player, request, level);
                    if (success) {
                        toRemove.add(request);
                        INSTANCE.safelyUnforceChunk(level, request.getChunkPos());
                        continue;
                    }
                    int n = request.getAttempts();
                    request.setAttempts(n + 1);
                    if (request.getAttempts() < 10) continue;
                    toRemove.add(request);
                    INSTANCE.safelyUnforceChunk(level, request.getChunkPos());
                    continue;
                }
                if (currentTime - request.getCreatedGameTime() <= 6000L) continue;
                toRemove.add(request);
                INSTANCE.safelyUnforceChunk(level, request.getChunkPos());
            }
            catch (Exception e) {
                toRemove.add(request);
                INSTANCE.safelyUnforceChunk(level, request.getChunkPos());
            }
        }
        if (!((Collection)toRemove).isEmpty()) {
            this.updatePendingTeleports(level, data2, toRemove);
        }
    }

    private final void safelyUnforceChunk(ServerLevel level, ChunkPos chunkPos) {
        try {
            level.setChunkForced(chunkPos.x, chunkPos.z, false);
        }
        catch (Exception e) {
            Witchery.Companion.getLOGGER().error("Failed to unforce chunk at " + chunkPos, (Throwable)e);
        }
    }

    private final void updatePendingTeleports(ServerLevel level, TeleportQueueLevelAttachment.Data data2, List<TeleportRequest> toRemove) {
        List updatedRequests = CollectionsKt.toMutableList((Collection)data2.getPendingTeleports());
        updatedRequests.removeAll((Collection)toRemove);
        TeleportQueueLevelAttachment.setData(level, new TeleportQueueLevelAttachment.Data(updatedRequests));
    }

    private final boolean handleTeleport(ServerPlayer player, TeleportRequest request, ServerLevel level) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                serverLevel = request.getSourceDimension();
                if (serverLevel == null) break block4;
                ServerLevel it = serverLevel;
                boolean bl = false;
                ServerLevel serverLevel2 = level.getServer().getLevel((ResourceKey)it);
                serverLevel = serverLevel2;
                if (serverLevel2 != null) break block5;
            }
            serverLevel = level.getServer().overworld();
        }
        ServerLevel targetLevel = serverLevel;
        BlockPos pos = request.getPos();
        BlockPos targetPos = BlockPos.containing((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.0), (double)((double)pos.getZ() + 0.5));
        Intrinsics.checkNotNull((Object)targetLevel);
        Intrinsics.checkNotNull((Object)targetPos);
        BlockPos teleportPos = this.findSafeSpot(targetLevel, targetPos);
        player.teleportTo(targetLevel, (double)teleportPos.getX() + 0.5, (double)teleportPos.getY() + 0.1, (double)teleportPos.getZ() + 0.5, player.getYRot(), player.getXRot());
        SleepingPlayerEntity sleep = this.findSleepingEntityAt(targetLevel, targetPos);
        if (sleep != null) {
            SleepingPlayerEntity.Companion.replaceWithPlayer((Player)player, sleep);
            return true;
        }
        return false;
    }

    private final BlockPos findSafeSpot(ServerLevel level, BlockPos pos) {
        if (this.isSafeTeleportPos(level, pos)) {
            return pos;
        }
        int radius = 5;
        Object object = new Integer[]{0, 1, 2, -1};
        List yOffsets = CollectionsKt.listOf((Object[])object);
        object = yOffsets.iterator();
        block0: while (object.hasNext()) {
            int y = ((Number)object.next()).intValue();
            int r = 0;
            while (true) {
                int x;
                if ((x = -r) <= r) {
                    while (true) {
                        int z;
                        if ((z = -r) <= r) {
                            while (true) {
                                if (Math.abs(x) == r || Math.abs(z) == r) {
                                    BlockPos testPos = pos.offset(x, y, z);
                                    Intrinsics.checkNotNull((Object)testPos);
                                    if (this.isSafeTeleportPos(level, testPos)) {
                                        return testPos;
                                    }
                                }
                                if (z == r) break;
                                ++z;
                            }
                        }
                        if (x == r) break;
                        ++x;
                    }
                }
                if (r == radius) continue block0;
                ++r;
            }
        }
        return pos;
    }

    private final boolean isSafeTeleportPos(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        BlockState stateAbove = level.getBlockState(pos.above());
        BlockState stateAbove2 = level.getBlockState(pos.above(2));
        BlockState stateBelow = level.getBlockState(pos.below());
        return !state.isCollisionShapeFullBlock((BlockGetter)level, pos) && !stateAbove.isCollisionShapeFullBlock((BlockGetter)level, pos.above()) && !stateAbove2.isCollisionShapeFullBlock((BlockGetter)level, pos.above(2)) && stateBelow.isCollisionShapeFullBlock((BlockGetter)level, pos.below()) && !state.liquid();
    }

    private final SleepingPlayerEntity findSleepingEntityAt(ServerLevel level, BlockPos pos) {
        AABB box = new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 1.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0);
        List list = level.getEntitiesOfClass(SleepingPlayerEntity.class, box);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        return (SleepingPlayerEntity)((Object)CollectionsKt.firstOrNull((List)list));
    }

    public final void addRequest(@NotNull ServerLevel level, @NotNull TeleportRequest request) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TeleportQueueLevelAttachment.Data data2 = TeleportQueueLevelAttachment.getData(level);
        List requests = CollectionsKt.toMutableList((Collection)data2.getPendingTeleports());
        requests.removeIf(arg_0 -> TeleportQueueHandler.addRequest$lambda$1(arg_0 -> TeleportQueueHandler.addRequest$lambda$0(request, arg_0), arg_0));
        requests.add(request);
        level.setChunkForced(request.getChunkPos().x, request.getChunkPos().z, true);
        TeleportQueueLevelAttachment.setData(level, new TeleportQueueLevelAttachment.Data(requests));
    }

    private static final boolean addRequest$lambda$0(TeleportRequest $request, TeleportRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getPlayer(), (Object)$request.getPlayer());
    }

    private static final boolean addRequest$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

