/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.mutandis;

import dev.sterner.witchery.features.mutandis.MutandisLevelAttachment;
import dev.sterner.witchery.network.MutandisRemenantParticleS2CPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0007J&\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/mutandis/MutandisHandler;", "", "<init>", "()V", "CACHE_LIFETIME", "", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "getMap", "", "Lnet/minecraft/core/BlockPos;", "Ldev/sterner/witchery/features/mutandis/MutandisLevelAttachment$MutandisData;", "Lnet/minecraft/server/level/ServerLevel;", "getTagForBlockPos", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/block/Block;", "pos", "setTagForBlockPos", "tag", "removeTagForBlockPos", "updateTimeForTagBlockPos", "resetTimeForTagBlockPos", "witchery"})
public final class MutandisHandler {
    @NotNull
    public static final MutandisHandler INSTANCE = new MutandisHandler();
    public static final int CACHE_LIFETIME = 60;

    private MutandisHandler() {
    }

    public final void tick(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List toRemove = new ArrayList();
        for (Map.Entry<BlockPos, MutandisLevelAttachment.MutandisData> entry : MutandisHandler.getMap(serverLevel).entrySet()) {
            BlockPos pos = entry.getKey();
            MutandisLevelAttachment.MutandisData mutandisData = entry.getValue();
            int time = mutandisData.component2();
            if (time <= 1) {
                toRemove.add(pos);
                continue;
            }
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new MutandisRemenantParticleS2CPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MutandisHandler.updateTimeForTagBlockPos(serverLevel, pos);
        }
        for (BlockPos pos : toRemove) {
            MutandisHandler.removeTagForBlockPos(serverLevel, pos);
        }
    }

    @JvmStatic
    @NotNull
    public static final Map<BlockPos, MutandisLevelAttachment.MutandisData> getMap(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return MutandisLevelAttachment.getData(level).getMutandisCacheMap();
    }

    @JvmStatic
    @Nullable
    public static final TagKey<Block> getTagForBlockPos(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MutandisLevelAttachment.MutandisData mutandisData = MutandisLevelAttachment.getData(level).getMutandisCacheMap().get(pos);
        return mutandisData != null ? mutandisData.getTag() : null;
    }

    @JvmStatic
    public static final void setTagForBlockPos(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull TagKey<Block> tag) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        MutandisLevelAttachment.Data data2 = MutandisLevelAttachment.getData(level);
        Map updatedMap = MapsKt.toMutableMap(data2.getMutandisCacheMap());
        updatedMap.put(pos, new MutandisLevelAttachment.MutandisData(tag, 60));
        MutandisLevelAttachment.setData(level, data2.copy(updatedMap));
    }

    @JvmStatic
    public static final void removeTagForBlockPos(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MutandisLevelAttachment.Data data2 = MutandisLevelAttachment.getData(level);
        Map updatedMap = MapsKt.toMutableMap(data2.getMutandisCacheMap());
        updatedMap.remove(pos);
        MutandisLevelAttachment.setData(level, data2.copy(updatedMap));
    }

    @JvmStatic
    public static final void updateTimeForTagBlockPos(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MutandisLevelAttachment.Data data2 = MutandisLevelAttachment.getData(level);
        MutandisLevelAttachment.MutandisData mutandisData = data2.getMutandisCacheMap().get(pos);
        if (mutandisData == null) {
            return;
        }
        MutandisLevelAttachment.MutandisData existingData = mutandisData;
        Map updatedMap = MapsKt.toMutableMap(data2.getMutandisCacheMap());
        updatedMap.put(pos, MutandisLevelAttachment.MutandisData.copy$default(existingData, null, existingData.getTime() - 1, 1, null));
        MutandisLevelAttachment.setData(level, data2.copy(updatedMap));
    }

    @JvmStatic
    public static final void resetTimeForTagBlockPos(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MutandisLevelAttachment.Data data2 = MutandisLevelAttachment.getData(level);
        MutandisLevelAttachment.MutandisData mutandisData = data2.getMutandisCacheMap().get(pos);
        if (mutandisData == null) {
            return;
        }
        MutandisLevelAttachment.MutandisData existingData = mutandisData;
        Map updatedMap = MapsKt.toMutableMap(data2.getMutandisCacheMap());
        updatedMap.put(pos, MutandisLevelAttachment.MutandisData.copy$default(existingData, null, 60, 1, null));
        MutandisLevelAttachment.setData(level, data2.copy(updatedMap));
    }
}

