/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.nightmare;

import dev.sterner.witchery.content.entity.NightmareEntity;
import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.nightmare.NightmarePlayerAttachment;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/features/nightmare/NightmareHandler;", "", "<init>", "()V", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
public final class NightmareHandler {
    @NotNull
    public static final NightmareHandler INSTANCE = new NightmareHandler();

    private NightmareHandler() {
    }

    public final void tick(@Nullable Player player) {
        Level level;
        if (Intrinsics.areEqual(player != null && (level = player.level()) != null ? level.dimension() : null, WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE()) && player.level() instanceof ServerLevel && !player.isCreative() && !player.isSpectator()) {
            Optional<UUID> nightmareUuid;
            NightmarePlayerAttachment.Data data2 = NightmarePlayerAttachment.getData(player);
            Level level2 = player.level();
            if (!data2.getHasNightmare()) {
                NightmareEntity nightmare;
                NightmareEntity nightmareEntity = nightmare = (NightmareEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getNIGHTMARE().get()).create(level2);
                Intrinsics.checkNotNull((Object)((Object)nightmareEntity));
                nightmareEntity.getEntityData().set(NightmareEntity.Companion.getNIGHTMARE_TARGET(), Optional.of(player.getUUID()));
                int distance = 16 + level2.random.nextInt(8);
                double angle = level2.random.nextDouble() * Math.PI * (double)2;
                int offsetX = (int)(Math.cos(angle) * (double)distance);
                int offsetZ = (int)(Math.sin(angle) * (double)distance);
                int spawnX = player.getBlockX() + offsetX;
                int spawnZ = player.getBlockZ() + offsetZ;
                int spawnY = level2.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnX, spawnZ);
                nightmare.moveTo((double)spawnX + 0.5, (double)spawnY + 1.0, (double)spawnZ + 0.5);
                level2.addFreshEntity((Entity)nightmare);
                Optional<UUID> optional = Optional.of(nightmare.getUUID());
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                NightmarePlayerAttachment.setData(player, new NightmarePlayerAttachment.Data(true, optional));
            }
            if (level2 instanceof ServerLevel && (nightmareUuid = data2.getNightmareUUID()).isPresent()) {
                Entity nightmare = ((ServerLevel)level2).getEntity(nightmareUuid.get());
                if (nightmare instanceof NightmareEntity) {
                    if (((NightmareEntity)nightmare).touchingUnloadedChunk()) {
                        ((NightmareEntity)nightmare).discard();
                        Optional<UUID> optional = Optional.empty();
                        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                        NightmarePlayerAttachment.setData(player, new NightmarePlayerAttachment.Data(false, optional));
                    }
                } else {
                    Entity entity = nightmare;
                    if (entity != null) {
                        entity.discard();
                    }
                    Optional<UUID> optional = Optional.empty();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                    NightmarePlayerAttachment.setData(player, new NightmarePlayerAttachment.Data(false, optional));
                }
            }
        }
    }
}

