/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.nightmare;

import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncNightmareS2CPayload;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/nightmare/NightmarePlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/nightmare/NightmarePlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Data", "witchery"})
public final class NightmarePlayerAttachment {
    @NotNull
    public static final NightmarePlayerAttachment INSTANCE = new NightmarePlayerAttachment();

    private NightmarePlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getNIGHTMARE_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getNIGHTMARE_PLAYER_DATA_ATTACHMENT(), (Object)data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncNightmareS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/nightmare/NightmarePlayerAttachment$Data;", "", "hasNightmare", "", "nightmareUUID", "Ljava/util/Optional;", "Ljava/util/UUID;", "<init>", "(ZLjava/util/Optional;)V", "getHasNightmare", "()Z", "setHasNightmare", "(Z)V", "getNightmareUUID", "()Ljava/util/Optional;", "setNightmareUUID", "(Ljava/util/Optional;)V", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean hasNightmare;
        @NotNull
        private Optional<UUID> nightmareUUID;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(boolean hasNightmare, @NotNull Optional<UUID> nightmareUUID) {
            Intrinsics.checkNotNullParameter(nightmareUUID, (String)"nightmareUUID");
            this.hasNightmare = hasNightmare;
            this.nightmareUUID = nightmareUUID;
        }

        public /* synthetic */ Data(boolean bl, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                Optional optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
                optional = optional2;
            }
            this(bl, optional);
        }

        public final boolean getHasNightmare() {
            return this.hasNightmare;
        }

        public final void setHasNightmare(boolean bl) {
            this.hasNightmare = bl;
        }

        @NotNull
        public final Optional<UUID> getNightmareUUID() {
            return this.nightmareUUID;
        }

        public final void setNightmareUUID(@NotNull Optional<UUID> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.nightmareUUID = optional;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.fieldOf("hasNightmare").forGetter(Data::CODEC$lambda$0$0), (App)Codecs.UUID.optionalFieldOf("nightmareUUID").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final Boolean CODEC$lambda$0$0(Data it) {
            return it.hasNightmare;
        }

        private static final Optional CODEC$lambda$0$1(Data it) {
            return it.nightmareUUID;
        }

        public Data() {
            this(false, null, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("nightmare_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/nightmare/NightmarePlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/nightmare/NightmarePlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

