/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.petrification;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncPetrificationS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/features/petrification/PetrifiedEntityAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/petrification/PetrifiedEntityAttachment$Data;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "setData", "", "data", "Data", "witchery"})
public final class PetrifiedEntityAttachment {
    @NotNull
    public static final PetrifiedEntityAttachment INSTANCE = new PetrifiedEntityAttachment();

    private PetrifiedEntityAttachment() {
    }

    @NotNull
    public final Data getData(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = entity.getData(WitcheryDataAttachments.getPETRIFIED_ENTITY());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    public final void setData(@NotNull LivingEntity entity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        entity.setData(WitcheryDataAttachments.getPETRIFIED_ENTITY(), (Object)data2);
        if (entity.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)entity), (CustomPacketPayload)new SyncPetrificationS2CPayload(entity, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b.\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 82\u00020\u0001:\u00018Bu\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0000J>\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0005J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003Jw\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u00020\u0005H\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\u00a8\u00069"}, d2={"Ldev/sterner/witchery/features/petrification/PetrifiedEntityAttachment$Data;", "", "petrified", "", "petrificationTicks", "", "totalDuration", "age", "", "limbSwing", "limbSwingAmount", "headYaw", "headPitch", "yBodyRot", "breakProgress", "playerPunchCount", "<init>", "(ZIIFFFFFFII)V", "getPetrified", "()Z", "getPetrificationTicks", "()I", "getTotalDuration", "getAge", "()F", "getLimbSwing", "getLimbSwingAmount", "getHeadYaw", "getHeadPitch", "getYBodyRot", "getBreakProgress", "getPlayerPunchCount", "isPetrified", "tick", "withPetrification", "duration", "incrementBreakProgress", "incrementPunchCount", "getBreakStage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean petrified;
        private final int petrificationTicks;
        private final int totalDuration;
        private final float age;
        private final float limbSwing;
        private final float limbSwingAmount;
        private final float headYaw;
        private final float headPitch;
        private final float yBodyRot;
        private final int breakProgress;
        private final int playerPunchCount;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(boolean petrified, int petrificationTicks, int totalDuration, float age, float limbSwing, float limbSwingAmount, float headYaw, float headPitch, float yBodyRot, int breakProgress, int playerPunchCount) {
            this.petrified = petrified;
            this.petrificationTicks = petrificationTicks;
            this.totalDuration = totalDuration;
            this.age = age;
            this.limbSwing = limbSwing;
            this.limbSwingAmount = limbSwingAmount;
            this.headYaw = headYaw;
            this.headPitch = headPitch;
            this.yBodyRot = yBodyRot;
            this.breakProgress = breakProgress;
            this.playerPunchCount = playerPunchCount;
        }

        public /* synthetic */ Data(boolean bl, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                bl = false;
            }
            if ((n5 & 2) != 0) {
                n = 0;
            }
            if ((n5 & 4) != 0) {
                n2 = 0;
            }
            if ((n5 & 8) != 0) {
                f = 0.0f;
            }
            if ((n5 & 0x10) != 0) {
                f2 = 0.0f;
            }
            if ((n5 & 0x20) != 0) {
                f3 = 0.0f;
            }
            if ((n5 & 0x40) != 0) {
                f4 = 0.0f;
            }
            if ((n5 & 0x80) != 0) {
                f5 = 0.0f;
            }
            if ((n5 & 0x100) != 0) {
                f6 = 0.0f;
            }
            if ((n5 & 0x200) != 0) {
                n3 = 0;
            }
            if ((n5 & 0x400) != 0) {
                n4 = 0;
            }
            this(bl, n, n2, f, f2, f3, f4, f5, f6, n3, n4);
        }

        public final boolean getPetrified() {
            return this.petrified;
        }

        public final int getPetrificationTicks() {
            return this.petrificationTicks;
        }

        public final int getTotalDuration() {
            return this.totalDuration;
        }

        public final float getAge() {
            return this.age;
        }

        public final float getLimbSwing() {
            return this.limbSwing;
        }

        public final float getLimbSwingAmount() {
            return this.limbSwingAmount;
        }

        public final float getHeadYaw() {
            return this.headYaw;
        }

        public final float getHeadPitch() {
            return this.headPitch;
        }

        public final float getYBodyRot() {
            return this.yBodyRot;
        }

        public final int getBreakProgress() {
            return this.breakProgress;
        }

        public final int getPlayerPunchCount() {
            return this.playerPunchCount;
        }

        public final boolean isPetrified() {
            return this.petrified && this.petrificationTicks > 0;
        }

        @NotNull
        public final Data tick() {
            if (!this.petrified || this.petrificationTicks <= 0) {
                return Data.copy$default(this, false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 510, null);
            }
            int newTicks = this.petrificationTicks - 1;
            return Data.copy$default(this, false, newTicks, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 2045, null);
        }

        @NotNull
        public final Data withPetrification(int duration, float age, float limbSwing, float limbSwingAmount, float headYaw, float headPitch, float yBodyRot) {
            return this.copy(true, duration, duration, age, limbSwing, limbSwingAmount, headYaw, headPitch, yBodyRot, 0, 0);
        }

        @NotNull
        public final Data incrementBreakProgress() {
            int newProgress = RangesKt.coerceAtMost((int)(this.breakProgress + 1), (int)9);
            return Data.copy$default(this, false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, newProgress, 0, 1535, null);
        }

        @NotNull
        public final Data incrementPunchCount() {
            return Data.copy$default(this, false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, this.playerPunchCount + 1, 1023, null);
        }

        public final int getBreakStage() {
            return RangesKt.coerceIn((int)this.breakProgress, (int)0, (int)9);
        }

        public final boolean component1() {
            return this.petrified;
        }

        public final int component2() {
            return this.petrificationTicks;
        }

        public final int component3() {
            return this.totalDuration;
        }

        public final float component4() {
            return this.age;
        }

        public final float component5() {
            return this.limbSwing;
        }

        public final float component6() {
            return this.limbSwingAmount;
        }

        public final float component7() {
            return this.headYaw;
        }

        public final float component8() {
            return this.headPitch;
        }

        public final float component9() {
            return this.yBodyRot;
        }

        public final int component10() {
            return this.breakProgress;
        }

        public final int component11() {
            return this.playerPunchCount;
        }

        @NotNull
        public final Data copy(boolean petrified, int petrificationTicks, int totalDuration, float age, float limbSwing, float limbSwingAmount, float headYaw, float headPitch, float yBodyRot, int breakProgress, int playerPunchCount) {
            return new Data(petrified, petrificationTicks, totalDuration, age, limbSwing, limbSwingAmount, headYaw, headPitch, yBodyRot, breakProgress, playerPunchCount);
        }

        public static /* synthetic */ Data copy$default(Data data2, boolean bl, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                bl = data2.petrified;
            }
            if ((n5 & 2) != 0) {
                n = data2.petrificationTicks;
            }
            if ((n5 & 4) != 0) {
                n2 = data2.totalDuration;
            }
            if ((n5 & 8) != 0) {
                f = data2.age;
            }
            if ((n5 & 0x10) != 0) {
                f2 = data2.limbSwing;
            }
            if ((n5 & 0x20) != 0) {
                f3 = data2.limbSwingAmount;
            }
            if ((n5 & 0x40) != 0) {
                f4 = data2.headYaw;
            }
            if ((n5 & 0x80) != 0) {
                f5 = data2.headPitch;
            }
            if ((n5 & 0x100) != 0) {
                f6 = data2.yBodyRot;
            }
            if ((n5 & 0x200) != 0) {
                n3 = data2.breakProgress;
            }
            if ((n5 & 0x400) != 0) {
                n4 = data2.playerPunchCount;
            }
            return data2.copy(bl, n, n2, f, f2, f3, f4, f5, f6, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Data(petrified=" + this.petrified + ", petrificationTicks=" + this.petrificationTicks + ", totalDuration=" + this.totalDuration + ", age=" + this.age + ", limbSwing=" + this.limbSwing + ", limbSwingAmount=" + this.limbSwingAmount + ", headYaw=" + this.headYaw + ", headPitch=" + this.headPitch + ", yBodyRot=" + this.yBodyRot + ", breakProgress=" + this.breakProgress + ", playerPunchCount=" + this.playerPunchCount + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.petrified);
            result = result * 31 + Integer.hashCode(this.petrificationTicks);
            result = result * 31 + Integer.hashCode(this.totalDuration);
            result = result * 31 + Float.hashCode(this.age);
            result = result * 31 + Float.hashCode(this.limbSwing);
            result = result * 31 + Float.hashCode(this.limbSwingAmount);
            result = result * 31 + Float.hashCode(this.headYaw);
            result = result * 31 + Float.hashCode(this.headPitch);
            result = result * 31 + Float.hashCode(this.yBodyRot);
            result = result * 31 + Integer.hashCode(this.breakProgress);
            result = result * 31 + Integer.hashCode(this.playerPunchCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.petrified != data2.petrified) {
                return false;
            }
            if (this.petrificationTicks != data2.petrificationTicks) {
                return false;
            }
            if (this.totalDuration != data2.totalDuration) {
                return false;
            }
            if (Float.compare(this.age, data2.age) != 0) {
                return false;
            }
            if (Float.compare(this.limbSwing, data2.limbSwing) != 0) {
                return false;
            }
            if (Float.compare(this.limbSwingAmount, data2.limbSwingAmount) != 0) {
                return false;
            }
            if (Float.compare(this.headYaw, data2.headYaw) != 0) {
                return false;
            }
            if (Float.compare(this.headPitch, data2.headPitch) != 0) {
                return false;
            }
            if (Float.compare(this.yBodyRot, data2.yBodyRot) != 0) {
                return false;
            }
            if (this.breakProgress != data2.breakProgress) {
                return false;
            }
            return this.playerPunchCount == data2.playerPunchCount;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.fieldOf("petrified").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("petrificationTicks").forGetter(Data::CODEC$lambda$0$1), (App)Codec.INT.fieldOf("totalDuration").forGetter(Data::CODEC$lambda$0$2), (App)Codec.FLOAT.fieldOf("age").forGetter(Data::CODEC$lambda$0$3), (App)Codec.FLOAT.fieldOf("limbSwing").forGetter(Data::CODEC$lambda$0$4), (App)Codec.FLOAT.fieldOf("limbSwingAmount").forGetter(Data::CODEC$lambda$0$5), (App)Codec.FLOAT.fieldOf("headYaw").forGetter(Data::CODEC$lambda$0$6), (App)Codec.FLOAT.fieldOf("headPitch").forGetter(Data::CODEC$lambda$0$7), (App)Codec.FLOAT.optionalFieldOf("yBodyRot", (Object)Float.valueOf(0.0f)).forGetter(Data::CODEC$lambda$0$8), (App)Codec.INT.optionalFieldOf("breakProgress", (Object)0).forGetter(Data::CODEC$lambda$0$9), (App)Codec.INT.optionalFieldOf("playerPunchCount", (Object)0).forGetter(Data::CODEC$lambda$0$10)).apply((Applicative)instance, Data::new);
        }

        private static final Boolean CODEC$lambda$0$0(Data it) {
            return it.petrified;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.petrificationTicks;
        }

        private static final Integer CODEC$lambda$0$2(Data it) {
            return it.totalDuration;
        }

        private static final Float CODEC$lambda$0$3(Data it) {
            return Float.valueOf(it.age);
        }

        private static final Float CODEC$lambda$0$4(Data it) {
            return Float.valueOf(it.limbSwing);
        }

        private static final Float CODEC$lambda$0$5(Data it) {
            return Float.valueOf(it.limbSwingAmount);
        }

        private static final Float CODEC$lambda$0$6(Data it) {
            return Float.valueOf(it.headYaw);
        }

        private static final Float CODEC$lambda$0$7(Data it) {
            return Float.valueOf(it.headPitch);
        }

        private static final Float CODEC$lambda$0$8(Data it) {
            return Float.valueOf(it.yBodyRot);
        }

        private static final Integer CODEC$lambda$0$9(Data it) {
            return it.breakProgress;
        }

        private static final Integer CODEC$lambda$0$10(Data it) {
            return it.playerPunchCount;
        }

        public Data() {
            this(false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 2047, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/petrification/PetrifiedEntityAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/petrification/PetrifiedEntityAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

