/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.possession;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.event.PossessionEvents;
import dev.sterner.witchery.core.api.interfaces.Possessable;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.PossessedDataAttachment;
import dev.sterner.witchery.network.SyncPossessionComponentS2CPayload;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/possession/PossessionComponentAttachment;", "", "<init>", "()V", "INHERENT_MOB_SLOWNESS_UUID", "Lnet/minecraft/resources/ResourceLocation;", "getINHERENT_MOB_SLOWNESS_UUID", "()Lnet/minecraft/resources/ResourceLocation;", "INHERENT_MOB_SLOWNESS", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "getINHERENT_MOB_SLOWNESS", "()Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "getPossessionData", "Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionData;", "player", "Lnet/minecraft/world/entity/player/Player;", "setPossessionData", "", "data", "syncToClient", "get", "Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionComponent;", "PossessionData", "PossessionComponent", "witchery"})
public final class PossessionComponentAttachment {
    @NotNull
    public static final PossessionComponentAttachment INSTANCE = new PossessionComponentAttachment();
    @NotNull
    private static final ResourceLocation INHERENT_MOB_SLOWNESS_UUID;
    @NotNull
    private static final AttributeModifier INHERENT_MOB_SLOWNESS;

    private PossessionComponentAttachment() {
    }

    @NotNull
    public final ResourceLocation getINHERENT_MOB_SLOWNESS_UUID() {
        return INHERENT_MOB_SLOWNESS_UUID;
    }

    @NotNull
    public final AttributeModifier getINHERENT_MOB_SLOWNESS() {
        return INHERENT_MOB_SLOWNESS;
    }

    @NotNull
    public final PossessionData getPossessionData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getPLAYER_POSSESSION());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (PossessionData)object;
    }

    public final void setPossessionData(@NotNull Player player, @NotNull PossessionData data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getPLAYER_POSSESSION(), (Object)data2);
        this.syncToClient(player);
    }

    public final void syncToClient(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player instanceof ServerPlayer) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncPossessionComponentS2CPayload(player, this.getPossessionData(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @NotNull
    public final PossessionComponent get(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new PossessionComponent(player);
    }

    static {
        ResourceLocation resourceLocation = Witchery.Companion.id("mob_slowness_modifier");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        INHERENT_MOB_SLOWNESS_UUID = resourceLocation;
        INHERENT_MOB_SLOWNESS = new AttributeModifier(INHERENT_MOB_SLOWNESS_UUID, -0.66, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\nJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionComponent;", "", "player", "Lnet/minecraft/world/entity/player/Player;", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "possessedEntity", "Lnet/minecraft/world/entity/Mob;", "getPlayer", "isPossessionOngoing", "", "isReadyForPossession", "startPossessing", "host", "stopPossessing", "", "transfer", "getHost", "resetState", "serverTick", "completeCuring", "Lnet/minecraft/server/level/ServerPlayer;", "startCuring", "Companion", "witchery"})
    @SourceDebugExtension(value={"SMAP\nPossessionComponentAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PossessionComponentAttachment.kt\ndev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionComponent\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,390:1\n69#2,15:391\n*S KotlinDebug\n*F\n+ 1 PossessionComponentAttachment.kt\ndev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionComponent\n*L\n292#1:391,15\n*E\n"})
    public static final class PossessionComponent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Player player;
        @Nullable
        private Mob possessedEntity;
        private static final int CURING_DURATION = 2000;

        public PossessionComponent(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.player = player;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        public final boolean isPossessionOngoing() {
            return this.possessedEntity != null;
        }

        public final boolean isReadyForPossession() {
            return this.player.level().isClientSide || !this.player.isSpectator();
        }

        public final boolean startPossessing(@NotNull Mob host) {
            Possessable possessable;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (!this.isReadyForPossession()) {
                return false;
            }
            PossessionEvents.PossessionAttempted result = new PossessionEvents.PossessionAttempted(host, this.player);
            NeoForge.EVENT_BUS.post((Event)result);
            if (result.isCanceled()) {
                return false;
            }
            Possessable possessable2 = possessable = host instanceof Possessable ? (Possessable)host : null;
            if (possessable == null) {
                return false;
            }
            if (!possessable.canBePossessedBy(this.player)) {
                return false;
            }
            possessable.setPossessor(null);
            if (!this.player.level().isClientSide) {
                PossessedDataAttachment.Data data2 = PossessedDataAttachment.INSTANCE.get((Entity)host);
                Inventory inventory = this.player.getInventory();
                Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
                data2.moveItems(inventory, false);
                for (EquipmentSlot slot : EntriesMappings.entries$0) {
                    ItemStack stuff;
                    Intrinsics.checkNotNullExpressionValue((Object)host.getItemBySlot(slot), (String)"getItemBySlot(...)");
                    if (stuff.isEmpty()) continue;
                    if (!this.player.getItemBySlot(slot).isEmpty()) {
                        this.player.spawnAtLocation(stuff, 0.5f);
                    } else {
                        this.player.setItemSlot(slot, stuff);
                    }
                    host.setItemSlot(slot, ItemStack.EMPTY);
                }
                for (MobEffectInstance effect : ((LivingEntity)host).getActiveEffects()) {
                    this.player.addEffect(new MobEffectInstance(effect));
                }
                if (((Entity)host).getType().is(WitcheryTags.INSTANCE.getREGULAR_EATER())) {
                    this.player.getFoodData().readAdditionalSaveData(PossessedDataAttachment.INSTANCE.get((Entity)host).getHungerData());
                }
                host.setTarget(null);
            }
            this.possessedEntity = host;
            PossessionData data3 = INSTANCE.getPossessionData(this.player);
            data3.setPossessedEntityId(((Entity)host).getId());
            data3.setPossessedEntityUUID(((Entity)host).getUUID());
            data3.setCuringTimer(-1);
            INSTANCE.setPossessionData(this.player, data3);
            possessable.setPossessor(this.player);
            this.player.copyPosition((Entity)host);
            this.player.refreshDimensions();
            host.playAmbientSound();
            host.setPersistenceRequired();
            PossessionEvents.PossessionStateChange event = new PossessionEvents.PossessionStateChange(this.player, host);
            NeoForge.EVENT_BUS.post((Event)event);
            return true;
        }

        public final void stopPossessing(boolean transfer) {
            Mob host = this.getHost();
            if (host == null) {
                return;
            }
            this.resetState();
            ((Possessable)host).setPossessor(null);
            if (this.player instanceof ServerPlayer) {
                Entity vehicle = ((ServerPlayer)this.player).getVehicle();
                if (vehicle != null) {
                    ((ServerPlayer)this.player).stopRiding();
                    ((Entity)host).startRiding(vehicle);
                }
                if (transfer) {
                    Companion.dropEquipment((LivingEntity)host, (ServerPlayer)this.player);
                }
                if (((Entity)host).getType().is(WitcheryTags.INSTANCE.getREGULAR_EATER())) {
                    ((ServerPlayer)this.player).getFoodData().addAdditionalSaveData(PossessedDataAttachment.INSTANCE.get((Entity)host).getHungerData());
                }
                ((LivingEntity)host).setSprinting(false);
            }
        }

        public static /* synthetic */ void stopPossessing$default(PossessionComponent possessionComponent, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = !possessionComponent.player.isCreative();
            }
            possessionComponent.stopPossessing(bl);
        }

        @Nullable
        public final Mob getHost() {
            Level level;
            Entity entity;
            PossessionData data2 = INSTANCE.getPossessionData(this.player);
            if (!data2.isPossessing()) {
                return null;
            }
            if (this.possessedEntity != null) {
                Mob mob = this.possessedEntity;
                Intrinsics.checkNotNull((Object)mob);
                if (!mob.isRemoved()) {
                    return this.possessedEntity;
                }
            }
            if ((entity = (level = this.player.level()).getEntity(data2.getPossessedEntityId())) instanceof Mob && entity instanceof Possessable) {
                this.possessedEntity = (Mob)entity;
                return (Mob)entity;
            }
            Mob mob = this.possessedEntity;
            boolean bl = mob != null ? mob.isRemoved() : false;
            if (bl) {
                this.resetState();
                if (data2.getPossessedEntityUUID() != null && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    UUID uUID = data2.getPossessedEntityUUID();
                    Intrinsics.checkNotNull((Object)uUID);
                    Entity entityByUUID = serverLevel.getEntity(uUID);
                    if (entityByUUID instanceof Mob && entityByUUID instanceof Possessable) {
                        this.startPossessing((Mob)entityByUUID);
                        return (Mob)entityByUUID;
                    }
                }
            }
            return null;
        }

        private final void resetState() {
            this.possessedEntity = null;
            PossessionData data2 = INSTANCE.getPossessionData(this.player);
            data2.setPossessedEntityId(-1);
            data2.setPossessedEntityUUID(null);
            data2.setCuringTimer(-1);
            INSTANCE.setPossessionData(this.player, data2);
            this.player.refreshDimensions();
            this.player.setAirSupply(this.player.getMaxAirSupply());
            PossessionEvents.PossessionStateChange event = new PossessionEvents.PossessionStateChange(this.player, null);
            NeoForge.EVENT_BUS.post((Event)event);
            if (this.player instanceof ServerPlayer) {
                ((ServerPlayer)this.player).connection.send((Packet)new ClientboundUpdateAttributesPacket(((ServerPlayer)this.player).getId(), (Collection)((ServerPlayer)this.player).getAttributes().getAttributesToUpdate()));
            }
        }

        public final void serverTick() {
            PossessionData data2;
            if (this.player.isSpectator()) {
                PossessionComponent.stopPossessing$default(this, false, 1, null);
            }
            if ((data2 = INSTANCE.getPossessionData(this.player)).isCuring() && this.player instanceof ServerPlayer) {
                if (data2.getCuringTimer() > 0) {
                    int n = data2.getCuringTimer();
                    data2.setCuringTimer(n + -1);
                    INSTANCE.setPossessionData(this.player, data2);
                    if (data2.getCuringTimer() % 80 == 0) {
                        Level level = this.player.level();
                        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, ((ServerPlayer)this.player).getX(), ((ServerPlayer)this.player).getY() + 1.0, ((ServerPlayer)this.player).getZ(), 5, 0.5, 0.5, 0.5, 0.05);
                    }
                } else {
                    this.completeCuring((ServerPlayer)this.player);
                }
            }
        }

        private final void completeCuring(ServerPlayer player) {
            AfflictionPlayerAttachment.Data currentData$iv;
            Mob host = this.getHost();
            this.stopPossessing(true);
            Mob mob = host;
            if (mob != null) {
                mob.discard();
            }
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$completeCuring_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$completeCuring_u24lambda_u240.withSoulForm(false).withVagrant(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS, 1.0f, 1.0f);
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, player.getX(), player.getY() + 1.0, player.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, 1));
        }

        public final void startCuring() {
            PossessionData data2 = INSTANCE.getPossessionData(this.player);
            if (data2.isPossessing() && !data2.isCuring()) {
                data2.setCuringTimer(2000);
                INSTANCE.setPossessionData(this.player, data2);
                this.player.level().playSound(null, this.player.getX(), this.player.getY(), this.player.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.PLAYERS, 1.0f, 0.7f);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionComponent$Companion;", "", "<init>", "()V", "CURING_DURATION", "", "cure", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingEntityUseItemEvent$Finish;", "dropEquipment", "possessed", "Lnet/minecraft/world/entity/LivingEntity;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            public final void cure(@NotNull LivingEntityUseItemEvent.Finish event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LivingEntity entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) {
                    return;
                }
                PossessionData data2 = INSTANCE.getPossessionData((Player)entity);
                if (!data2.isPossessing()) {
                    return;
                }
                PossessionComponent component = INSTANCE.get((Player)entity);
                Mob mob = component.getHost();
                if (mob == null) {
                    return;
                }
                Mob host = mob;
                if (!host.getType().is(EntityTypeTags.UNDEAD)) {
                    return;
                }
                ItemStack item = event.getItem();
                if (!item.is(Items.GOLDEN_APPLE) && !item.is(Items.ENCHANTED_GOLDEN_APPLE)) {
                    return;
                }
                if (!((ServerPlayer)entity).hasEffect(MobEffects.WEAKNESS)) {
                    return;
                }
                component.startCuring();
                ((ServerPlayer)entity).removeEffect(MobEffects.WEAKNESS);
            }

            public final void dropEquipment(@NotNull LivingEntity possessed, @NotNull ServerPlayer player) {
                Intrinsics.checkNotNullParameter((Object)possessed, (String)"possessed");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                PossessionEvents.ShouldTransferInventory event = new PossessionEvents.ShouldTransferInventory((Player)player, possessed);
                if (!event.isCanceled()) {
                    for (EquipmentSlot slot : EntriesMappings.entries$0) {
                        ItemStack stuff;
                        Intrinsics.checkNotNullExpressionValue((Object)player.getItemBySlot(slot), (String)"getItemBySlot(...)");
                        if (stuff.isEmpty()) continue;
                        if (!possessed.getItemBySlot(slot).isEmpty()) {
                            possessed.spawnAtLocation(stuff, 0.5f);
                        } else {
                            possessed.setItemSlot(slot, stuff);
                        }
                        player.setItemSlot(slot, ItemStack.EMPTY);
                    }
                    PossessedDataAttachment.Data data2 = PossessedDataAttachment.INSTANCE.get((Entity)possessed);
                    Inventory inventory = player.getInventory();
                    Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
                    data2.moveItems(inventory, true);
                    player.getInventory().dropAll();
                }
                player.removeAllEffects();
                PossessionEvents.CleanUpAfterDissociation event2 = new PossessionEvents.CleanUpAfterDissociation((Player)player, possessed);
                NeoForge.EVENT_BUS.post((Event)event2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class EntriesMappings {
                public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

                static {
                    entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionData;", "", "possessedEntityId", "", "possessedEntityUUID", "Ljava/util/UUID;", "curingTimer", "<init>", "(ILjava/util/UUID;I)V", "getPossessedEntityId", "()I", "setPossessedEntityId", "(I)V", "getPossessedEntityUUID", "()Ljava/util/UUID;", "setPossessedEntityUUID", "(Ljava/util/UUID;)V", "getCuringTimer", "setCuringTimer", "isPossessing", "", "isCuring", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class PossessionData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int possessedEntityId;
        @Nullable
        private UUID possessedEntityUUID;
        private int curingTimer;
        @NotNull
        private static final Codec<PossessionData> CODEC;

        public PossessionData(int possessedEntityId, @Nullable UUID possessedEntityUUID, int curingTimer) {
            this.possessedEntityId = possessedEntityId;
            this.possessedEntityUUID = possessedEntityUUID;
            this.curingTimer = curingTimer;
        }

        public /* synthetic */ PossessionData(int n, UUID uUID, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                uUID = null;
            }
            if ((n3 & 4) != 0) {
                n2 = -1;
            }
            this(n, uUID, n2);
        }

        public final int getPossessedEntityId() {
            return this.possessedEntityId;
        }

        public final void setPossessedEntityId(int n) {
            this.possessedEntityId = n;
        }

        @Nullable
        public final UUID getPossessedEntityUUID() {
            return this.possessedEntityUUID;
        }

        public final void setPossessedEntityUUID(@Nullable UUID uUID) {
            this.possessedEntityUUID = uUID;
        }

        public final int getCuringTimer() {
            return this.curingTimer;
        }

        public final void setCuringTimer(int n) {
            this.curingTimer = n;
        }

        public final boolean isPossessing() {
            return this.possessedEntityId != -1;
        }

        public final boolean isCuring() {
            return this.curingTimer >= 0;
        }

        public final int component1() {
            return this.possessedEntityId;
        }

        @Nullable
        public final UUID component2() {
            return this.possessedEntityUUID;
        }

        public final int component3() {
            return this.curingTimer;
        }

        @NotNull
        public final PossessionData copy(int possessedEntityId, @Nullable UUID possessedEntityUUID, int curingTimer) {
            return new PossessionData(possessedEntityId, possessedEntityUUID, curingTimer);
        }

        public static /* synthetic */ PossessionData copy$default(PossessionData possessionData, int n, UUID uUID, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = possessionData.possessedEntityId;
            }
            if ((n3 & 2) != 0) {
                uUID = possessionData.possessedEntityUUID;
            }
            if ((n3 & 4) != 0) {
                n2 = possessionData.curingTimer;
            }
            return possessionData.copy(n, uUID, n2);
        }

        @NotNull
        public String toString() {
            return "PossessionData(possessedEntityId=" + this.possessedEntityId + ", possessedEntityUUID=" + this.possessedEntityUUID + ", curingTimer=" + this.curingTimer + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.possessedEntityId);
            result = result * 31 + (this.possessedEntityUUID == null ? 0 : this.possessedEntityUUID.hashCode());
            result = result * 31 + Integer.hashCode(this.curingTimer);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PossessionData)) {
                return false;
            }
            PossessionData possessionData = (PossessionData)other;
            if (this.possessedEntityId != possessionData.possessedEntityId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.possessedEntityUUID, (Object)possessionData.possessedEntityUUID)) {
                return false;
            }
            return this.curingTimer == possessionData.curingTimer;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.optionalFieldOf("possessedEntityId", (Object)-1).forGetter(PossessionData::CODEC$lambda$0$0), (App)Codec.STRING.optionalFieldOf("possessedEntityUUID", (Object)"").xmap(arg_0 -> PossessionData.CODEC$lambda$0$2(PossessionData::CODEC$lambda$0$1, arg_0), arg_0 -> PossessionData.CODEC$lambda$0$4(PossessionData::CODEC$lambda$0$3, arg_0)).forGetter(PossessionData::CODEC$lambda$0$5), (App)Codec.INT.optionalFieldOf("curingTimer", (Object)-1).forGetter(PossessionData::CODEC$lambda$0$6)).apply((Applicative)instance, PossessionData::CODEC$lambda$0$7);
        }

        private static final Integer CODEC$lambda$0$0(PossessionData it) {
            return it.possessedEntityId;
        }

        private static final UUID CODEC$lambda$0$1(String it) {
            Intrinsics.checkNotNull((Object)it);
            return ((CharSequence)it).length() == 0 ? null : UUID.fromString(it);
        }

        private static final UUID CODEC$lambda$0$2(Function1 $tmp0, Object p0) {
            return (UUID)$tmp0.invoke(p0);
        }

        private static final String CODEC$lambda$0$3(UUID it) {
            Object object = it;
            if (object == null || (object = ((UUID)object).toString()) == null) {
                object = "";
            }
            return object;
        }

        private static final String CODEC$lambda$0$4(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final UUID CODEC$lambda$0$5(PossessionData it) {
            UUID uUID = it.possessedEntityUUID;
            if (uUID == null) {
                uUID = new UUID(0L, 0L);
            }
            return uUID;
        }

        private static final Integer CODEC$lambda$0$6(PossessionData it) {
            return it.curingTimer;
        }

        private static final PossessionData CODEC$lambda$0$7(Integer entityId, UUID uuid, Integer curing) {
            Intrinsics.checkNotNull((Object)entityId);
            int n = entityId;
            UUID uUID = Intrinsics.areEqual((Object)uuid, (Object)new UUID(0L, 0L)) ? null : uuid;
            Intrinsics.checkNotNull((Object)curing);
            return new PossessionData(n, uUID, curing);
        }

        public PossessionData() {
            this(0, null, 0, 7, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(PossessionData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/possession/PossessionComponentAttachment$PossessionData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<PossessionData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

