/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.features.ritual.RainingToadAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/ritual/RainingToadRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "tickCounter", "", "onStartRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "onTickRitual", "", "pos", "onEndRitual", "witchery"})
public final class RainingToadRitual
extends Ritual {
    private int tickCounter;

    public RainingToadRitual() {
        super("raining_toad");
    }

    @Override
    public boolean onStartRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        super.onStartRitual(level, blockPos, goldenChalkBlockEntity);
        this.tickCounter = 0;
        if (!level.isClientSide) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setWeatherParameters(0, 6000, true, false);
        }
        return true;
    }

    @Override
    public void onTickRitual(@NotNull Level level, @NotNull BlockPos pos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        super.onTickRitual(level, pos, goldenChalkBlockEntity);
        if (level.isClientSide) {
            return;
        }
        int n = this.tickCounter;
        this.tickCounter = n + 1;
        if (this.tickCounter % 100 == 0) {
            Frog frog = (Frog)EntityType.FROG.create(level);
            if (frog == null) {
                return;
            }
            Frog frog2 = frog;
            int dx = level.random.nextInt(65) - 32;
            int dz = level.random.nextInt(65) - 32;
            double spawnX = (double)pos.getX() + (double)dx;
            double spawnZ = (double)pos.getZ() + (double)dz;
            int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)spawnX, (int)spawnZ);
            double spawnY = (double)surfaceY + 40.0;
            frog2.setPos(spawnX, spawnY, spawnZ);
            RainingToadAttachment.Data data2 = new RainingToadAttachment.Data(true, true);
            RainingToadAttachment.setData((LivingEntity)frog2, data2);
            level.addFreshEntity((Entity)frog2);
        }
    }

    @Override
    public void onEndRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        super.onEndRitual(level, blockPos, goldenChalkBlockEntity);
        if (!level.isClientSide) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setWeatherParameters(6000, 0, false, false);
        }
    }
}

