/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/features/ritual/ResurrectFamiliarRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "onEndRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "witchery"})
public final class ResurrectFamiliarRitual
extends Ritual {
    public ResurrectFamiliarRitual() {
        ResourceLocation resourceLocation = Witchery.Companion.id("resurrect_familiar");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        super(resourceLocation);
    }

    @Override
    public void onEndRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        if (level instanceof ServerLevel) {
            AABB area = AABB.ofSize((Vec3)blockPos.getCenter(), (double)11.0, (double)5.0, (double)11.0);
            List playersInArea = level.getEntitiesOfClass(Player.class, area);
            Intrinsics.checkNotNull((Object)playersInArea);
            if (!((Collection)playersInArea).isEmpty()) {
                for (Player player : playersInArea) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    UUID uUID = player.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    boolean bl = FamiliarHandler.INSTANCE.resurrectDeadFamiliar(serverLevel, uUID, blockPos);
                    if (bl) continue;
                    Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)blockEntity);
                }
            }
        }
    }
}

