/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.spirit_world;

import dev.sterner.witchery.core.api.TeleportRequest;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.features.misc.TeleportQueueHandler;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/spirit_world/ManifestationHandler;", "", "<init>", "()V", "MAX_TIME", "", "setHasRiteOfManifestation", "", "player", "Lnet/minecraft/world/entity/player/Player;", "hasRite", "", "setManifestationTimer", "tick", "server", "Lnet/minecraft/server/MinecraftServer;", "witchery"})
@SourceDebugExtension(value={"SMAP\nManifestationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestationHandler.kt\ndev/sterner/witchery/features/spirit_world/ManifestationHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1869#2,2:70\n*S KotlinDebug\n*F\n+ 1 ManifestationHandler.kt\ndev/sterner/witchery/features/spirit_world/ManifestationHandler\n*L\n38#1:70,2\n*E\n"})
public final class ManifestationHandler {
    @NotNull
    public static final ManifestationHandler INSTANCE = new ManifestationHandler();
    public static final int MAX_TIME = 2400;

    private ManifestationHandler() {
    }

    public final void setHasRiteOfManifestation(@NotNull Player player, boolean hasRite) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ManifestationPlayerAttachment.Data old = ManifestationPlayerAttachment.getData(player);
        old.setHasRiteOfManifestation(hasRite);
        ManifestationPlayerAttachment.setData(player, old);
        WitcheryApi.INSTANCE.makePlayerWitchy(player);
    }

    public final void setManifestationTimer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ManifestationPlayerAttachment.Data data2 = ManifestationPlayerAttachment.getData(player);
        data2.setManifestationTimer(2400);
        ManifestationPlayerAttachment.setData(player, data2);
    }

    public final void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNull((Object)player);
            ManifestationPlayerAttachment.Data data2 = ManifestationPlayerAttachment.getData((Player)player);
            if (data2.getManifestationTimer() <= 0) continue;
            data2.setManifestationTimer(data2.getManifestationTimer() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)player.getArmorSlots(), (String)"getArmorSlots(...)");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack stack = (ItemStack)element$iv;
                boolean bl = false;
                if (stack.isEmpty()) continue;
                player.drop(stack.split(stack.getCount()), false);
            }
            if (data2.getManifestationTimer() <= 0) {
                ServerLevel overworld = server.overworld();
                UUID uUID = player.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                Intrinsics.checkNotNull((Object)overworld);
                SleepingLevelAttachment.PlayerSleepingData sleepingData = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(uUID, overworld);
                player.getInventory().dropAll();
                if (sleepingData != null) {
                    ChunkPos chunkPos = new ChunkPos(sleepingData.getPos());
                    overworld.setChunkForced(chunkPos.x, chunkPos.z, true);
                    UUID uUID2 = player.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
                    TeleportQueueHandler.INSTANCE.addRequest(overworld, new TeleportRequest(uUID2, sleepingData.getPos(), chunkPos, player.level().getGameTime(), 0, null, 48, null));
                }
            }
            ManifestationPlayerAttachment.setData((Player)player, data2);
        }
    }
}

