/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.features.tarot.TarotEffect;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/features/tarot/TheMoonEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onTick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onNightfall", "witchery"})
public final class TheMoonEffect
extends TarotEffect {
    public TheMoonEffect() {
        super(19);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_moon.reversed" : "tarot.witchery.the_moon"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_moon.reversed.description" : "tarot.witchery.the_moon.description"));
    }

    @Override
    public void onTick(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 220, 0, true, false));
            if (!player.level().isDay() && player.level().getGameTime() % (long)80 == 0L) {
                List nearbyMobs = player.level().getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(16.0));
                for (Mob mob : nearbyMobs) {
                    if (!Intrinsics.areEqual((Object)mob.getTarget(), (Object)player) || !(player.level().random.nextFloat() < 0.3f)) continue;
                    mob.setTarget(null);
                }
            }
        } else if (player.level().isDay() && player.level().getGameTime() % (long)100 == 0L && player.level().random.nextFloat() < 0.05f) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, false, true));
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC};
            player.displayClientMessage((Component)Component.literal((String)"The harsh light overwhelms your senses!").withStyle(chatFormattingArray), true);
        }
    }

    @Override
    public void onNightfall(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 12000, 1));
        }
    }
}

