/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.features.tarot.TarotEffect;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/tarot/TheWorldEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onTick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onMorning", "onBlockBreak", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "witchery"})
public final class TheWorldEffect
extends TarotEffect {
    public TheWorldEffect() {
        super(22);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_world.reversed" : "tarot.witchery.the_world"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_world.reversed.description" : "tarot.witchery.the_world.description"));
    }

    @Override
    public void onTick(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MobEffects.MOVEMENT_SPEED, (Object)0), TuplesKt.to((Object)MobEffects.DIG_SPEED, (Object)0), TuplesKt.to((Object)MobEffects.LUCK, (Object)0), TuplesKt.to((Object)MobEffects.REGENERATION, (Object)0)};
            List effects = CollectionsKt.listOf((Object[])pairArray);
            for (Pair pair : effects) {
                Holder effect = (Holder)pair.component1();
                int level = ((Number)pair.component2()).intValue();
                if (player.hasEffect(effect)) continue;
                player.addEffect(new MobEffectInstance(effect, 400, level, true, false));
            }
        } else if (player.level().getGameTime() % (long)600 == 0L) {
            Object[] objectArray = new Holder[]{MobEffects.MOVEMENT_SLOWDOWN, MobEffects.DIG_SLOWDOWN, MobEffects.WEAKNESS, MobEffects.UNLUCK};
            List debuffs = CollectionsKt.listOf((Object[])objectArray);
            player.addEffect(new MobEffectInstance((Holder)CollectionsKt.random((Collection)debuffs, (Random)((Random)Random.Default)), 200, 0));
        }
    }

    @Override
    public void onMorning(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            player.giveExperiencePoints(10);
        }
    }

    @Override
    public void onBlockBreak(@NotNull Player player, @NotNull BlockState blockState, @NotNull BlockPos pos, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!isReversed && player.level().random.nextFloat() < 0.1f) {
            Block.popResource((Level)player.level(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)blockState.getBlock().asItem()));
        }
    }
}

