/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.recipe.oven.OvenCookingRecipe;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.integration.emi.WitcheryEmiPlugin;
import dev.sterner.witchery.integration.emi.WitcherySlotWidget;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/integration/emi/OvenCookingEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "recipeId", "Lnet/minecraft/resources/ResourceLocation;", "recipe", "Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "smokingRecipe", "Lnet/minecraft/world/item/crafting/SmokingRecipe;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;Lnet/minecraft/world/item/crafting/SmokingRecipe;)V", "getRecipeId", "()Lnet/minecraft/resources/ResourceLocation;", "getRecipe", "()Ldev/sterner/witchery/content/recipe/oven/OvenCookingRecipe;", "getSmokingRecipe", "()Lnet/minecraft/world/item/crafting/SmokingRecipe;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "getInputs", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "getOutputs", "Ldev/emi/emi/api/stack/EmiStack;", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "witchery"})
public final class OvenCookingEmiRecipe
implements EmiRecipe {
    @NotNull
    private final ResourceLocation recipeId;
    @Nullable
    private final OvenCookingRecipe recipe;
    @Nullable
    private final SmokingRecipe smokingRecipe;

    public OvenCookingEmiRecipe(@NotNull ResourceLocation recipeId, @Nullable OvenCookingRecipe recipe, @Nullable SmokingRecipe smokingRecipe) {
        Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
        this.recipeId = recipeId;
        this.recipe = recipe;
        this.smokingRecipe = smokingRecipe;
    }

    @NotNull
    public final ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @Nullable
    public final OvenCookingRecipe getRecipe() {
        return this.recipe;
    }

    @Nullable
    public final SmokingRecipe getSmokingRecipe() {
        return this.smokingRecipe;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return WitcheryEmiPlugin.Companion.getOVEN_COOKING_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipeId;
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        List mutableList = new ArrayList();
        if (this.recipe != null) {
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)this.recipe.getIngredient());
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            mutableList.add(emiIngredient);
            EmiIngredient emiIngredient2 = EmiIngredient.of((Ingredient)this.recipe.getExtraIngredient());
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient2, (String)"of(...)");
            v2 = mutableList.add(emiIngredient2);
        } else {
            SmokingRecipe smokingRecipe = this.smokingRecipe;
            Intrinsics.checkNotNull((Object)smokingRecipe);
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)((Ingredient)smokingRecipe.getIngredients().get(0)));
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            v2 = mutableList.add(emiIngredient);
        }
        return mutableList;
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        List mutableList = new ArrayList();
        if (this.recipe != null) {
            EmiStack emiStack = EmiStack.of((ItemStack)this.recipe.getResult());
            Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
            mutableList.add(emiStack);
            EmiStack emiStack2 = EmiStack.of((ItemStack)this.recipe.getExtraOutput());
            Intrinsics.checkNotNullExpressionValue((Object)emiStack2, (String)"of(...)");
            v2 = mutableList.add(emiStack2);
        } else {
            SmokingRecipe smokingRecipe = this.smokingRecipe;
            Intrinsics.checkNotNull((Object)smokingRecipe);
            EmiStack emiStack = EmiStack.of((ItemStack)smokingRecipe.getResultItem(null));
            Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
            mutableList.add(emiStack);
            EmiStack emiStack3 = EmiStack.of((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getFOUL_FUME().get()));
            Intrinsics.checkNotNullExpressionValue((Object)emiStack3, (String)"of(...)");
            v2 = mutableList.add(emiStack3);
        }
        return mutableList;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 108;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(Witchery.Companion.id("textures/gui/oven_emi.png"), 18, 9, 108, 57, 0, 0);
        OvenCookingRecipe ovenCookingRecipe = this.recipe;
        if (ovenCookingRecipe == null || (ovenCookingRecipe = ovenCookingRecipe.getResult()) == null) {
            SmokingRecipe smokingRecipe = this.smokingRecipe;
            Intrinsics.checkNotNull((Object)smokingRecipe);
            ovenCookingRecipe = smokingRecipe.getResultItem(null);
        }
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)ovenCookingRecipe), 79, 28, 0.0, 8, null).drawBack(false).recipeContext((EmiRecipe)this));
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)(this.recipe != null ? this.recipe.getExtraIngredient().getItems()[0] : ((Item)WitcheryItems.INSTANCE.getJAR().get()).getDefaultInstance())), 107, 48, 0.0, 8, null).drawBack(false));
        OvenCookingRecipe ovenCookingRecipe2 = this.recipe;
        if (ovenCookingRecipe2 == null || (ovenCookingRecipe2 = ovenCookingRecipe2.getExtraOutput()) == null) {
            ovenCookingRecipe2 = ((Item)WitcheryItems.INSTANCE.getFOUL_FUME().get()).getDefaultInstance();
        }
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)ovenCookingRecipe2), 107, 9, 0.0, 8, null).drawBack(false).recipeContext((EmiRecipe)this));
        if (this.recipe != null) {
            itemStack = this.recipe.getIngredient().getItems()[0];
        } else {
            SmokingRecipe smokingRecipe = this.smokingRecipe;
            Intrinsics.checkNotNull((Object)smokingRecipe);
            itemStack = ((Ingredient)smokingRecipe.getIngredients().get(0)).getItems()[0];
        }
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)itemStack), 19, 10, 0.0, 8, null).drawBack(false));
    }
}

