/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.recipe.cauldron.CauldronBrewingRecipe;
import dev.sterner.witchery.content.recipe.cauldron.ItemStackWithColor;
import dev.sterner.witchery.core.api.multiblock.MultiBlockItem;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.integration.jei.WitcheryJeiPlugin;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/integration/jei/CauldronBrewingRecipeCategory;", "Lmezz/jei/api/recipe/category/IRecipeCategory;", "Ldev/sterner/witchery/content/recipe/cauldron/CauldronBrewingRecipe;", "guiHelper", "Lmezz/jei/api/helpers/IJeiHelpers;", "<init>", "(Lmezz/jei/api/helpers/IJeiHelpers;)V", "getGuiHelper", "()Lmezz/jei/api/helpers/IJeiHelpers;", "setGuiHelper", "getRecipeType", "Lmezz/jei/api/recipe/RecipeType;", "getTitle", "Lnet/minecraft/network/chat/Component;", "getBackground", "Lmezz/jei/api/gui/drawable/IDrawable;", "getIcon", "setRecipe", "", "builder", "Lmezz/jei/api/gui/builder/IRecipeLayoutBuilder;", "recipe", "focuses", "Lmezz/jei/api/recipe/IFocusGroup;", "draw", "recipeSlotsView", "Lmezz/jei/api/gui/ingredient/IRecipeSlotsView;", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "witchery"})
public final class CauldronBrewingRecipeCategory
implements IRecipeCategory<CauldronBrewingRecipe> {
    @NotNull
    private IJeiHelpers guiHelper;

    public CauldronBrewingRecipeCategory(@NotNull IJeiHelpers guiHelper) {
        Intrinsics.checkNotNullParameter((Object)guiHelper, (String)"guiHelper");
        this.guiHelper = guiHelper;
    }

    @NotNull
    public final IJeiHelpers getGuiHelper() {
        return this.guiHelper;
    }

    public final void setGuiHelper(@NotNull IJeiHelpers iJeiHelpers) {
        Intrinsics.checkNotNullParameter((Object)iJeiHelpers, (String)"<set-?>");
        this.guiHelper = iJeiHelpers;
    }

    @NotNull
    public RecipeType<CauldronBrewingRecipe> getRecipeType() {
        return WitcheryJeiPlugin.Companion.getCAULDRON_BREWING();
    }

    @NotNull
    public Component getTitle() {
        MutableComponent mutableComponent = Component.translatable((String)"witchery.cauldron_brewing.category");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public IDrawable getBackground() {
        IDrawableStatic iDrawableStatic = this.guiHelper.getGuiHelper().createBlankDrawable(144, 162);
        Intrinsics.checkNotNullExpressionValue((Object)iDrawableStatic, (String)"createBlankDrawable(...)");
        return (IDrawable)iDrawableStatic;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.getGuiHelper().createDrawableItemStack(((MultiBlockItem)((Object)WitcheryItems.INSTANCE.getCAULDRON().get())).getDefaultInstance());
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CauldronBrewingRecipe recipe, @NotNull IFocusGroup focuses) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)focuses, (String)"focuses");
        IDrawableBuilder drawableBuilder = this.guiHelper.getGuiHelper().drawableBuilder(Witchery.Companion.id("textures/gui/order_widget.png"), 0, 0, 48, 18);
        drawableBuilder.setTextureSize(48, 18);
        Iterator iterator = ((Iterable)recipe.getInputItems()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ItemStackWithColor ingredient = (ItemStackWithColor)iterator.next();
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 22, 20 * index).addItemStack(ingredient.getItemStack())).setBackground((IDrawable)drawableBuilder.build(), -18, -1);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 8).addItemStack(Items.GLASS_BOTTLE.getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 8).addItemStack(recipe.getOutputItem());
    }

    public void draw(@NotNull CauldronBrewingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)recipeSlotsView, (String)"recipeSlotsView");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.blit(Witchery.Companion.id("textures/gui/cauldron.png"), 75, 10, 0.0f, 0.0f, 35, 56, 35, 56);
        Iterator iterator = ((Iterable)recipe.getInputItems()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ItemStackWithColor ingredient = (ItemStackWithColor)iterator.next();
            int order = ingredient.getOrder();
            boolean bl = 0 <= order ? order < 9 : false;
            if (!bl) continue;
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, Witchery.Companion.id("textures/gui/index_" + (order + 1) + ".png"), 6, 20 * index + 2, 0.0f, 0.0f, 13, 13, 13, 13, 0.0f, 0, 3072, null);
        }
        boolean bl = false;
        if (!((Collection)recipe.getDimensionKey()).isEmpty()) {
            Iterator iterator2 = ((Iterable)recipe.getDimensionKey()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int index = n2++;
                String key = (String)iterator2.next();
                if (((CharSequence)key).length() > 0) {
                    bl = true;
                }
                MutableComponent text = Component.translatable((String)key);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)text, this.getWidth() / 4 + 18 + 18, 72 + 14 * index, 0xFFFFFF, true);
            }
        }
        if (!bl) {
            MutableComponent text = Component.translatable((String)"witchery:all_worlds");
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)text, this.getWidth() / 4 + 18 + 18, 72, 0xFFFFFF, true);
        }
    }
}

